/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.glassfish.admingui.common.util.GuiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogViewHandlers {
    public static final String GET_DATE_SHORT = "short";
    public static final String GET_DATE_MEDIUM = "medium";
    public static final String GET_DATE_LONG = "long";
    public static final String GET_DATE_FULL = "full";
    public static final String TIME_FORMAT = " HH:mm:ss.SSS";
    public static final String TIME_FORMAT_2 = " HH:mm:ss";
    public static final String TIME_FORMAT_3 = " HH:mm";
    public static final Integer DEFAULT_NUMBER_TO_DISPLAY = new Integer(40);
    public static final String FIRST_LOG_ROW = "firstLogRow";
    public static final int FROM_RECORD = 0;
    public static final String LAST_LOG_ROW = "lastLogRow";
    public static final String CUSTOM_LOGGER_DELIMITERS = " \t\n\r\f,;:";
    public static final String NVP_DELIMITERS = " \t\n\r\f,;:";
    public static final char EQUALS = '=';
    public static final String SHOW_LEVEL_IMAGE = "showLevelImage";
    public static final String LEVEL_IMAGE_ROOT = "/com_sun_web_ui/images/alerts/";
    public static final long ONE_HOUR = 3600000L;

    public static void getLogQueryAttributes(HandlerContext handlerCtx) {
        HashMap<String, Object> attMap = new HashMap<String, Object>();
        String logFileName = (String)handlerCtx.getInputValue("LogFileName");
        Integer fromRecord = (Integer)handlerCtx.getInputValue("FromRecord");
        Boolean after = (Boolean)handlerCtx.getInputValue("AfterRecord");
        String dateEnabledString = (String)handlerCtx.getInputValue("DateEnabled");
        Object fromDate = handlerCtx.getInputValue("FromDate");
        Object fromTime = handlerCtx.getInputValue("FromTime");
        Object toDate = handlerCtx.getInputValue("ToDate");
        Object toTime = handlerCtx.getInputValue("ToTime");
        Object loggers = handlerCtx.getInputValue("Loggers");
        String logLevel = (String)handlerCtx.getInputValue("LogLevel");
        Object customLoggers = handlerCtx.getInputValue("CustomLoggers");
        String anySearch = (String)handlerCtx.getInputValue("anySearch");
        Integer numberToDisplay = (Integer)handlerCtx.getInputValue("NumToDisplay");
        Boolean onlyLevel = (Boolean)handlerCtx.getInputValue("OnlyLevel");
        Boolean direction = (Boolean)handlerCtx.getInputValue("LogDateSortDirection");
        String instanceName = (String)handlerCtx.getInputValue("InstanceName");
        ArrayList result = new ArrayList();
        String logFileDir = "";
        Boolean hasResults = Boolean.FALSE;
        if (instanceName != null && logFileName != null) {
            int len;
            if (dateEnabledString != null && ("enabled".equalsIgnoreCase(dateEnabledString) || "true".equalsIgnoreCase(dateEnabledString))) {
                fromDate = LogViewHandlers.convertDateTime(handlerCtx, fromDate, fromTime);
                toDate = LogViewHandlers.convertDateTime(handlerCtx, toDate, toTime);
                if (fromDate == null) {
                    GuiUtil.handleError(handlerCtx, "Specific Date Range was chosen, however, date fields are incomplete.");
                }
                if (toDate != null && fromDate != null && ((Date)fromDate).after((Date)toDate)) {
                    GuiUtil.handleError(handlerCtx, "Timestamp value of 'From: ' field " + fromDate + " must not be greater than 'To: ' field value " + toDate);
                }
            } else {
                fromDate = null;
                toDate = null;
            }
            if (logLevel != null && logLevel.trim().length() == 0) {
                logLevel = null;
            }
            HashSet<Object> moduleList = null;
            if (loggers != null && (len = ((Object[])loggers).length) > 0) {
                moduleList = new HashSet<Object>();
                for (int count = 0; count < len; ++count) {
                    Object val = ((Object[])loggers)[count];
                    if (val == null || val.toString().trim().length() == 0) continue;
                    moduleList.add(val);
                }
            }
            if (customLoggers != null && customLoggers.toString().trim().length() != 0) {
                StringTokenizer tok = new StringTokenizer(customLoggers.toString(), " \t\n\r\f,;:");
                if (moduleList == null) {
                    moduleList = new HashSet();
                }
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (token == null || token.length() == 0) continue;
                    moduleList.add(token);
                }
            }
            if (numberToDisplay == null) {
                numberToDisplay = DEFAULT_NUMBER_TO_DISPLAY;
            }
            if (direction == null) {
                direction = Boolean.FALSE;
            }
            if (after == null) {
                after = direction;
            }
            LogViewHandlers.notNullStringPut(attMap, "logFileName", logFileName);
            LogViewHandlers.notNullStringPut(attMap, "startIndex", fromRecord);
            LogViewHandlers.notNullStringPut(attMap, "searchForward", after);
            LogViewHandlers.notNullStringPut(attMap, "maximumNumberOfResults", numberToDisplay);
            LogViewHandlers.notNullStringPut(attMap, "onlyLevel", onlyLevel);
            LogViewHandlers.notNullStringPut(attMap, "fromTime", fromDate);
            LogViewHandlers.notNullStringPut(attMap, "toTime", toDate);
            LogViewHandlers.notNullStringPut(attMap, "anySearch", anySearch);
            LogViewHandlers.notNullStringPut(attMap, "logLevel", logLevel);
            LogViewHandlers.notNullStringPut(attMap, "instanceName", instanceName);
            if (moduleList != null) {
                attMap.put("listOfModules", moduleList);
            }
        }
        handlerCtx.setOutputValue("attributes", attMap);
    }

    public static void processLogRecords(HandlerContext handlerCtx) {
        List records = (List)handlerCtx.getInputValue("logRecords");
        if (records != null) {
            boolean truncate = (Boolean)handlerCtx.getInputValue("truncate");
            int truncLen = (Integer)handlerCtx.getInputValue("truncateLength");
            Locale locale = GuiUtil.getLocale();
            for (Map record : records) {
                record.put("dateTime", LogViewHandlers.formatDateForDisplay(locale, new Date(new Long(record.get("loggedDateTimeInMS").toString()))));
                String message = ((String)record.get("Message")).trim();
                if (truncate && message.length() > truncLen) {
                    message = message.substring(0, truncLen).concat("...\n");
                }
                record.put("Message", message == null ? " " : Util.htmlEscape((String)message));
            }
        }
        if (records != null && records.size() > 1) {
            handlerCtx.setOutputValue("firstRecord", ((Map)records.get(0)).get("recordNumber"));
            handlerCtx.setOutputValue("lastRecord", ((Map)records.get(records.size() - 1)).get("recordNumber"));
        } else {
            handlerCtx.setOutputValue("firstRecord", (Object)"-1");
            handlerCtx.setOutputValue("lastRecord", (Object)"-1");
        }
        handlerCtx.setOutputValue("result", (Object)records);
    }

    private static void notNullStringPut(Map<String, Object> map, String key, Object val) {
        if (val != null) {
            map.put(key, val.toString());
        }
    }

    protected static Date convertDateTime(HandlerContext handlerCtx, Object date, Object time) {
        if (date instanceof Date) {
            return (Date)date;
        }
        if (date == null || date.toString().trim().length() == 0) {
            return null;
        }
        if (time != null && time.toString().trim().length() == 0) {
            time = null;
        }
        String dateTime = date.toString() + (time == null ? "" : " " + time.toString());
        DateFormat df = DateFormat.getDateInstance(3, GuiUtil.getLocale());
        if (time != null && df instanceof SimpleDateFormat) {
            SimpleDateFormat fmt = (SimpleDateFormat)df;
            String formatPrefix = fmt.toLocalizedPattern();
            try {
                date = LogViewHandlers.parseDateString(fmt, formatPrefix + TIME_FORMAT, dateTime);
            }
            catch (ParseException ex) {
                try {
                    date = LogViewHandlers.parseDateString(fmt, formatPrefix + TIME_FORMAT_2, dateTime);
                }
                catch (ParseException ex2) {
                    try {
                        date = LogViewHandlers.parseDateString(fmt, formatPrefix + TIME_FORMAT_3, dateTime);
                    }
                    catch (ParseException ex3) {
                        GuiUtil.handleError(handlerCtx, "Unable to parse Date/Time: '" + dateTime + "'.");
                    }
                }
            }
        } else if (time != null) {
            df = DateFormat.getDateTimeInstance(3, 1, GuiUtil.getLocale());
            try {
                date = df.parse(dateTime);
            }
            catch (ParseException ex) {
                GuiUtil.handleError(handlerCtx, "Unable to parse Date/Time: '" + dateTime + "'.");
            }
        } else {
            try {
                date = df.parse(dateTime);
            }
            catch (ParseException ex) {
                GuiUtil.handleError(handlerCtx, "Unable to parse Date/Time: '" + dateTime + "'.");
            }
        }
        Date convertDate = null;
        try {
            convertDate = (Date)date;
        }
        catch (Exception ex) {
            convertDate = null;
        }
        return convertDate;
    }

    private static Date parseDateString(SimpleDateFormat fmt, String format, String dateTime) throws ParseException {
        fmt.applyLocalizedPattern(format);
        return fmt.parse(dateTime);
    }

    public static String formatDateForDisplay(Locale locale, Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat fmt = (SimpleDateFormat)dateFormat;
            fmt.applyLocalizedPattern(fmt.toLocalizedPattern() + TIME_FORMAT);
            return fmt.format(date);
        }
        dateFormat = DateFormat.getDateTimeInstance(2, 1, locale);
        return dateFormat.format(date);
    }

    public static void getFirstLastRecord(HandlerContext handlerCtx) {
        String firstLogRow = (String)handlerCtx.getInputValue("FirstRecord");
        String lastLogRow = (String)handlerCtx.getInputValue("LastRecord");
        if (firstLogRow == null) {
            firstLogRow = "0";
        }
        if (lastLogRow == null) {
            lastLogRow = "0";
        }
        int firstRow = 0;
        try {
            firstRow = Integer.parseInt(firstLogRow);
            int lastRow = Integer.parseInt(lastLogRow);
            if (firstRow > lastRow) {
                String temp = firstLogRow;
                firstLogRow = lastLogRow;
                lastLogRow = temp;
                firstRow = lastRow;
            }
            handlerCtx.setOutputValue("First", (Object)firstLogRow);
            handlerCtx.setOutputValue("Last", (Object)lastLogRow);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
    }

    protected static String formatArrayForDisplay(String[] diag) {
        if (diag == null || diag.length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer("<br>");
        for (int i = 0; i < diag.length; ++i) {
            buf.append(diag[i]);
            buf.append("<br>");
        }
        return buf.toString();
    }

    public void getTime(HandlerContext handlerCtx) {
        try {
            DateFormat df = DateFormat.getTimeInstance(3, GuiUtil.getLocale());
            ((SimpleDateFormat)df).applyLocalizedPattern(TIME_FORMAT);
            handlerCtx.setOutputValue("Time", (Object)df.format(new Date()));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public void getDate(HandlerContext handlerCtx) {
        String formatString = (String)handlerCtx.getInputValue("DateFormat");
        int formatType = -1;
        if (formatString.equals(GET_DATE_SHORT)) {
            formatType = 3;
        } else if (formatString.equals(GET_DATE_MEDIUM)) {
            formatType = 2;
        } else if (formatString.equals(GET_DATE_LONG)) {
            formatType = 1;
        } else if (formatString.equals(GET_DATE_FULL)) {
            formatType = 0;
        }
        DateFormat df = null;
        if (formatType == -1) {
            df = DateFormat.getDateInstance(3, GuiUtil.getLocale());
            ((SimpleDateFormat)df).applyLocalizedPattern(formatString);
        } else {
            df = DateFormat.getDateInstance(formatType, GuiUtil.getLocale());
        }
        handlerCtx.setOutputValue("Date", (Object)df.format(new Date()));
    }

    public void getFormattedDateTime(HandlerContext handlerCtx) {
        String timeStamp = (String)handlerCtx.getInputValue("Timestamp");
        Boolean addHour = (Boolean)handlerCtx.getInputValue("AddHour");
        Date date = null;
        date = timeStamp == null || "".equals(timeStamp) ? new Date(System.currentTimeMillis()) : (addHour != null ? new Date(Long.parseLong(timeStamp) + 3600000L) : new Date(Long.parseLong(timeStamp)));
        DateFormat df = DateFormat.getDateInstance(3, GuiUtil.getLocale());
        DateFormat tf = DateFormat.getTimeInstance(2, GuiUtil.getLocale());
        ((SimpleDateFormat)tf).applyLocalizedPattern(TIME_FORMAT);
        String ftime = tf.format(date);
        String fdate = df.format(date);
        handlerCtx.setOutputValue("Time", (Object)ftime);
        handlerCtx.setOutputValue("Date", (Object)fdate);
    }
}

