/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.spi.Target;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.common.util.TargetUtil;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployUtil {
    private static final String COMMON_BUNDLE = "org.glassfish.common.admingui.Strings";

    public static void deploy(String[] targets, Properties deploymentProps, String location, HandlerContext handlerCtx) throws Exception {
        deploymentProps.setProperty("upload", "false");
        boolean status = DeployUtil.invokeDeploymentFacility(targets, deploymentProps, location, handlerCtx);
        if (status) {
            // empty if block
        }
    }

    public static boolean invokeDeploymentFacility(String[] targets, Properties props, String archivePath, HandlerContext handlerCtx) throws Exception {
        if (archivePath == null) {
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.deploy.nullArchiveError"));
        }
        if (targets == null) {
            String defaultTarget = "domain";
            targets = new String[]{defaultTarget};
        }
        File filePath = new File(archivePath);
        URI source = filePath.toURI();
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        DFProgressObject progressObject = null;
        progressObject = df.deploy(df.createTargets(targets), source, null, (Map)props);
        progressObject.waitFor();
        DFDeploymentStatus status = progressObject.getCompletedStatus();
        boolean ret = DeployUtil.checkDeployStatus(status, handlerCtx, true);
        return ret;
    }

    public static boolean checkDeployStatus(DFDeploymentStatus status, HandlerContext handlerCtx, boolean stopProcessing) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        DFDeploymentStatus.parseDeploymentStatus((DFDeploymentStatus)status, (PrintWriter)pw);
        byte[] statusBytes = bos.toByteArray();
        String statusString = new String(statusBytes);
        if (status != null && status.getStatus() == DFDeploymentStatus.Status.FAILURE) {
            if (stopProcessing) {
                GuiUtil.handleError(handlerCtx, statusString);
            } else {
                GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), statusString);
            }
            return false;
        }
        if (status != null && status.getStatus() == DFDeploymentStatus.Status.WARNING) {
            GuiUtil.prepareAlert("warning", GuiUtil.getMessage("deploy.warning"), statusString);
            return false;
        }
        return true;
    }

    public static void handleAppRefs(String appName, String[] targetNames, HandlerContext handlerCtx, boolean addFlag, Boolean enableFlag) {
        if (targetNames != null && targetNames.length > 0) {
            DeploymentFacility df = GuiUtil.getDeploymentFacility();
            DFProgressObject progressObject = null;
            Properties dProps = new Properties();
            if (enableFlag != null) {
                dProps.setProperty("enabled", enableFlag.toString());
            }
            progressObject = addFlag ? df.createAppRef(df.createTargets(targetNames), appName, (Map)dProps) : df.deleteAppRef(df.createTargets(targetNames), appName, (Map)dProps);
            DFDeploymentStatus status = df.waitFor(progressObject);
            DeployUtil.checkDeployStatus(status, handlerCtx, true);
        }
    }

    public static boolean reloadApplication(String appName, List targets, HandlerContext handlerCtx) {
        String[] targetArray = targets.toArray(new String[targets.size()]);
        if (DeployUtil.enableApp(appName, targetArray, handlerCtx, false)) {
            return DeployUtil.enableApp(appName, targetArray, handlerCtx, true);
        }
        return false;
    }

    public static boolean enableApp(String appName, String target, HandlerContext handlerCtx, boolean enable) {
        String[] targets = new String[]{target};
        return DeployUtil.enableApp(appName, targets, handlerCtx, enable);
    }

    public static boolean enableApp(String appName, String[] targetNamess, HandlerContext handlerCtx, boolean enable) {
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        Target[] targets = df.createTargets(targetNamess);
        DFProgressObject progressObject = enable ? df.enable(targets, appName) : df.disable(targets, appName);
        progressObject.waitFor();
        DFDeploymentStatus status = progressObject.getCompletedStatus();
        boolean ret = DeployUtil.checkDeployStatus(status, handlerCtx, false);
        return ret;
    }

    public static List getApplicationTarget(String appName, String ref) {
        ArrayList<String> targets = new ArrayList<String>();
        try {
            List clusters = TargetUtil.getClusters();
            for (String oneCluster : clusters) {
                ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + oneCluster + "/" + ref).keySet());
                if (!appRefs.contains(appName)) continue;
                targets.add(oneCluster);
            }
            List servers = TargetUtil.getStandaloneInstances();
            servers.add("server");
            for (String oneServer : servers) {
                ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/" + ref).keySet());
                if (!appRefs.contains(appName)) continue;
                targets.add(oneServer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return targets;
    }

    public static List<Map> getRefEndpoints(String name, String ref) {
        ArrayList<Map> endpoints = new ArrayList<Map>();
        try {
            String encodedName = URLEncoder.encode(name, "UTF-8");
            List clusters = TargetUtil.getClusters();
            for (String oneCluster : clusters) {
                ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + oneCluster + "/" + ref).keySet());
                if (!appRefs.contains(name)) continue;
                HashMap<String, String> aMap = new HashMap<String, String>();
                aMap.put("endpoint", GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + oneCluster + "/" + ref + "/" + encodedName);
                aMap.put("targetName", oneCluster);
                endpoints.add(aMap);
            }
            List servers = TargetUtil.getStandaloneInstances();
            servers.add("server");
            for (String oneServer : servers) {
                ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/" + ref).keySet());
                if (!appRefs.contains(name)) continue;
                HashMap<String, String> aMap = new HashMap<String, String>();
                aMap.put("endpoint", GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/" + ref + "/" + encodedName);
                aMap.put("targetName", oneServer);
                endpoints.add(aMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return endpoints;
    }

    public static String getTargetEnableInfo(String appName, boolean useImage, boolean isApp) {
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        List clusters = TargetUtil.getClusters();
        List standalone = TargetUtil.getStandaloneInstances();
        String enabled = "true";
        int numEnabled = 0;
        int numDisabled = 0;
        String ref = "application-ref";
        if (!isApp) {
            ref = "resource-ref";
        }
        if (clusters.isEmpty() && standalone.isEmpty()) {
            enabled = (String)RestUtil.getAttributesMap(prefix + "/servers/server/server/" + ref + "/" + appName).get("enabled");
            if (useImage) {
                return Boolean.parseBoolean(enabled) ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
            }
            return enabled;
        }
        standalone.add("server");
        List targetList = new ArrayList();
        try {
            targetList = DeployUtil.getApplicationTarget(URLDecoder.decode(appName, "UTF-8"), ref);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (String oneTarget : targetList) {
            enabled = clusters.contains(oneTarget) ? (String)RestUtil.getAttributesMap(prefix + "/clusters/cluster/" + oneTarget + "/" + ref + "/" + appName).get("enabled") : (String)RestUtil.getAttributesMap(prefix + "/servers/server/" + oneTarget + "/" + ref + "/" + appName).get("enabled");
            if (Boolean.parseBoolean(enabled)) {
                ++numEnabled;
                continue;
            }
            ++numDisabled;
        }
        int numTargets = targetList.size();
        return numTargets == 0 ? GuiUtil.getMessage("deploy.noTarget") : GuiUtil.getMessage("deploy.someEnabled", new String[]{"" + numEnabled, "" + numTargets});
    }
}

