/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.resource.ResourceBundleManager;
import com.sun.jsftemplating.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.admingui.common.util.LocalDeploymentFacility;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.deployment.client.DeploymentFacility;
import org.glassfish.deployment.client.ServerConnectionIdentifier;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiUtil {
    public static final String I18N_RESOURCE_BUNDLE = "__i18n_resource_bundle";
    public static final String RESOURCE_NAME = "org.glassfish.admingui.core.Strings";
    public static final String COMMON_RESOURCE_NAME = "org.glassfish.common.admingui.Strings";
    public static final String LOGGER_NAME = "org.glassfish.admingui";

    public static Logger getLogger() {
        return Logger.getLogger(LOGGER_NAME);
    }

    public static void guiLog(HandlerContext handlerCtx) {
        String level = (String)handlerCtx.getInputValue("level");
        level = level == null ? "INFO" : level.toUpperCase();
        GuiUtil.getLogger().log(Level.parse(level), (String)handlerCtx.getInputValue("message"));
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static String getCommonMessage(String key, Object[] args) {
        return GuiUtil.getMessage(COMMON_RESOURCE_NAME, key, args);
    }

    public static String getMessage(String resourceName, String key, Object[] args) {
        return GuiUtil.formatMessage(GuiUtil.getMessage(resourceName, key), args);
    }

    public static String getMessage(String key, Object[] args) {
        if (key == null) {
            return null;
        }
        String value = GuiUtil.getMessage(key);
        return GuiUtil.formatMessage(GuiUtil.getMessage(value), args);
    }

    private static String formatMessage(String msg, Object[] args) {
        if (args != null) {
            MessageFormat mf = new MessageFormat(msg);
            Object[] mfArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                mfArgs[i] = GuiUtil.getMessage(args[i].toString());
            }
            msg = mf.format(mfArgs);
        }
        return msg;
    }

    public static void initSessionAttributes() {
        Logger logger = GuiUtil.getLogger();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.FINE, GuiUtil.getCommonMessage("LOG_INIT_SESSION"));
        }
        ExternalContext externalCtx = FacesContext.getCurrentInstance().getExternalContext();
        Map sessionMap = externalCtx.getSessionMap();
        Object request = externalCtx.getRequest();
        if (request instanceof ServletRequest) {
            ServletRequest srequest = (ServletRequest)request;
            sessionMap.put("hostName", srequest.getServerName());
            String restServerName = (String)sessionMap.get("serverName");
            if (restServerName == null) {
                throw new IllegalStateException("REST Server Name not set!");
            }
            int port = (Integer)sessionMap.get("serverPort");
            sessionMap.put("requestIsSecured", srequest.isSecure());
            sessionMap.put("REST_URL", "http" + (srequest.isSecure() ? "s" : "") + "://" + restServerName + ":" + port + "/management/domain");
            sessionMap.put("MONITOR_URL", "http" + (srequest.isSecure() ? "s" : "") + "://" + restServerName + ":" + port + "/monitoring/domain");
        } else {
            sessionMap.put("hostName", "");
        }
        sessionMap.put("domainName", RestUtil.getPropValue((String)sessionMap.get("REST_URL"), "administrative.domain.name", null));
        sessionMap.put("_noNetwork", System.getProperty("com.sun.enterprise.tools.admingui.NO_NETWORK", "false").equals("true") ? Boolean.TRUE : Boolean.FALSE);
        sessionMap.put("supportCluster", Boolean.FALSE);
        Map<String, Object> version = RestUtil.restRequest(sessionMap.get("REST_URL") + "/version", null, "GET", null, false);
        sessionMap.put("appServerVersion", ((Map)version.get("data")).get("message"));
        Map<String, Object> locations = RestUtil.restRequest(sessionMap.get("REST_URL") + "/location", null, "GET", null, false);
        sessionMap.put("installationDir", ((Map)((Map)locations.get("data")).get("properties")).get("Base-Root"));
        Map<String, Object> runtimeInfoMap = RestUtil.restRequest(sessionMap.get("REST_URL") + "/get-runtime-info", null, "GET", null, false);
        String debugFlag = (String)((Map)((Map)runtimeInfoMap.get("data")).get("properties")).get("debug");
        if ("true".equals(debugFlag)) {
            String debugPort = (String)((Map)((Map)runtimeInfoMap.get("data")).get("properties")).get("debugPort");
            sessionMap.put("debugInfo", GuiUtil.getMessage("inst.debugEnabled") + debugPort);
        } else {
            sessionMap.put("debugInfo", GuiUtil.getMessage("inst.notEnabled"));
        }
        sessionMap.put("reqMsg", GuiUtil.getMessage("msg.JS.enterValue"));
        sessionMap.put("reqMsgSelect", GuiUtil.getMessage("msg.JS.selectValue"));
        sessionMap.put("reqInt", GuiUtil.getMessage("msg.JS.enterIntegerValue"));
        sessionMap.put("reqNum", GuiUtil.getMessage("msg.JS.enterNumericValue"));
        sessionMap.put("reqPort", GuiUtil.getMessage("msg.JS.enterPortValue"));
        sessionMap.put("_SESSION_INITIALIZED", "TRUE");
        sessionMap.put("restartRequired", Boolean.FALSE);
        try {
            Map<String, Object> result = RestUtil.restRequest(GuiUtil.getSessionValue("REST_URL") + "/configs/config/server-config/admin-service/das-config", null, "GET", null, false);
            String timeOut = (String)((Map)((Map)((Map)result.get("data")).get("extraProperties")).get("entity")).get("adminSessionTimeoutInMinutes");
            if (timeOut != null && !timeOut.equals("")) {
                int time = new Integer(timeOut);
                if (time == 0) {
                    ((HttpServletRequest)request).getSession().setMaxInactiveInterval(-1);
                } else {
                    ((HttpServletRequest)request).getSession().setMaxInactiveInterval(time * 60);
                }
            }
        }
        catch (Exception nfe) {
            ((HttpServletRequest)request).getSession().setMaxInactiveInterval(-1);
            nfe.printStackTrace();
        }
    }

    public static void setSessionValue(String key, Object value) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        sessionMap.put(key, value);
    }

    public static Object getSessionValue(String key) {
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if (sessionMap.get("_SESSION_INITIALIZED") == null) {
            GuiUtil.initSessionAttributes();
        }
        return sessionMap.get(key);
    }

    public static DeploymentFacility getDeploymentFacility() {
        LocalDeploymentFacility df = null;
        if (df == null) {
            df = new LocalDeploymentFacility();
            String serverName = (String)GuiUtil.getSessionValue("serverName");
            Integer serverPort = (Integer)GuiUtil.getSessionValue("serverPort");
            int port = 4848;
            if (serverPort == null) {
                GuiUtil.getLogger().warning(GuiUtil.getMessage(COMMON_RESOURCE_NAME, "WARNING_NO_ADMIN_LISTENER_PORT"));
            } else {
                port = serverPort;
            }
            String userName = (String)GuiUtil.getSessionValue("userName");
            Boolean requestIsSecured = (Boolean)GuiUtil.getSessionValue("requestIsSecured");
            ServerConnectionIdentifier sci = new ServerConnectionIdentifier(serverName, port, userName, "", requestIsSecured.booleanValue());
            df.connect(sci);
            GuiUtil.setSessionValue("_DEPLOYMENT_FACILITY", (Object)df);
        }
        return df;
    }

    public static String encode(String value, String delim, String type) {
        if (value == null || value.equals("")) {
            return value;
        }
        if (type == null || type.equals("")) {
            type = "UTF-8";
        }
        String encdString = "";
        if (delim != null && delim.length() > 0) {
            StringTokenizer st = new StringTokenizer(value, delim, true);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (delim.indexOf(s) >= 0) {
                    encdString = encdString.concat(s);
                    continue;
                }
                try {
                    encdString = encdString + URLEncoder.encode(s, type);
                }
                catch (UnsupportedEncodingException uex) {
                    try {
                        encdString = encdString + URLEncoder.encode(s, "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            }
        } else {
            try {
                encdString = URLEncoder.encode(value, type);
            }
            catch (UnsupportedEncodingException uex) {
                try {
                    encdString = encdString + URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        }
        return encdString;
    }

    public static String genId(String uid) {
        char[] chArr = uid.toCharArray();
        int len = chArr.length;
        int newIdx = 0;
        for (int idx = 0; idx < len; ++idx) {
            int test = chArr[idx];
            chArr[newIdx++] = Character.isLetterOrDigit((char)test) || test == 95 || test == 45 ? test : 95;
        }
        String result = new String(chArr, 0, newIdx);
        if (!Character.isLetter(chArr[0]) && chArr[0] != '_') {
            result = "_" + result;
        }
        return result;
    }

    public static ResourceBundle getBundle(String resourceName) {
        Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
        return ResourceBundleManager.getInstance().getBundle(resourceName, locale);
    }

    public static String getMessage(String key) {
        try {
            String ret;
            ResourceBundle bundle = (ResourceBundle)FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(I18N_RESOURCE_BUNDLE);
            if (bundle == null) {
                Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
                bundle = ResourceBundleManager.getInstance().getBundle(RESOURCE_NAME, locale);
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put(I18N_RESOURCE_BUNDLE, bundle);
            }
            return (ret = bundle.getString(key)) == null ? key : ret;
        }
        catch (NullPointerException ex) {
            return "";
        }
        catch (Exception ex1) {
            return key;
        }
    }

    public static String getCommonMessage(String key) {
        return GuiUtil.getMessage(COMMON_RESOURCE_NAME, key);
    }

    public static String getMessage(String resourceName, String key) {
        ResourceBundle bundle = GuiUtil.getBundle(resourceName);
        String ret = bundle.getString(key);
        return ret == null ? key : ret;
    }

    public static String getMessage(ResourceBundle bundle, String key) {
        String ret = bundle.getString(key);
        return ret == null ? key : ret;
    }

    public static Locale getLocale() {
        Locale locale = Util.getLocale((FacesContext)FacesContext.getCurrentInstance());
        return locale;
    }

    public static void prepareSuccessful(HandlerContext handlerCtx) {
        GuiUtil.prepareAlert("success", GuiUtil.getMessage("msg.saveSuccessful"), null);
    }

    public static void prepareException(HandlerContext handlerCtx, Throwable ex) {
        Throwable rootException = GuiUtil.getRootCause(ex);
        GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), rootException.getMessage());
        GuiUtil.getLogger().log(Level.SEVERE, GuiUtil.getMessage(COMMON_RESOURCE_NAME, "LOG_EXCEPTION_OCCURED"), ex);
    }

    public static void prepareAlert(String type, String summary, String detail) {
        Map attrMap = FacesContext.getCurrentInstance().getExternalContext().getRequestMap();
        if (GuiUtil.isEmpty(type)) {
            attrMap.put("alertType", "information");
        } else {
            if (!(type.equals("information") || type.equals("success") || type.equals("warning") || type.equals("error"))) {
                throw new RuntimeException("GuiUtil:prepareMessage():  type specified is not a valid type");
            }
            attrMap.put("alertType", type);
        }
        if (detail != null && detail.length() > 500) {
            detail = detail.substring(0, 500) + "...";
        }
        try {
            attrMap.put("alertDetail", GuiUtil.isEmpty(detail) ? "" : URLEncoder.encode(detail, "UTF-8"));
            attrMap.put("alertSummary", GuiUtil.isEmpty(summary) ? "" : URLEncoder.encode(summary, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
    }

    public static void handleException(HandlerContext handlerCtx, Throwable ex) {
        GuiUtil.prepareException(handlerCtx, ex);
        handlerCtx.getFacesContext().renderResponse();
    }

    public static List<Map> getListOfMaps(Map map) {
        ArrayList list = null;
        if (map != null) {
            list = new ArrayList();
            for (Object key : map.keySet()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                Object value = map.get(key);
                row.put("name", key);
                row.put("value", value != null ? value : "");
                list.add(row);
            }
        }
        return list;
    }

    public static void handleError(HandlerContext handlerCtx, String detail) {
        GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), detail);
        handlerCtx.getFacesContext().renderResponse();
    }

    public static String notNull(String test) {
        return test == null ? "" : test;
    }

    public static List<String> convertListOfStrings(List l) {
        ArrayList<String> arrList = new ArrayList<String>();
        for (Object o : l) {
            arrList.add(o.toString());
        }
        return arrList;
    }

    public static List parseStringList(String line, String sep) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (line == null) {
            return tokens;
        }
        StringTokenizer st = sep == null ? new StringTokenizer(line) : new StringTokenizer(line, sep);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String removeToken(String line, String sep, String remove) {
        StringTokenizer st;
        if (line == null) {
            return null;
        }
        if (sep == null) {
            st = new StringTokenizer(line);
        } else {
            sep = sep.trim();
            st = new StringTokenizer(line, sep);
        }
        String result = "";
        boolean start = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() <= 0 || token.equals(remove)) continue;
            if (start) {
                result = token;
                start = false;
                continue;
            }
            result = result + sep + token;
        }
        return result;
    }

    public static String[] stringToArray(String str, String delimiter) {
        String[] retString = new String[]{};
        if (str != null) {
            if (delimiter == null) {
                delimiter = " ";
            }
            StringTokenizer tokens = new StringTokenizer(str, delimiter);
            retString = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                retString[i++] = token;
            }
        }
        return retString;
    }

    public static String arrayToString(String[] str, String delimiter) {
        StringBuffer retStr = new StringBuffer();
        if (str != null) {
            for (int i = 0; i < str.length; ++i) {
                String element = str[i];
                retStr.append(element);
                if (i >= str.length - 1) continue;
                retStr.append(delimiter);
            }
        }
        return retStr.toString();
    }

    public static String listToString(List<String> list, String delimiter) {
        StringBuffer retStr = new StringBuffer();
        if (list == null || list.size() <= 0) {
            return "";
        }
        for (String oneItem : list) {
            retStr.append(oneItem);
            retStr.append(delimiter);
        }
        String ret = retStr.toString();
        ret = ret.substring(0, ret.length() - 1);
        return ret;
    }

    public static <T> T[] asArray(Object o) {
        return (Object[])Object[].class.cast(o);
    }

    public static boolean isSelected(String name, List<Map> selectedList) {
        if (selectedList == null || name == null) {
            return false;
        }
        for (Map oneRow : selectedList) {
            if (!name.equals(oneRow.get("name"))) continue;
            return true;
        }
        return false;
    }

    public static String checkEmpty(String test) {
        if (test == null) {
            return "";
        }
        return test;
    }

    public static Boolean getBooleanValue(Map pMap, String name) {
        if (pMap.get(name) == null) {
            return Boolean.FALSE;
        }
        Object val = pMap.get(name);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return Boolean.valueOf("" + val);
    }

    public static Habitat getHabitat() {
        ServletContext servletCtx = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
        Habitat habitat = (Habitat)servletCtx.getAttribute("org.glassfish.servlet.habitat");
        return habitat;
    }

    public static List<Map<String, Object>> convertArrayToListOfMap(Object[] values, String key) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (values != null) {
            HashMap<String, Object> map = null;
            for (Object val : values) {
                map = new HashMap<String, Object>();
                map.put(key, val);
                map.put("selected", false);
                list.add(map);
            }
        }
        return list;
    }

    public static List<Map<String, String>> convertMapToListOfMap(Map<String, String> values) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (values != null) {
            Object map = null;
            for (String key : values.keySet()) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                String value = values.get(key);
                String valString = value == null ? "" : value.toString();
                oneRow.put("name", key);
                oneRow.put("value", valString);
                oneRow.put("description", "");
                list.add(oneRow);
            }
        }
        return list;
    }

    public static Object getMapValue(Map map, String mapKeys) {
        int i;
        String[] keys = mapKeys.split(",");
        for (i = 0; i < keys.length - 1; ++i) {
            if ((map = (Map)map.get(keys[i])) != null) continue;
            return null;
        }
        return map.get(keys[i]);
    }

    public static Throwable[] getCauses(Throwable start) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        boolean haveNonException = false;
        Throwable t = start;
        while (t != null) {
            Throwable temp;
            list.add(t);
            if (!(t instanceof Exception)) {
                haveNonException = true;
            }
            if ((temp = t.getCause()) == null) break;
            t = temp;
        }
        Throwable[] results = haveNonException ? new Throwable[list.size()] : new Exception[list.size()];
        list.toArray(results);
        return results;
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable[] causes = GuiUtil.getCauses(e);
        return causes[causes.length - 1];
    }
}

