/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.RestUtil;

public class RestApiHandlers {
    public static void getDefaultValues(HandlerContext handlerCtx) {
        try {
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            Map orig = (Map)handlerCtx.getInputValue("orig");
            Map<String, String> defaultValues = RestUtil.buildDefaultValueMap(endpoint);
            if (orig == null) {
                handlerCtx.setOutputValue("valueMap", defaultValues);
            } else {
                for (String origKey : orig.keySet()) {
                    String defaultV = defaultValues.get(origKey);
                    if (defaultV == null) continue;
                    orig.put(origKey, defaultV);
                }
                handlerCtx.setOutputValue("valueMap", (Object)orig);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getEntityAttrs(HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("key");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        Map currentMap = (Map)handlerCtx.getInputValue("currentMap");
        Map<String, Object> valueMap = null;
        try {
            valueMap = RestUtil.getEntityAttrs(endpoint, key);
            if (currentMap != null) {
                valueMap.putAll(currentMap);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("valueMap", valueMap);
    }

    public static void checkIfEndPointExist(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("exists", (Object)RestUtil.get((String)handlerCtx.getInputValue("endpoint")).isSuccess());
    }

    public static void createEntity(HandlerContext handlerCtx) {
        HashMap<String, Object> attrs = (HashMap<String, Object>)handlerCtx.getInputValue("attrs");
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        RestResponse response = RestUtil.sendCreateRequest(endpoint, attrs, (List)handlerCtx.getInputValue("skipAttrs"), (List)handlerCtx.getInputValue("onlyUseAttrs"), (List)handlerCtx.getInputValue("convertToFalse"));
        boolean throwException = (Boolean)handlerCtx.getInputValue("throwException");
        Map<String, Object> resultMap = RestUtil.parseResponse(response, handlerCtx, endpoint, attrs, false, throwException);
        handlerCtx.setOutputValue("result", (Object)endpoint);
    }

    public static void restRequest(HandlerContext handlerCtx) {
        Map attrs = (Map)handlerCtx.getInputValue("attrs");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String method = (String)handlerCtx.getInputValue("method");
        boolean quiet = (Boolean)handlerCtx.getInputValue("quiet");
        boolean throwException = (Boolean)handlerCtx.getInputValue("throwException");
        handlerCtx.setOutputValue("result", RestUtil.restRequest(endpoint, attrs, method, handlerCtx, quiet, throwException));
    }

    public static void updateEntity(HandlerContext handlerCtx) {
        String endpoint;
        RestResponse response;
        HashMap<String, Object> attrs = (HashMap<String, Object>)handlerCtx.getInputValue("attrs");
        if (attrs == null) {
            attrs = new HashMap<String, Object>();
        }
        if (!(response = RestUtil.sendUpdateRequest(endpoint = (String)handlerCtx.getInputValue("endpoint"), attrs, (List)handlerCtx.getInputValue("skipAttrs"), (List)handlerCtx.getInputValue("onlyUseAttrs"), (List)handlerCtx.getInputValue("convertToFalse"))).isSuccess()) {
            GuiUtil.getLogger().log(Level.SEVERE, GuiUtil.getCommonMessage("LOG_UPDATE_ENTITY_FAILED", new Object[]{endpoint, attrs}));
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
            return;
        }
        handlerCtx.setOutputValue("result", (Object)endpoint);
    }

    public static void deleteCascade(HandlerContext handlerCtx) {
        try {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            String id = (String)handlerCtx.getInputValue("id");
            String cascade = (String)handlerCtx.getInputValue("cascade");
            if (cascade != null) {
                payload.put("cascade", cascade);
            }
            for (Map oneRow : (List)handlerCtx.getInputValue("selectedRows")) {
                RestResponse response = RestUtil.delete(endpoint + "/" + URLEncoder.encode((String)oneRow.get(id), "UTF-8"), payload);
                if (response.isSuccess()) continue;
                GuiUtil.handleError(handlerCtx, "Unable to delete the resource " + (String)oneRow.get(id));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void deleteConfigCascade(HandlerContext handlerCtx) {
        try {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            String id = (String)handlerCtx.getInputValue("id");
            String target = (String)handlerCtx.getInputValue("target");
            String cascade = (String)handlerCtx.getInputValue("cascade");
            if (cascade != null) {
                payload.put("cascade", cascade);
            }
            for (Map oneRow : (List)handlerCtx.getInputValue("selectedRows")) {
                RestResponse response = RestUtil.delete(endpoint + "/" + URLEncoder.encode((String)oneRow.get(id), "UTF-8") + "?target=" + target, payload);
                if (response.isSuccess()) continue;
                GuiUtil.handleError(handlerCtx, "Unable to delete the resource " + (String)oneRow.get(id));
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getChildList(HandlerContext handlerCtx) {
        try {
            handlerCtx.setOutputValue("result", RestUtil.buildChildEntityList((String)handlerCtx.getInputValue("parentEndpoint"), (String)handlerCtx.getInputValue("childType"), (List)handlerCtx.getInputValue("skipList"), (List)handlerCtx.getInputValue("includeList"), (String)handlerCtx.getInputValue("id")));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getChildrenNamesList(HandlerContext handlerCtx) {
        try {
            ArrayList<String> list = new ArrayList<String>(RestUtil.getChildMap((String)handlerCtx.getInputValue("endpoint")).keySet());
            Collections.sort(list);
            handlerCtx.setOutputValue("result", list);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void encodeUrl(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("url", (Object)RestUtil.appendEncodedSegment((String)handlerCtx.getInputValue("base"), (String)handlerCtx.getInputValue("resourceName")));
    }
}

