/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.admingui.common.handlers.InstanceHandler;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.RestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityHandler {
    private static List skipRealmPropsList = new ArrayList();
    private static List realmClassList = new ArrayList();
    private static final String PROPERTY_NAME = "Name";
    private static final String PROPERTY_VALUE = "Value";
    private static final String COMMON_BUNDLE = "org.glassfish.common.admingui.Strings";
    private static final String JVM_OPTION_SECURITY_MANAGER = "-Djava.security.manager";
    private static final String JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL = "-Djava.security.manager=";

    public static void getRealmAttrForCreate(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
        handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
        HashMap<String, Boolean> attrMap = new HashMap<String, Boolean>();
        attrMap.put("predefinedClassname", Boolean.TRUE);
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("properties", new ArrayList());
    }

    public static void getRealmAttrForEdit(HandlerContext handlerCtx) {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        HashMap realmMap = (HashMap)RestUtil.getEntityAttrs(endpoint, "entity");
        HashMap responseMap = (HashMap)RestUtil.restRequest(endpoint + "/property.json", null, "GET", null, false);
        HashMap propsMap = (HashMap)((Map)responseMap.get("data")).get("extraProperties");
        ArrayList propList = (ArrayList)propsMap.get("properties");
        HashMap<String, Object> origProps = new HashMap<String, Object>();
        for (HashMap prop : propList) {
            origProps.put((String)prop.get("name"), prop.get("value"));
        }
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        attrMap.put(PROPERTY_NAME, (String)realmMap.get("name"));
        attrMap.put("fileJaax", "fileRealm");
        attrMap.put("ldapJaax", "ldapRealm");
        attrMap.put("solarisJaax", "solarisRealm");
        attrMap.put("jdbcJaax", "jdbcRealm");
        String classname = (String)realmMap.get("classname");
        if (realmClassList.contains(classname)) {
            handlerCtx.setOutputValue("classnameOption", (Object)"predefine");
            attrMap.put("predefinedClassname", Boolean.TRUE);
            attrMap.put("classname", classname);
            List props = SecurityHandler.getChildrenMapForTableList(origProps, "property", skipRealmPropsList);
            handlerCtx.setOutputValue("properties", (Object)props);
            if (classname.indexOf("FileRealm") != -1) {
                attrMap.put("file", origProps.get("file"));
                attrMap.put("fileJaax", origProps.get("jaas-context"));
                attrMap.put("fileAsGroups", origProps.get("assign-groups"));
            } else if (classname.indexOf("LDAPRealm") != -1) {
                attrMap.put("ldapJaax", origProps.get("jaas-context"));
                attrMap.put("ldapAsGroups", origProps.get("assign-groups"));
                attrMap.put("directory", origProps.get("directory"));
                attrMap.put("baseDn", origProps.get("base-dn"));
            } else if (classname.indexOf("SolarisRealm") != -1) {
                attrMap.put("solarisJaax", origProps.get("jaas-context"));
                attrMap.put("solarisAsGroups", origProps.get("assign-groups"));
            } else if (classname.indexOf("PamRealm") != -1) {
                attrMap.put("pamJaax", origProps.get("jaas-context"));
            } else if (classname.indexOf("JDBCRealm") != -1) {
                attrMap.put("jdbcJaax", origProps.get("jaas-context"));
                attrMap.put("jdbcAsGroups", origProps.get("assign-groups"));
                attrMap.put("datasourceJndi", origProps.get("datasource-jndi"));
                attrMap.put("userTable", origProps.get("user-table"));
                attrMap.put("userNameColumn", origProps.get("user-name-column"));
                attrMap.put("passwordColumn", origProps.get("password-column"));
                attrMap.put("groupTable", origProps.get("group-table"));
                attrMap.put("groupNameColumn", origProps.get("group-name-column"));
                attrMap.put("dbUser", origProps.get("db-user"));
                attrMap.put("dbPassword", origProps.get("db-password"));
                attrMap.put("digestAlgorithm", origProps.get("digest-algorithm"));
                attrMap.put("encoding", origProps.get("encoding"));
                attrMap.put("charset", origProps.get("charset"));
            } else if (classname.indexOf("CertificateRealm") != -1) {
                attrMap.put("certAsGroups", origProps.get("assign-groups"));
            }
        } else {
            handlerCtx.setOutputValue("classnameOption", (Object)"input");
            attrMap.put("predefinedClassname", Boolean.FALSE);
            attrMap.put("classnameInput", classname);
            List<HashMap> props = SecurityHandler.getListfromMap(origProps);
            handlerCtx.setOutputValue("properties", props);
        }
        handlerCtx.setOutputValue("attrMap", attrMap);
        handlerCtx.setOutputValue("realmClasses", (Object)realmClassList);
    }

    public static List getChildrenMapForTableList(Map<String, Object> realmMap, String childType, List skipList) {
        boolean hasSkip = true;
        if (skipList == null) {
            hasSkip = false;
        }
        ArrayList result = new ArrayList();
        if (realmMap != null) {
            Set<Map.Entry<String, Object>> s = realmMap.entrySet();
            for (Map.Entry<String, Object> m : s) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                if (hasSkip && skipList.contains(m.getKey())) continue;
                oneRow.put("selected", false);
                oneRow.put("name", m.getKey());
                oneRow.put("value", m.getValue());
                result.add(oneRow);
            }
        }
        return result;
    }

    public static List<HashMap> getListfromMap(HashMap<String, Object> props) {
        ArrayList<HashMap> result = new ArrayList<HashMap>();
        for (Map.Entry<String, Object> m : props.entrySet()) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("selected", false);
            oneRow.put(PROPERTY_NAME, m.getKey());
            oneRow.put(PROPERTY_VALUE, m.getValue());
            oneRow.put("Description", "");
            result.add(oneRow);
        }
        return result;
    }

    public static void saveRealm(HandlerContext handlerCtx) {
        String option = (String)handlerCtx.getInputValue("classnameOption");
        List propList = (List)handlerCtx.getInputValue("propList");
        HashMap<String, String> attrMap = (HashMap<String, String>)handlerCtx.getInputValue("attrMap");
        if (attrMap == null) {
            attrMap = new HashMap<String, String>();
        }
        String classname = "";
        try {
            if (option.equals("predefine")) {
                classname = (String)attrMap.get("classname");
                if (classname.indexOf("FileRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "file", "file");
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "fileJaax");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "fileAsGroups");
                } else if (classname.indexOf("LDAPRealm") != -1) {
                    attrMap.put("baseDn", "\"" + (String)attrMap.get("baseDn") + "\"");
                    attrMap.put("directory", "\"" + (String)attrMap.get("directory") + "\"");
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "ldapJaax");
                    SecurityHandler.putOptional(attrMap, propList, "base-dn", "baseDn");
                    SecurityHandler.putOptional(attrMap, propList, "directory", "directory");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "ldapAsGroups");
                } else if (classname.indexOf("SolarisRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "solarisJaax");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "solarisAsGroups");
                } else if (classname.indexOf("PamRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "pamJaax");
                } else if (classname.indexOf("JDBCRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "jaas-context", "jdbcJaax");
                    SecurityHandler.putOptional(attrMap, propList, "datasource-jndi", "datasourceJndi");
                    SecurityHandler.putOptional(attrMap, propList, "user-table", "userTable");
                    SecurityHandler.putOptional(attrMap, propList, "user-name-column", "userNameColumn");
                    SecurityHandler.putOptional(attrMap, propList, "password-column", "passwordColumn");
                    SecurityHandler.putOptional(attrMap, propList, "group-table", "groupTable");
                    SecurityHandler.putOptional(attrMap, propList, "group-name-column", "groupNameColumn");
                    SecurityHandler.putOptional(attrMap, propList, "db-user", "dbUser");
                    SecurityHandler.putOptional(attrMap, propList, "db-password", "dbPassword");
                    SecurityHandler.putOptional(attrMap, propList, "digest-algorithm", "digestAlgorithm");
                    SecurityHandler.putOptional(attrMap, propList, "encoding", "encoding");
                    SecurityHandler.putOptional(attrMap, propList, "charset", "charset");
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "jdbcAsGroups");
                } else if (classname.indexOf("CertificateRealm") != -1) {
                    SecurityHandler.putOptional(attrMap, propList, "assign-groups", "certAsGroups");
                }
            } else {
                classname = (String)attrMap.get("classnameInput");
            }
            Boolean edit = (Boolean)handlerCtx.getInputValue("edit");
            String endpoint = (String)handlerCtx.getInputValue("endpoint");
            if (edit.booleanValue()) {
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("target", attrMap.get("target"));
                RestUtil.delete(endpoint, attrs);
                endpoint = endpoint.substring(0, endpoint.indexOf("/auth-realm"));
            }
            HashMap<String, Object> cMap = new HashMap<String, Object>();
            cMap.put("name", attrMap.get(PROPERTY_NAME));
            cMap.put("classname", classname);
            String propertyStr = "";
            for (Map oneProp : propList) {
                propertyStr = propertyStr + oneProp.get("name") + "=";
                propertyStr = propertyStr + oneProp.get("value") + ":";
            }
            endpoint = endpoint + "/auth-realm";
            cMap.put("target", attrMap.get("target"));
            cMap.put("property", propertyStr);
            RestUtil.restRequest(endpoint, cMap, "post", handlerCtx, false);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void putOptional(Map<String, String> attrMap, List propList, String propName, String key) {
        HashMap<String, String> oneProp = new HashMap<String, String>();
        oneProp.put("name", propName);
        String value = attrMap.get(key);
        if (GuiUtil.isEmpty(value)) {
            return;
        }
        oneProp.put("value", attrMap.get(key));
        propList.add(oneProp);
    }

    public static void saveUser(HandlerContext handlerCtx) {
        try {
            String endpoint;
            String realmName = (String)handlerCtx.getInputValue("Realm");
            String configName = (String)handlerCtx.getInputValue("configName");
            String grouplist = (String)handlerCtx.getInputValue("GroupList");
            String password = (String)handlerCtx.getInputValue("Password");
            String userid = (String)handlerCtx.getInputValue("UserId");
            Boolean createNew = (Boolean)handlerCtx.getInputValue("CreateNew");
            if (password == null) {
                password = "";
            }
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            if (createNew == null) {
                endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/delete-user";
                attrs.put("username", userid);
                RestResponse response = RestUtil.delete(endpoint, attrs);
                if (!response.isSuccess()) {
                    GuiUtil.getLogger().severe("Remove user failed.  parent=" + endpoint + "; attrs =" + attrs);
                    GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
                }
                createNew = Boolean.TRUE;
            }
            if (createNew != null && createNew == Boolean.TRUE) {
                endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/create-user";
                attrs = new HashMap();
                attrs.put("username", userid);
                attrs.put("authrealmname", realmName);
                attrs.put("userpassword", password);
                if (grouplist != null && grouplist.contains(",")) {
                    grouplist = grouplist.replace(',', ':');
                }
                ArrayList<String> grpList = new ArrayList<String>();
                if (grouplist != null && !grouplist.equals("")) {
                    grpList.add(grouplist);
                }
                attrs.put("groups", grpList);
                RestResponse response = RestUtil.post(endpoint, attrs);
                if (!response.isSuccess()) {
                    GuiUtil.getLogger().severe("Add user failed.  parent=" + endpoint + "; attrs =" + attrs);
                    GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getUserInfo(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        String userName = (String)handlerCtx.getInputValue("User");
        String configName = (String)handlerCtx.getInputValue("configName");
        handlerCtx.setOutputValue("GroupList", (Object)SecurityHandler.getGroupNames(realmName, userName, configName, handlerCtx));
    }

    public static void getFileUsers(HandlerContext handlerCtx) {
        String realmName = (String)handlerCtx.getInputValue("Realm");
        String configName = (String)handlerCtx.getInputValue("configName");
        ArrayList result = new ArrayList();
        try {
            String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/list-users.json";
            Map responseMap = RestUtil.restRequest(endpoint, null, "get", handlerCtx, false);
            responseMap = (Map)responseMap.get("data");
            List children = (List)responseMap.get("children");
            if (children != null) {
                HashMap<String, Object> map = null;
                for (HashMap child : children) {
                    map = new HashMap<String, Object>();
                    String name = (String)child.get("message");
                    map.put("users", name);
                    map.put("groups", SecurityHandler.getGroupNames(realmName, name, configName, handlerCtx));
                    map.put("selected", false);
                    result.add(map);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void removeUser(HandlerContext handlerCtx) {
        String error = null;
        String realmName = (String)handlerCtx.getInputValue("Realm");
        String configName = (String)handlerCtx.getInputValue("configName");
        try {
            List obj;
            List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
            for (Map oneRow : selectedRows) {
                String user = (String)oneRow.get("name");
                String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/admin-service/jmx-connector/system.json";
                Map<String, Object> responseMap = RestUtil.restRequest(endpoint, null, "get", handlerCtx, false);
                Map valueMap = (Map)responseMap.get("data");
                String authRealm = (String)(valueMap = (Map)((Map)valueMap.get("extraProperties")).get("entity")).get("authRealmName");
                if (realmName.equals(authRealm) && user.equals(GuiUtil.getSessionValue("userName"))) {
                    error = GuiUtil.getMessage(COMMON_BUNDLE, "msg.error.cannotDeleteCurrent");
                    continue;
                }
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/delete-user";
                attrs.put("name", user);
                RestResponse response = RestUtil.delete(endpoint, attrs);
                if (response.isSuccess()) continue;
                GuiUtil.getLogger().severe("Remove user failed.  parent=" + endpoint + "; attrs =" + attrs);
                error = GuiUtil.getMessage("msg.error.checkLog");
            }
            if (error != null) {
                GuiUtil.prepareAlert("error", error, null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static String getGroupNames(String realmName, String userName, String configName, HandlerContext handlerCtx) {
        try {
            String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/auth-realm/" + realmName + "/list-group-names?username=" + userName;
            Map<String, Object> responseMap = RestUtil.restRequest(endpoint, null, "get", handlerCtx, false);
            HashMap children = (HashMap)((Map)responseMap.get("data")).get("extraProperties");
            String name = (String)((List)children.get("groups")).get(0);
            return name;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static void addDefaultProviderInfo(HandlerContext handlerCtx) {
        ArrayList providerList = (ArrayList)handlerCtx.getInputValue("providerList");
        String configName = (String)handlerCtx.getInputValue("configName");
        String msgSecurityName = (String)handlerCtx.getInputValue("msgSecurityName");
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/message-security-config/" + msgSecurityName;
        Map<String, Object> valueMap = RestUtil.getEntityAttrs(endpoint, "entity");
        String defaultProvider = (String)valueMap.get("defaultProvider");
        String defaultClientProvider = (String)valueMap.get("defaultClientProvider");
        String trueStr = GuiUtil.getMessage("common.true");
        String falseStr = GuiUtil.getMessage("common.false");
        for (HashMap oneRow : providerList) {
            if (defaultProvider != null && defaultProvider.length() > 0 || defaultClientProvider != null && defaultClientProvider.length() > 0) {
                oneRow.put("default", trueStr);
                continue;
            }
            oneRow.put("default", falseStr);
        }
    }

    public static void getMessageSecurityAuthLayersForCreate(HandlerContext handlerCtx) throws Exception {
        ArrayList<String> layers = new ArrayList<String>();
        String configName = (String)handlerCtx.getInputValue("configName");
        layers.add("SOAP");
        layers.add("HttpServlet");
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/message-security-config";
        Set<String> msgSecurityCfgs = RestUtil.getChildMap(endpoint).keySet();
        for (String name : msgSecurityCfgs) {
            if (!layers.contains(name)) continue;
            layers.remove(name);
        }
        handlerCtx.setOutputValue("layers", layers);
    }

    public static void getProvidersByType(HandlerContext handlerCtx) throws Exception {
        List type = (List)handlerCtx.getInputValue("type");
        ArrayList<String> result = new ArrayList<String>();
        String configName = (String)handlerCtx.getInputValue("configName");
        String msgSecurityName = (String)handlerCtx.getInputValue("msgSecurityName");
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/message-security-config/" + msgSecurityName + "/provider-config";
        List<String> providers = RestUtil.getChildList(endpoint);
        for (String providerEndpoint : providers) {
            HashMap providerAttrs = (HashMap)RestUtil.getAttributesMap(providerEndpoint);
            String providerType = (String)providerAttrs.get("providerType");
            if (!type.contains(providerType)) continue;
            result.add(Util.htmlEscape((String)((String)providerAttrs.get("providerId"))));
        }
        result.add(0, "");
        handlerCtx.setOutputValue("result", result);
    }

    public static void saveMsgProviderInfo(HandlerContext handlerCtx) {
        Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
        String edit = (String)handlerCtx.getInputValue("edit");
        String providerName = (String)attrMap.get(PROPERTY_NAME);
        String msgSecurityName = (String)attrMap.get("msgSecurityName");
        String configName = (String)attrMap.get("configName");
        List propList = (List)handlerCtx.getInputValue("propList");
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/security-service/message-security-config/" + msgSecurityName + "/provider-config";
        String providerEndpoint = endpoint + "/" + providerName;
        if (edit.equals("true")) {
            boolean providerExist = RestUtil.get(providerEndpoint).isSuccess();
            if (!providerExist) {
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage(COMMON_BUNDLE, "msg.error.noSuchProvider"));
                return;
            }
            Map<String, Object> providerMap = RestUtil.getEntityAttrs(providerEndpoint, "entity");
            providerMap.put("className", attrMap.get("ClassName"));
            providerMap.put("providerType", attrMap.get("ProviderType"));
            RestUtil.sendUpdateRequest(endpoint, providerMap, null, null, null);
        } else {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            attrs.put("providerId", attrMap.get(PROPERTY_NAME));
            attrs.put("className", attrMap.get("ClassName"));
            attrs.put("providerType", attrMap.get("ProviderType"));
            if (propList.size() > 0) {
                Map[] propMaps = propList.toArray(new Map[propList.size()]);
                attrs.put("property", propMaps);
            }
            RestUtil.sendCreateRequest(endpoint, attrs, null, null, null);
        }
        String[] attrList = new String[]{"Request-AuthSource", "Request-AuthRecipient", "Response-AuthSource", "Response-AuthRecipient"};
        for (int i = 0; i < attrList.length; ++i) {
            if (!"".equals(attrMap.get(attrList[i]))) continue;
            attrMap.put(attrList[i], null);
        }
        HashMap<String, Object> reqPolicyMap = new HashMap<String, Object>();
        reqPolicyMap.put("authSource", attrMap.get("Request-AuthSource"));
        reqPolicyMap.put("authRecipient", attrMap.get("Request-AuthRecipient"));
        String reqPolicyEP = providerEndpoint + "/request-policy";
        RestUtil.sendUpdateRequest(reqPolicyEP, reqPolicyMap, null, null, null);
        HashMap<String, Object> respPolicyMap = new HashMap<String, Object>();
        respPolicyMap.put("authSource", attrMap.get("Response-AuthSource"));
        respPolicyMap.put("authRecipient", attrMap.get("Response-AuthRecipient"));
        String respPolicyEP = providerEndpoint + "/response-policy";
        RestUtil.sendUpdateRequest(respPolicyEP, respPolicyMap, null, null, null);
    }

    public static void saveSecurityManagerValue(HandlerContext handlerCtx) {
        try {
            RestResponse response;
            ArrayList kv;
            String str;
            String s;
            int i;
            String value;
            Boolean userValue;
            Boolean status;
            String endpoint;
            HashMap result;
            ArrayList list;
            String configName = (String)handlerCtx.getInputValue("configName");
            if (GuiUtil.isEmpty(configName)) {
                configName = "server-config";
            }
            if ((list = (ArrayList)((Map)(result = (HashMap)RestUtil.restRequest(endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/" + configName + "/java-config/jvm-options.json", null, "GET", null, false).get("data")).get("extraProperties")).get("leafList")) == null) {
                list = new ArrayList();
            }
            if ((status = SecurityHandler.isSecurityManagerEnabled(list)).equals(userValue = new Boolean(value = (String)handlerCtx.getInputValue("value")))) {
                return;
            }
            ArrayList<Object> newOptions = new ArrayList<Object>();
            Object[] origOptions = list.toArray();
            if (userValue.booleanValue()) {
                for (i = 0; i < origOptions.length; ++i) {
                    newOptions.add(origOptions[i]);
                }
                newOptions.add(JVM_OPTION_SECURITY_MANAGER);
            } else {
                for (i = 0; i < origOptions.length; ++i) {
                    String str2 = (String)origOptions[i];
                    if (str2.trim().equals(JVM_OPTION_SECURITY_MANAGER) || str2.trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
                    newOptions.add(origOptions[i]);
                }
            }
            HashMap<String, Object> payload = null;
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                str = s = (String)i$.next();
                payload = new HashMap<String, Object>();
                kv = InstanceHandler.getKeyValuePair(str);
                payload.put((String)kv.get(0), kv.get(1));
                response = RestUtil.delete(endpoint, payload);
                if (response.isSuccess()) continue;
                throw new Exception(response.getResponseBody());
            }
            i$ = newOptions.iterator();
            while (i$.hasNext()) {
                str = s = i$.next();
                payload = new HashMap();
                kv = InstanceHandler.getKeyValuePair(str);
                payload.put((String)kv.get(0), kv.get(1));
                response = RestUtil.post(endpoint, payload);
                if (response.isSuccess()) continue;
                throw new Exception(response.getResponseBody());
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getSecurityManagerValue(HandlerContext handlerCtx) {
        ArrayList list = InstanceHandler.getJvmOptions(handlerCtx);
        handlerCtx.setOutputValue("value", (Object)SecurityHandler.isSecurityManagerEnabled(list).toString());
    }

    private static Boolean isSecurityManagerEnabled(List<String> jvmOptions) {
        for (String jvmOption : jvmOptions) {
            if (!jvmOption.trim().equals(JVM_OPTION_SECURITY_MANAGER) && !jvmOption.trim().startsWith(JVM_OPTION_SECURITY_MANAGER_WITH_EQUAL)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static String str(String aa) {
        return aa == null ? "" : aa;
    }

    static {
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/configs/config/server-config/security-service/auth-realm/list-predefined-authrealm-classnames";
        Map<String, Object> responseMap = RestUtil.restRequest(endpoint, null, "GET", null, false);
        Map valueMap = (Map)responseMap.get("data");
        ArrayList classNames = (ArrayList)valueMap.get("children");
        for (HashMap className : classNames) {
            realmClassList.add(className.get("message"));
        }
        skipRealmPropsList.add("jaas-context");
        skipRealmPropsList.add("file");
        skipRealmPropsList.add("assign-groups");
        skipRealmPropsList.add("base-dn");
        skipRealmPropsList.add("directory");
        skipRealmPropsList.add("datasource-jndi");
        skipRealmPropsList.add("user-table");
        skipRealmPropsList.add("user-name-column");
        skipRealmPropsList.add("password-column");
        skipRealmPropsList.add("group-table");
        skipRealmPropsList.add("group-name-column");
        skipRealmPropsList.add("db-user");
        skipRealmPropsList.add("db-password");
        skipRealmPropsList.add("digest-algorithm");
        skipRealmPropsList.add("encoding");
        skipRealmPropsList.add("charset");
    }
}

