/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;

public class LoggingHandlers {
    private static final List<String> levels = new ArrayList<String>();

    public static void getLoggerLevels(HandlerContext handlerCtx) {
        Map loggerLevels = (Map)handlerCtx.getInputValue("loggerLevels");
        ArrayList result = new ArrayList();
        if (loggerLevels != null) {
            for (Map.Entry e : loggerLevels.entrySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                oneRow.put("loggerName", e.getKey());
                oneRow.put("level", e.getValue());
                oneRow.put("selected", false);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("loggerList", result);
    }

    public static void changeLoggerLevels(HandlerContext handlerCtx) {
        List obj;
        String newLogLevel = (String)handlerCtx.getInputValue("newLogLevel");
        List allRows = obj = (List)handlerCtx.getInputValue("allRows");
        if (GuiUtil.isEmpty(newLogLevel)) {
            handlerCtx.setOutputValue("newList", (Object)allRows);
            return;
        }
        for (Map oneRow : allRows) {
            boolean selected = (Boolean)oneRow.get("selected");
            if (!selected) continue;
            oneRow.put("level", newLogLevel);
            oneRow.put("selected", false);
        }
        handlerCtx.setOutputValue("newList", (Object)allRows);
    }

    public static void updateLoggerLevels(HandlerContext handlerCtx) {
        block3: {
            List allRows = (List)handlerCtx.getInputValue("allRows");
            String config = (String)handlerCtx.getInputValue("config");
            HashMap<String, Object> props = new HashMap<String, Object>();
            try {
                for (Map oneRow : allRows) {
                    props.put("id", oneRow.get("loggerName") + "=" + oneRow.get("level"));
                    props.put("target", config);
                    RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/set-log-levels.json", props, "POST", null, false, true);
                }
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static void saveLoggingAttributes(HandlerContext handlerCtx) {
        block3: {
            Map attrs = (Map)handlerCtx.getInputValue("attrs");
            String attrsInUI = (String)handlerCtx.getInputValue("attrsInUI");
            String[] attrNames = attrsInUI.split(",");
            String config = (String)handlerCtx.getInputValue("config");
            HashMap<String, Object> props = new HashMap<String, Object>();
            try {
                for (String key : attrNames) {
                    props.put("id", key + "='" + attrs.get(key) + "'");
                    props.put("target", config);
                    RestUtil.restRequest((String)GuiUtil.getSessionValue("REST_URL") + "/set-log-attributes.json", props, "POST", null, false, true);
                }
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block3;
                ex.printStackTrace();
            }
        }
    }

    public static void getValidLogLevels(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("loggerList", levels);
    }

    static {
        levels.add("OFF");
        levels.add("SEVERE");
        levels.add("WARNING");
        levels.add("INFO");
        levels.add("CONFIG");
        levels.add("FINE");
        levels.add("FINER");
        levels.add("FINEST");
    }
}

