/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.RestUtil;

public class WebAppHandlers {
    public static void ensureDefaultWebModule(HandlerContext handlerCtx) throws Exception {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String vsName = (String)handlerCtx.getInputValue("vsName");
        String encodedName = URLEncoder.encode(vsName, "UTF-8");
        List instanceList = (List)handlerCtx.getInputValue("instanceList");
        Map vsAttrs = RestUtil.getAttributesMap(endpoint + "/" + encodedName);
        String webModule = (String)vsAttrs.get("defaultWebModule");
        if (GuiUtil.isEmpty(webModule)) {
            return;
        }
        String appName = webModule;
        int index = webModule.indexOf("#");
        if (index != -1) {
            appName = webModule.substring(0, index);
        }
        String serverEndPoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
        for (String serverName : instanceList) {
            String encodedAppName = URLEncoder.encode(appName, "UTF-8");
            String encodedServerName = URLEncoder.encode(serverName, "UTF-8");
            String apprefEndpoint = serverEndPoint + encodedServerName + "/application-ref/" + encodedAppName;
            Map apprefAttrs = RestUtil.getAttributesMap(apprefEndpoint);
            String vsStr = (String)apprefAttrs.get("virtualServers");
            if (GuiUtil.isEmpty(vsStr)) {
                vsStr = vsName;
            } else {
                List vsList = GuiUtil.parseStringList(vsStr, ",");
                if (vsList.contains(vsName)) continue;
                vsStr = vsStr + "," + vsName;
            }
            apprefAttrs.put("virtualServers", vsStr);
            RestResponse response = RestUtil.sendUpdateRequest(apprefEndpoint, apprefAttrs, null, null, null);
            if (!response.isSuccess()) {
                GuiUtil.getLogger().severe("Update virtual server failed.  parent=" + apprefEndpoint + "; attrsMap =" + apprefAttrs);
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
                return;
            }
            ArrayList<String> targets = new ArrayList<String>();
            targets.add("domain");
            DeployUtil.reloadApplication(appName, targets, handlerCtx);
        }
    }

    public static void checkVsOfAppRef(HandlerContext handlerCtx) throws Exception {
        String configUrl = GuiUtil.getSessionValue("REST_URL") + "/configs/config/";
        ArrayList<String> configs = new ArrayList<String>(RestUtil.getChildMap(configUrl).keySet());
        ArrayList vsList = new ArrayList();
        for (Object e : configs) {
            String string = configUrl + e + "/http-service/virtual-server";
            ArrayList<String> vsNames = new ArrayList<String>(RestUtil.getChildMap(string).keySet());
            for (Object e2 : vsNames) {
                if (vsList.contains(e2)) continue;
                vsList.add(e2);
            }
        }
        ArrayList<String> servers = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server").keySet());
        for (Object e : servers) {
            String serverEndpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + e;
            ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(serverEndpoint + "/application-ref").keySet());
            for (Object e3 : appRefs) {
                String apprefEndpoint = serverEndpoint + "/application-ref/" + e3;
                Map apprefAttrs = RestUtil.getAttributesMap(apprefEndpoint);
                String vsStr = (String)apprefAttrs.get("VirtualServers");
                List lvsList = GuiUtil.parseStringList(vsStr, ",");
                boolean changed = false;
                for (String oneVs : lvsList) {
                    if (vsList.contains(oneVs)) continue;
                    changed = true;
                }
                if (!changed) continue;
                apprefAttrs.put("VirtualServers", vsStr);
                RestResponse response = RestUtil.sendUpdateRequest(apprefEndpoint, apprefAttrs, null, null, null);
                if (response.isSuccess()) continue;
                GuiUtil.getLogger().severe("Update virtual server failed.  parent=" + apprefEndpoint + "; attrsMap =" + apprefAttrs);
                GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
                return;
            }
        }
    }
}

