/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.DASConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.PropertyConfig;
import com.sun.appserv.management.ext.runtime.RuntimeMgr;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.Calendar;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.MiscUtil;
import org.glassfish.admingui.util.HtmlAdaptor;

public class CommonHandlers {
    private static final String CHARTING_COOKIE_NAME = "as91-doCharting";
    private static final int INDEX = 0;
    private static final String UPDATE_CENTER_NUM_UPDATES = "updateCenterNumUpdates";
    private static final String UPDATE_CENTER_NUM_SOFTWARES = "updateCenterNumSoftwares";

    public static void isEE(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("isEE", (Object)AMXRoot.getInstance().isEE());
    }

    public static void initClusterSessionAttribute(HandlerContext handlerCtx) {
        Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        sessionMap.put("appSummaryView", true);
        sessionMap.put("webSummaryView", true);
        sessionMap.put("ejbSummaryView", true);
        sessionMap.put("appclientSummaryView", true);
        sessionMap.put("rarSummaryView", true);
        sessionMap.put("lifecycleSummaryView", true);
        sessionMap.put("adminObjectSummaryView", true);
        sessionMap.put("connectorResSummaryView", true);
        sessionMap.put("customResSummaryView", true);
        sessionMap.put("externalResSummaryView", true);
        sessionMap.put("javaMailSessionSummaryView", true);
        sessionMap.put("jdbcResSummaryView", true);
        sessionMap.put("jmsConnectionSummaryView", true);
        sessionMap.put("jmsDestinationSummaryView", true);
    }

    public static void initSessionAttributes(HandlerContext handlerCtx) {
        Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        DomainRoot domainRoot = AMXRoot.getInstance().getDomainRoot();
        Object initialized = sessionMap.get("_SESSION_INITIALIZED");
        if (initialized != null) {
            return;
        }
        try {
            sessionMap.put("domainName", domainRoot.getAppserverDomainName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            sessionMap.put("domainName", "");
        }
        String user = handlerCtx.getFacesContext().getExternalContext().getRemoteUser();
        sessionMap.put("userName", user == null ? "" : user);
        Object request = handlerCtx.getFacesContext().getExternalContext().getRequest();
        if (request instanceof ServletRequest) {
            ServletRequest srequest = (ServletRequest)request;
            String serverName = srequest.getServerName();
            String serverPortStr = ((HTTPListenerConfig)AMXRoot.getInstance().getConfig("server-config").getHTTPServiceConfig().getHTTPListenerConfigMap().get("admin-listener")).getPort();
            int serverPort = Integer.parseInt(serverPortStr);
            sessionMap.put("serverName", serverName);
            sessionMap.put("severPort", serverPort);
            sessionMap.put("requestIsSecured", srequest.isSecure());
        } else {
            sessionMap.put("serverName", "");
        }
        sessionMap.put("reqMsg", GuiUtil.getMessage((String)"msg.JS.enterValue"));
        sessionMap.put("reqMsgSelect", GuiUtil.getMessage((String)"msg.JS.selectValue"));
        sessionMap.put("reqInt", GuiUtil.getMessage((String)"msg.JS.enterIntegerValue"));
        sessionMap.put("reqNum", GuiUtil.getMessage((String)"msg.JS.enterNumericValue"));
        sessionMap.put("reqPort", GuiUtil.getMessage((String)"msg.JS.enterPortValue"));
        sessionMap.put("_SESSION_INITIALIZED", "TRUE");
        ConfigConfig config = AMXRoot.getInstance().getConfig("server-config");
        DASConfig dConfig = config.getAdminServiceConfig().getDASConfig();
        try {
            String timeOut = dConfig.getAdminSessionTimeoutInMinutes();
            if (timeOut != null && !timeOut.equals("")) {
                int time = new Integer(timeOut);
                if (time == 0) {
                    ((HttpServletRequest)request).getSession().setMaxInactiveInterval(-1);
                } else {
                    ((HttpServletRequest)request).getSession().setMaxInactiveInterval(time * 60);
                }
            }
        }
        catch (Exception nfe) {
            ((HttpServletRequest)request).getSession().setMaxInactiveInterval(-1);
            nfe.printStackTrace();
        }
        HtmlAdaptor.registerHTMLAdaptor(AMXRoot.getInstance().getMBeanServerConnection());
    }

    public static void initProductInfoAttributes(HandlerContext handlerCtx) {
        Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        Object initialized = sessionMap.get("_INFO_SESSION_INITIALIZED");
        if (initialized != null) {
            return;
        }
        sessionMap.put("productImageURL", GuiUtil.getMessage((String)"productImage.URL"));
        sessionMap.put("productImageWidth", Integer.parseInt(GuiUtil.getMessage((String)"productImage.width")));
        sessionMap.put("productImageHeight", Integer.parseInt(GuiUtil.getMessage((String)"productImage.height")));
        sessionMap.put("loginProductImageURL", GuiUtil.getMessage((String)"login.productImage.URL"));
        sessionMap.put("loginProductImageWidth", Integer.parseInt(GuiUtil.getMessage((String)"login.productImage.width")));
        sessionMap.put("loginProductImageHeight", Integer.parseInt(GuiUtil.getMessage((String)"login.productImage.height")));
        sessionMap.put("fullProductName", GuiUtil.getMessage((String)"versionImage.description"));
        sessionMap.put("loginButtonTooltip", GuiUtil.getMessage((String)"loginButtonTooltip"));
        sessionMap.put("mastHeadDescription", GuiUtil.getMessage((String)"mastHeadDescription"));
        sessionMap.put("_INFO_SESSION_INITIALIZED", "TRUE");
    }

    public static void getAppServerVersion(HandlerContext handlerCtx) {
        String version = AMXRoot.getInstance().getDomainRoot().getApplicationServerFullVersion();
        handlerCtx.setOutputValue("version", (Object)version);
    }

    public static void getAppServerFullVersion(HandlerContext handlerCtx) {
        String version = AMXRoot.getInstance().getDomainRoot().getApplicationServerFullVersion();
        handlerCtx.setOutputValue("fullVersion", (Object)version);
    }

    public static void getListElement(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        Integer selectedIndex = (Integer)handlerCtx.getInputValue("index");
        String[] listItem = null;
        if (list != null) {
            if (selectedIndex == null) {
                selectedIndex = new Integer(0);
            }
            listItem = new String[]{(String)list.get(selectedIndex)};
        }
        handlerCtx.setOutputValue("selectedIndex", listItem);
    }

    public static void getConfigName(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        String configName = AMXRoot.getInstance().getConfigName(target);
        handlerCtx.setOutputValue("configName", (Object)configName);
    }

    public static void selectiveEncode(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("value");
        String delim = (String)handlerCtx.getInputValue("delim");
        String encType = (String)handlerCtx.getInputValue("type");
        String encodedString = GuiUtil.encode((String)value, (String)delim, (String)encType);
        handlerCtx.setOutputValue("value", (Object)encodedString);
    }

    public static void logout(HandlerContext handlerCtx) {
        ExternalContext extContext = handlerCtx.getFacesContext().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)extContext.getRequest();
        request.getSession().invalidate();
    }

    public static void setComponentRequired(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("id");
        String required = (String)handlerCtx.getInputValue("required");
        UIViewRoot viewRoot = handlerCtx.getFacesContext().getViewRoot();
        if (viewRoot == null) {
            return;
        }
        try {
            UIInput targetComponent = (UIInput)viewRoot.findComponent(id);
            if (targetComponent != null) {
                targetComponent.setRequired(Boolean.valueOf(required).booleanValue());
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void testExists(HandlerContext handlerCtx) {
        String attr = (String)handlerCtx.getInputValue("attr");
        if (GuiUtil.isEmpty((String)attr)) {
            handlerCtx.setOutputValue("defined", (Object)false);
        } else {
            handlerCtx.setOutputValue("defined", (Object)true);
        }
    }

    public static void getDatePattern(HandlerContext handlerCtx) {
        Calendar calendar = (Calendar)handlerCtx.getInputValue("calendarComponent");
        String pattern = calendar.getDateFormatPattern();
        if (!(pattern != null && pattern.length() != 0 || (pattern = calendar.getDatePicker().getDateFormatPattern()) != null && pattern.length() != 0)) {
            pattern = "MM/dd/yyyy";
        }
        handlerCtx.setOutputValue("pattern", (Object)pattern);
    }

    public static void getRequestValue(HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("key");
        Object defaultValue = handlerCtx.getInputValue("default");
        Object value = handlerCtx.getFacesContext().getExternalContext().getRequestParameterMap().get(key);
        if (value == null) {
            value = handlerCtx.getFacesContext().getExternalContext().getRequestMap().get(key);
            if (value == null && defaultValue != null) {
                value = defaultValue;
            }
        } else if (value instanceof String && "".equals(value)) {
            value = handlerCtx.getFacesContext().getExternalContext().getRequestMap().get(key);
        }
        handlerCtx.setOutputValue("value", value);
    }

    public void longAdd(HandlerContext handlerCtx) {
        Long long1 = (Long)handlerCtx.getInputValue("Long1");
        Long long2 = (Long)handlerCtx.getInputValue("Long2");
        Long result = new Long(long1 + long2);
        handlerCtx.setOutputValue("LongResult", (Object)result);
    }

    public void getCurrentTime(HandlerContext handlerCtx) {
        Date d = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, handlerCtx.getFacesContext().getViewRoot().getLocale());
        String currentTime = dateFormat.format(d);
        handlerCtx.setOutputValue("CurrentTime", (Object)currentTime);
    }

    public void checkRestart(HandlerContext handlerCtx) {
        List changes = AMXRoot.getInstance().getDomainRoot().getSystemStatus().getRestartRequiredChanges();
        handlerCtx.setOutputValue("RestartRequired", (Object)(changes.size() > 0 ? 1 : 0));
        handlerCtx.setOutputValue("unprocessedChanges", (Object)changes);
    }

    public void getPropsValue(HandlerContext handlerCtx) {
        PropertiesAccess mbean = (PropertiesAccess)handlerCtx.getInputValue("mbean");
        List propsName = (List)handlerCtx.getInputValue("propsName");
        if (mbean == null) {
            if (propsName != null) {
                handlerCtx.setOutputValue("propsValue", new ArrayList(propsName.size()));
            }
            return;
        }
        Map mbeanProps = mbean.getPropertyConfigMap();
        ArrayList<String> propsValue = new ArrayList<String>(propsName.size());
        for (String nm : propsName) {
            String value = ((PropertyConfig)mbeanProps.get(nm)).getValue();
            propsValue.add(value == null ? "" : value);
        }
        handlerCtx.setOutputValue("propsValue", propsValue);
    }

    public void savePropsValue(HandlerContext handlerCtx) {
        PropertiesAccess mbean = (PropertiesAccess)handlerCtx.getInputValue("mbean");
        List propsName = (List)handlerCtx.getInputValue("propsName");
        List propsValue = (List)handlerCtx.getInputValue("propsValue");
        if (mbean == null) {
            return;
        }
        for (int i = 0; i < propsName.size(); ++i) {
            AMXUtil.setPropertyValue((PropertiesAccess)mbean, (String)((String)propsValue.get(i)), (String)((String)propsName.get(i)));
        }
    }

    public void getMbeanProperties(HandlerContext handlerCtx) {
        PropertiesAccess mbean = (PropertiesAccess)handlerCtx.getInputValue("mbean");
        List ignoreProps = (List)handlerCtx.getInputValue("ignoreProps");
        Map allProps = mbean.getPropertyConfigMap();
        if (ignoreProps != null) {
            for (String nm : ignoreProps) {
                if (allProps.get(nm) == null) continue;
                allProps.remove(nm);
            }
        }
        handlerCtx.setOutputValue("result", (Object)allProps);
    }

    public void getChartingCookieName(HandlerContext handlerCtx) {
        String userName = (String)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("userName");
        handlerCtx.setOutputValue("cookieName", (Object)(userName + "." + CHARTING_COOKIE_NAME));
    }

    public void getChartingCookieInfo(HandlerContext handlerCtx) {
        String userName = (String)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("userName");
        String cookieName = userName + "." + CHARTING_COOKIE_NAME;
        Map cookies = handlerCtx.getFacesContext().getExternalContext().getRequestCookieMap();
        Cookie cookie = (Cookie)cookies.get(cookieName);
        String value = cookie == null ? "" : cookie.getValue();
        handlerCtx.setOutputValue("name", (Object)cookieName);
        handlerCtx.setOutputValue("doCharting", (Object)value.equals("true"));
        handlerCtx.setOutputValue("setCookieTo", (Object)(value.equals("true") ? "false" : "true"));
    }

    public void getUpdateCenterInfo(HandlerContext handlerCtx) {
        String numUpdates = (String)GuiUtil.getSessionValue((String)UPDATE_CENTER_NUM_UPDATES);
        String numNewModules = (String)GuiUtil.getSessionValue((String)UPDATE_CENTER_NUM_SOFTWARES);
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        if (installRoot == null) {
            installRoot = "install-root";
        }
        String updateTool = installRoot + File.separator + "updatecenter" + File.separator + "bin" + File.separator + "updatetool";
        updateTool = updateTool.replace('\\', '/');
        handlerCtx.setOutputValue("updates", (Object)numUpdates);
        handlerCtx.setOutputValue("modules", (Object)numNewModules);
        handlerCtx.setOutputValue("tool", (Object)updateTool);
        handlerCtx.setOutputValue("wiki", (Object)"http://wiki.updatecenter.java.net/Wiki.jsp?page=GettingStarted");
    }

    public static void setValueExpression(HandlerContext handlerCtx) {
        MiscUtil.setValueExpression((String)((String)handlerCtx.getHandler().getInputValue("expression")), (Object)handlerCtx.getInputValue("value"));
    }

    public static void checkSupport(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("supportCluster", (Object)AMXRoot.getInstance().supportCluster());
        handlerCtx.setOutputValue("supportHADB", (Object)false);
    }

    public static void getDeploymentDescriptor(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        String descriptorName = (String)handlerCtx.getInputValue("descriptorName");
        RuntimeMgr runtimeMgr = AMXRoot.getInstance().getRuntimeMgr();
        String descriptorText = (String)runtimeMgr.getDeploymentConfigurations(appName).get(descriptorName);
        if (GuiUtil.isEmpty((String)descriptorText)) {
            System.out.printf("Could not locate %s%n", descriptorName);
        }
        handlerCtx.setOutputValue("descriptorText", (Object)descriptorText);
    }
}

