/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.glassfish.admingui.handlers.Tag;

public class PreferencesHandler {
    public static void saveTagInformation(HandlerContext handlerCtx) {
        try {
            String tag = (String)handlerCtx.getInputValue("tag");
            String name = (String)handlerCtx.getInputValue("name");
            String url = (String)handlerCtx.getInputValue("url");
            String user = handlerCtx.getFacesContext().getExternalContext().getUserPrincipal().getName();
            System.out.println("Adding the  '" + tag + "' ('" + name + "') for URL '" + url + "' on behalf of the user '" + user + "'.");
            Preferences tags = Preferences.userRoot().node(user).node("tags");
            Preferences page = tags.node(tag).node(name);
            page.put("url", url);
            for (String child1 : tags.childrenNames()) {
                Preferences node = tags.node(child1);
                for (String child2 : node.childrenNames()) {
                    System.out.println("Child the tag " + tag + ":  " + child2);
                }
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void searchTags(HandlerContext handlerCtx) throws BackingStoreException {
        String tag = (String)handlerCtx.getInputValue("tag");
        String user = handlerCtx.getFacesContext().getExternalContext().getUserPrincipal().getName();
        Preferences tags = Preferences.userRoot().node(user).node("tags").node(tag);
        ArrayList<Tag> hits = new ArrayList<Tag>();
        for (String entry : tags.childrenNames()) {
            Preferences child = tags.node(entry);
            hits.add(new Tag(child.get("url", ""), entry));
        }
        handlerCtx.setOutputValue("hits", hits);
    }

    public static void main(String ... args) {
        try {
            Preferences base = Preferences.userRoot().node("anonymous.tags.foo");
            Preferences page1 = base.node("This is the home page");
            page1.put("url", "http://localhost:8080/admingui/layouttest.jsf");
            Preferences page2 = base.node("This is the home page as well");
            page2.put("url", "http://localhost:8080/admingui/layouttest.jsf");
            System.out.println("Loop #1");
            for (String name : base.childrenNames()) {
                System.out.println("Child node for foo: " + name);
            }
            base.removeNode();
            base = Preferences.userRoot().node("anonymous.tags.foo");
            System.out.println("Loop #2");
            for (String name : base.childrenNames()) {
                System.out.println("Child node for foo: " + name);
            }
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PreferencesHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

