/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.config.AccessLogConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.ConfigElement;
import com.sun.appserv.management.config.ConnectionPoolConfig;
import com.sun.appserv.management.config.HTTPFileCacheConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.HTTPProtocolConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.KeepAliveConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.PropertyConfig;
import com.sun.appserv.management.config.RequestProcessingConfig;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;

public class HttpServiceHandlers {
    private static List httpServiceSkipPropsList = new ArrayList();
    private static final String ADMIN_LISTENER = "admin-listener";
    private static final String PROXIED_PROTOCOLS = "proxiedProtocols";
    private static final String PROXIED_PROTOCOLS_VALUE = "http";

    public static void getAccessLogSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        AccessLogConfig al = config.getHTTPServiceConfig().getAccessLogConfig();
        String policy = "";
        String interval = "";
        String suffix = "";
        String format = "";
        String rotation = "true";
        if (al != null) {
            rotation = al.getRotationEnabled();
            policy = al.getRotationPolicy();
            interval = al.getRotationIntervalInMinutes();
            suffix = al.getRotationSuffix();
            format = al.getFormat();
        } else {
            Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-AccessLogConfig", true);
            policy = (String)defaultMap.get("RotationPolicy");
            interval = (String)defaultMap.get("RotationIntervalInMinutes");
            suffix = (String)defaultMap.get("RotationSuffix");
            format = (String)defaultMap.get("Format");
            rotation = (String)defaultMap.get("RotationEnabled");
        }
        handlerCtx.setOutputValue("Rotation", (Object)rotation);
        handlerCtx.setOutputValue("Policy", (Object)policy);
        handlerCtx.setOutputValue("Interval", (Object)interval);
        handlerCtx.setOutputValue("Suffix", (Object)suffix);
        handlerCtx.setOutputValue("Format", (Object)format);
    }

    public static void getAccessLogDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-AccessLogConfig", true);
        String rotationKey = (String)defaultMap.get("RotationEnabled");
        boolean rotation = rotationKey == null ? false : Boolean.valueOf(rotationKey);
        handlerCtx.setOutputValue("Rotation", (Object)rotation);
        handlerCtx.setOutputValue("Policy", defaultMap.get("RotationPolicy"));
        handlerCtx.setOutputValue("Interval", defaultMap.get("RotationIntervalInMinutes"));
        handlerCtx.setOutputValue("Suffix", defaultMap.get("RotationSuffix"));
        handlerCtx.setOutputValue("Format", defaultMap.get("Format"));
    }

    public static void saveAccessLogSettings(HandlerContext handlerCtx) {
        try {
            ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
            AccessLogConfig al = config.getHTTPServiceConfig().getAccessLogConfig();
            if (al == null) {
                al = config.getHTTPServiceConfig().createAccessLogConfig(new HashMap());
            }
            al.setRotationEnabled((String)handlerCtx.getInputValue("Rotation"));
            al.setRotationPolicy((String)handlerCtx.getInputValue("Policy"));
            al.setRotationIntervalInMinutes((String)handlerCtx.getInputValue("Interval"));
            al.setRotationSuffix((String)handlerCtx.getInputValue("Suffix"));
            al.setFormat((String)handlerCtx.getInputValue("Format"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getRequestProcessingSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        RequestProcessingConfig rp = config.getHTTPServiceConfig().getRequestProcessingConfig();
        String count = rp.getThreadCount();
        String initial = rp.getInitialThreadCount();
        String increment = rp.getThreadIncrement();
        String timeout = rp.getRequestTimeoutInSeconds();
        String buffer = rp.getHeaderBufferLengthInBytes();
        handlerCtx.setOutputValue("Count", (Object)count);
        handlerCtx.setOutputValue("Initial", (Object)initial);
        handlerCtx.setOutputValue("Increment", (Object)increment);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
        handlerCtx.setOutputValue("Buffer", (Object)buffer);
    }

    public static void getRequestProcessingDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-RequestProcessingConfig", true);
        handlerCtx.setOutputValue("Count", defaultMap.get("ThreadCount"));
        handlerCtx.setOutputValue("Initial", defaultMap.get("InitialThreadCount"));
        handlerCtx.setOutputValue("Increment", defaultMap.get("ThreadIncrement"));
        handlerCtx.setOutputValue("Timeout", defaultMap.get("RequestTimeoutInSeconds"));
        handlerCtx.setOutputValue("Buffer", defaultMap.get("HeaderBufferLengthInBytes"));
    }

    public static void saveRequestProcessingSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            RequestProcessingConfig rp = config.getHTTPServiceConfig().getRequestProcessingConfig();
            rp.setThreadCount((String)handlerCtx.getInputValue("Count"));
            rp.setInitialThreadCount((String)handlerCtx.getInputValue("Initial"));
            rp.setThreadIncrement((String)handlerCtx.getInputValue("Increment"));
            rp.setRequestTimeoutInSeconds((String)handlerCtx.getInputValue("Timeout"));
            rp.setHeaderBufferLengthInBytes((String)handlerCtx.getInputValue("Buffer"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getKeepAliveSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        KeepAliveConfig rp = config.getHTTPServiceConfig().getKeepAliveConfig();
        String count = rp.getThreadCount();
        String connections = rp.getMaxConnections();
        String timeout = rp.getTimeoutInSeconds();
        handlerCtx.setOutputValue("Count", (Object)count);
        handlerCtx.setOutputValue("Connections", (Object)connections);
        handlerCtx.setOutputValue("Timeout", (Object)timeout);
    }

    public static void getKeepAliveDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-KeepAliveConfig", true);
        handlerCtx.setOutputValue("Count", defaultMap.get("ThreadCount"));
        handlerCtx.setOutputValue("Connections", defaultMap.get("MaxConnections"));
        handlerCtx.setOutputValue("Timeout", defaultMap.get("TimeoutInSeconds"));
    }

    public static void saveKeepAliveSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        KeepAliveConfig rp = config.getHTTPServiceConfig().getKeepAliveConfig();
        rp.setThreadCount((String)handlerCtx.getInputValue("Count"));
        rp.setMaxConnections((String)handlerCtx.getInputValue("Connections"));
        rp.setTimeoutInSeconds((String)handlerCtx.getInputValue("Timeout"));
    }

    public static void getHttpService(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        HTTPServiceConfig hConfig = config.getHTTPServiceConfig();
        try {
            handlerCtx.setOutputValue("Properties", (Object)AMXUtil.getNonSkipPropertiesMap((PropertiesAccess)hConfig, (List)httpServiceSkipPropsList));
            Map origProps = hConfig.getPropertyConfigMap();
            handlerCtx.setOutputValue("accessLogBufferSize", (Object)AMXUtil.getPropertyValue((PropertiesAccess)hConfig, (String)"accessLogBufferSize"));
            handlerCtx.setOutputValue("accessLogWriteInterval", (Object)AMXUtil.getPropertyValue((PropertiesAccess)hConfig, (String)"accessLogWriteInterval"));
            String alog = ((PropertyConfig)origProps.get("accessLoggingEnabled")).getValue();
            Boolean accessLoggingEnabled = true;
            accessLoggingEnabled = GuiUtil.isEmpty((String)alog) ? Boolean.valueOf(true) : Boolean.valueOf(alog.equals("true"));
            handlerCtx.setOutputValue("accessLoggingEnabled", (Object)accessLoggingEnabled);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveHttpService(HandlerContext handlerCtx) {
        try {
            ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
            HTTPServiceConfig hConfig = config.getHTTPServiceConfig();
            Map newProps = (Map)handlerCtx.getInputValue("newProps");
            AMXUtil.updateProperties((PropertiesAccess)hConfig, (Map)newProps, (List)httpServiceSkipPropsList);
            AMXUtil.setPropertyValue((PropertiesAccess)hConfig, (String)"accessLogBufferSize", (String)((String)handlerCtx.getInputValue("accessLogBufferSize")));
            AMXUtil.setPropertyValue((PropertiesAccess)hConfig, (String)"accessLogWriteInterval", (String)((String)handlerCtx.getInputValue("accessLogWriteInterval")));
            AMXUtil.setPropertyValue((PropertiesAccess)hConfig, (String)"accessLoggingEnabled", (String)("" + handlerCtx.getInputValue("accessLoggingEnabled")));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getConnectionPoolSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ConnectionPoolConfig cp = config.getHTTPServiceConfig().getConnectionPoolConfig();
        String count = cp.getMaxPendingCount();
        String queue = cp.getQueueSizeInBytes();
        String receive = cp.getReceiveBufferSizeInBytes();
        String send = cp.getSendBufferSizeInBytes();
        handlerCtx.setOutputValue("Count", (Object)count);
        handlerCtx.setOutputValue("Queue", (Object)queue);
        handlerCtx.setOutputValue("Receive", (Object)receive);
        handlerCtx.setOutputValue("Send", (Object)send);
    }

    public static void getConnectionPoolDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-ConnectionPoolConfig", true);
        handlerCtx.setOutputValue("Count", defaultMap.get("MaxPendingCount"));
        handlerCtx.setOutputValue("Queue", defaultMap.get("QueueSizeInBytes"));
        handlerCtx.setOutputValue("Receive", defaultMap.get("ReceiveBufferSizeInBytes"));
        handlerCtx.setOutputValue("Send", defaultMap.get("SendBufferSizeInBytes"));
    }

    public static void saveConnectionPoolSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            ConnectionPoolConfig cp = config.getHTTPServiceConfig().getConnectionPoolConfig();
            cp.setMaxPendingCount((String)handlerCtx.getInputValue("Count"));
            cp.setQueueSizeInBytes((String)handlerCtx.getInputValue("Queue"));
            cp.setReceiveBufferSizeInBytes((String)handlerCtx.getInputValue("Receive"));
            cp.setSendBufferSizeInBytes((String)handlerCtx.getInputValue("Send"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getHttpProtocolSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        HTTPProtocolConfig hp = config.getHTTPServiceConfig().getHTTPProtocolConfig();
        handlerCtx.setOutputValue("Version", (Object)hp.getVersion());
        handlerCtx.setOutputValue("DNS", (Object)hp.getDNSLookupEnabled());
        handlerCtx.setOutputValue("SSL", (Object)hp.getSSLEnabled());
        handlerCtx.setOutputValue("Forced", (Object)hp.getForcedType());
        handlerCtx.setOutputValue("Default", (Object)hp.getDefaultType());
    }

    public static void getHttpProtocolDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-HTTPProtocolConfig", true);
        String version = (String)defaultMap.get("Version");
        String dns = (String)defaultMap.get("DNSLookupEnabled");
        String ssl = (String)defaultMap.get("SSLEnabled");
        String forced = (String)defaultMap.get("ForcedType");
        String defaultResponse = (String)defaultMap.get("DefaultType");
        handlerCtx.setOutputValue("Version", (Object)version);
        if ("true".equals(dns)) {
            handlerCtx.setOutputValue("DNS", (Object)true);
        } else {
            handlerCtx.setOutputValue("DNS", (Object)false);
        }
        if ("true".equals(ssl)) {
            handlerCtx.setOutputValue("SSL", (Object)true);
        } else {
            handlerCtx.setOutputValue("SSL", (Object)false);
        }
        handlerCtx.setOutputValue("Forced", (Object)forced);
        handlerCtx.setOutputValue("Default", (Object)defaultResponse);
    }

    public static void saveHttpProtocolSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            HTTPProtocolConfig hp = config.getHTTPServiceConfig().getHTTPProtocolConfig();
            hp.setVersion((String)handlerCtx.getInputValue("Version"));
            hp.setDNSLookupEnabled((String)handlerCtx.getInputValue("DNS"));
            hp.setSSLEnabled((String)handlerCtx.getInputValue("SSL"));
            hp.setForcedType((String)handlerCtx.getInputValue("Forced"));
            hp.setDefaultType((String)handlerCtx.getInputValue("Default"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getHttpFileCachingSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        HTTPFileCacheConfig hp = config.getHTTPServiceConfig().getHTTPFileCacheConfig();
        String globally = hp.getGloballyEnabled();
        String age = hp.getMaxAgeInSeconds();
        String fileCount = hp.getMaxFilesCount();
        String hashSize = hp.getHashInitSize();
        String medLimit = hp.getMediumFileSizeLimitInBytes();
        String medSize = hp.getMediumFileSpaceInBytes();
        String smLimit = hp.getSmallFileSizeLimitInBytes();
        String smSize = hp.getSmallFileSpaceInBytes();
        boolean fileCaching = Boolean.valueOf(hp.getFileCachingEnabled());
        if (fileCaching) {
            handlerCtx.setOutputValue("FileCaching", (Object)"ON");
        } else {
            handlerCtx.setOutputValue("FileCaching", (Object)"OFF");
        }
        handlerCtx.setOutputValue("Globally", (Object)globally);
        handlerCtx.setOutputValue("Age", (Object)age);
        handlerCtx.setOutputValue("FileCount", (Object)fileCount);
        handlerCtx.setOutputValue("HashSize", (Object)hashSize);
        handlerCtx.setOutputValue("MedLimit", (Object)medLimit);
        handlerCtx.setOutputValue("MedSize", (Object)medSize);
        handlerCtx.setOutputValue("SmLimit", (Object)smLimit);
        handlerCtx.setOutputValue("SmSize", (Object)smSize);
    }

    public static void getHttpFileCachingDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-HTTPFileCacheConfig", true);
        String globally = (String)defaultMap.get("GloballyEnabled");
        String fileCaching = (String)defaultMap.get("FileCachingEnabled");
        if (globally.equals("true")) {
            handlerCtx.setOutputValue("Globally", (Object)true);
        } else {
            handlerCtx.setOutputValue("Globally", (Object)false);
        }
        if (fileCaching.equals("true")) {
            handlerCtx.setOutputValue("FileCaching", (Object)"ON");
        } else {
            handlerCtx.setOutputValue("FileCaching", (Object)"OFF");
        }
        handlerCtx.setOutputValue("Age", defaultMap.get("MaxAgeInSeconds"));
        handlerCtx.setOutputValue("FileCount", defaultMap.get("MaxFilesCount"));
        handlerCtx.setOutputValue("HashSize", defaultMap.get("HashInitSize"));
        handlerCtx.setOutputValue("MedLimit", defaultMap.get("MediumFileSizeLimitInBytes"));
        handlerCtx.setOutputValue("MedSize", defaultMap.get("MediumFileSpaceInBytes"));
        handlerCtx.setOutputValue("SmLimit", defaultMap.get("SmallFileSizeLimitInBytes"));
        handlerCtx.setOutputValue("SmSize", defaultMap.get("SmallFileSpaceInBytes"));
    }

    public static void saveHttpFileCachingSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        try {
            HTTPFileCacheConfig hp = config.getHTTPServiceConfig().getHTTPFileCacheConfig();
            hp.setGloballyEnabled((String)handlerCtx.getInputValue("Globally"));
            hp.setMaxAgeInSeconds((String)handlerCtx.getInputValue("Age"));
            hp.setMaxFilesCount((String)handlerCtx.getInputValue("FileCount"));
            hp.setHashInitSize((String)handlerCtx.getInputValue("HashSize"));
            hp.setMediumFileSizeLimitInBytes((String)handlerCtx.getInputValue("MedLimit"));
            hp.setMediumFileSpaceInBytes((String)handlerCtx.getInputValue("MedSize"));
            hp.setSmallFileSizeLimitInBytes((String)handlerCtx.getInputValue("SmLimit"));
            hp.setSmallFileSpaceInBytes((String)handlerCtx.getInputValue("SmSize"));
            String fileCaching = (String)handlerCtx.getInputValue("FileCaching");
            if (fileCaching.equals("ON")) {
                hp.setFileCachingEnabled("true");
            } else {
                hp.setFileCachingEnabled("false");
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getHttpListenersList(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        ArrayList result = new ArrayList();
        Iterator iter = null;
        try {
            boolean hasOrig;
            iter = config.getHTTPServiceConfig().getHTTPListenerConfigMap().values().iterator();
            List selectedList = (List)handlerCtx.getInputValue("selectedRows");
            boolean bl = hasOrig = selectedList != null && selectedList.size() != 0;
            if (iter != null) {
                while (iter.hasNext()) {
                    ConfigElement configE = (ConfigElement)iter.next();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    String name = configE.getName();
                    oneRow.put("name", name);
                    oneRow.put("selected", hasOrig ? GuiUtil.isSelected((String)name, (List)selectedList) : false);
                    HTTPListenerConfig httpConfig = (HTTPListenerConfig)configE;
                    String enabled = "" + httpConfig.getEnabled();
                    String ntwkAddress = httpConfig.getAddress();
                    String listPort = httpConfig.getPort();
                    String virtualServer = httpConfig.getDefaultVirtualServer();
                    oneRow.put("enabled", enabled);
                    oneRow.put("ntwkAddress", ntwkAddress == null ? " " : ntwkAddress);
                    oneRow.put("listPort", listPort == null ? " " : listPort);
                    oneRow.put("defVirtualServer", virtualServer == null ? " " : virtualServer);
                    result.add(oneRow);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
        handlerCtx.setOutputValue("Result", result);
    }

    public static void deleteHttpListeners(HandlerContext handlerCtx) {
        List obj;
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXRoot.getInstance().getConfig(configName);
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                Iterator iter = config.getHTTPServiceConfig().getVirtualServerConfigMap().values().iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        String result;
                        VirtualServerConfig vs = (VirtualServerConfig)iter.next();
                        String listeners = vs.getHTTPListeners();
                        if (listeners == null || listeners.equals(result = GuiUtil.removeToken((String)listeners, (String)",", (String)name))) continue;
                        vs.setHTTPListeners(result);
                    }
                }
                AMXRoot.getInstance().getConfig(configName).getHTTPServiceConfig().removeHTTPListenerConfig(name);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getHttpListenerValues(HandlerContext handlerCtx) {
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("FromStep2");
            if (!edit.booleanValue()) {
                if (fromStep2 == null || !fromStep2.booleanValue()) {
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("httpProps", new HashMap());
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("sslProps", null);
                    HTTPListenerConfig hc = (HTTPListenerConfig)AMXRoot.getInstance().getConfig("server-config").getHTTPServiceConfig().getHTTPListenerConfigMap().get("http-listener-1");
                    handlerCtx.setOutputValue("Listener", (Object)hc.getDefaultValue("enabled"));
                    handlerCtx.setOutputValue("security", (Object)hc.getDefaultValue("security-enabled"));
                    handlerCtx.setOutputValue("Acceptor", (Object)hc.getDefaultValue("acceptor-threads"));
                    String xx = hc.getDefaultValue("AcceptorThreads");
                    handlerCtx.setOutputValue("PoweredBy", (Object)hc.getDefaultValue("xpowered-by"));
                    handlerCtx.setOutputValue("Blocking", (Object)hc.getDefaultValue("blocking-enabled"));
                } else {
                    Map props = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("httpProps");
                    handlerCtx.setOutputValue("Listener", props.get("enabled"));
                    handlerCtx.setOutputValue("security", props.get("securityEnabled"));
                    handlerCtx.setOutputValue("NetwkAddr", props.get("address"));
                    handlerCtx.setOutputValue("ListenerPort", props.get("port"));
                    handlerCtx.setOutputValue("DefaultVirtServer", props.get("virtualServer"));
                    handlerCtx.setOutputValue("ServerName", props.get("serverName"));
                    handlerCtx.setOutputValue("RedirectPort", props.get("redirectPort"));
                    handlerCtx.setOutputValue("Acceptor", props.get("acceptor-threads"));
                    handlerCtx.setOutputValue("PoweredBy", props.get("xpowered-by"));
                    handlerCtx.setOutputValue("Blocking", props.get("blocking-enabled"));
                    handlerCtx.setOutputValue("Properties", props.get("options"));
                }
                return;
            }
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            String httpListenerName = (String)handlerCtx.getInputValue("HttpName");
            ConfigConfig config = AMXRoot.getInstance().getConfig(configName);
            HTTPListenerConfig httpListConfig = (HTTPListenerConfig)config.getHTTPServiceConfig().getHTTPListenerConfigMap().get(httpListenerName);
            handlerCtx.setOutputValue("Listener", (Object)httpListConfig.getEnabled());
            handlerCtx.setOutputValue("security", (Object)httpListConfig.getSecurityEnabled());
            handlerCtx.setOutputValue("NetwkAddr", (Object)httpListConfig.getAddress());
            handlerCtx.setOutputValue("ListenerPort", (Object)httpListConfig.getPort());
            handlerCtx.setOutputValue("DefaultVirtServer", (Object)httpListConfig.getDefaultVirtualServer());
            handlerCtx.setOutputValue("ServerName", (Object)httpListConfig.getServerName());
            handlerCtx.setOutputValue("RedirectPort", (Object)httpListConfig.getRedirectPort());
            handlerCtx.setOutputValue("Acceptor", (Object)httpListConfig.getAcceptorThreads());
            handlerCtx.setOutputValue("PoweredBy", (Object)httpListConfig.getXpoweredBy());
            handlerCtx.setOutputValue("Blocking", (Object)httpListConfig.getBlockingEnabled());
            handlerCtx.setOutputValue("Properties", (Object)httpListConfig.getPropertyConfigMap());
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveHttpListenerValues(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        String httpListenerName = (String)handlerCtx.getInputValue("HttpName");
        String listPort = (String)handlerCtx.getInputValue("ListenerPort");
        String address = (String)handlerCtx.getInputValue("NetwkAddr");
        String virtualServer = (String)handlerCtx.getInputValue("DefaultVirtServer");
        String serverName = (String)handlerCtx.getInputValue("ServerName");
        ConfigConfig config = AMXRoot.getInstance().getConfig(configName);
        try {
            Boolean edit = (Boolean)handlerCtx.getInputValue("Edit");
            if (!edit.booleanValue()) {
                HashMap<String, Object> httpPropsMap = new HashMap<String, Object>();
                httpPropsMap.put("httpName", httpListenerName);
                httpPropsMap.put("address", address);
                httpPropsMap.put("port", listPort);
                httpPropsMap.put("virtualServer", virtualServer);
                httpPropsMap.put("serverName", serverName);
                httpPropsMap.put("options", (Map)handlerCtx.getInputValue("newProps"));
                httpPropsMap.put("enabled", (String)handlerCtx.getInputValue("Listener"));
                httpPropsMap.put("securityEnabled", (String)handlerCtx.getInputValue("security"));
                httpPropsMap.put("redirectPort", (String)handlerCtx.getInputValue("RedirectPort"));
                httpPropsMap.put("acceptor-threads", (String)handlerCtx.getInputValue("Acceptor"));
                httpPropsMap.put("xpowered-by", (String)handlerCtx.getInputValue("PoweredBy"));
                httpPropsMap.put("blocking-enabled", (String)handlerCtx.getInputValue("Blocking"));
                handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("httpProps", httpPropsMap);
            } else {
                HTTPListenerConfig httpListConfig = (HTTPListenerConfig)config.getHTTPServiceConfig().getHTTPListenerConfigMap().get(httpListenerName);
                String previousVSName = httpListConfig.getDefaultVirtualServer();
                httpListConfig.setAddress(address);
                httpListConfig.setPort((String)handlerCtx.getInputValue("ListenerPort"));
                httpListConfig.setDefaultVirtualServer(virtualServer);
                httpListConfig.setServerName(serverName);
                httpListConfig.setEnabled("" + handlerCtx.getInputValue("Listener"));
                httpListConfig.setSecurityEnabled((String)handlerCtx.getInputValue("security"));
                httpListConfig.setRedirectPort((String)handlerCtx.getInputValue("RedirectPort"));
                httpListConfig.setAcceptorThreads((String)handlerCtx.getInputValue("Acceptor"));
                httpListConfig.setXpoweredBy((String)handlerCtx.getInputValue("PoweredBy"));
                httpListConfig.setBlockingEnabled((String)handlerCtx.getInputValue("Blocking"));
                AMXUtil.updateProperties((PropertiesAccess)httpListConfig, (Map)((Map)handlerCtx.getInputValue("newProps")));
                if (httpListenerName.equals(ADMIN_LISTENER)) {
                    if (Boolean.valueOf(httpListConfig.getSecurityEnabled()).booleanValue()) {
                        if (httpListConfig.getPropertyConfigMap().get(PROXIED_PROTOCOLS) != null) {
                            ((PropertyConfig)httpListConfig.getPropertyConfigMap().get(PROXIED_PROTOCOLS)).setValue(PROXIED_PROTOCOLS_VALUE);
                        } else {
                            httpListConfig.createPropertyConfig(PROXIED_PROTOCOLS, PROXIED_PROTOCOLS_VALUE);
                        }
                    } else if (httpListConfig.getPropertyConfigMap().get(PROXIED_PROTOCOLS) != null) {
                        httpListConfig.removePropertyConfig(PROXIED_PROTOCOLS);
                    }
                }
                Map vservers = config.getHTTPServiceConfig().getVirtualServerConfigMap();
                VirtualServerConfig previousVS = (VirtualServerConfig)vservers.get(previousVSName);
                VirtualServerConfig newVS = (VirtualServerConfig)vservers.get(virtualServer);
                String hl = previousVS.getHTTPListeners();
                String[] hlArray = GuiUtil.stringToArray((String)hl, (String)",");
                String tmp = "";
                for (int i = 0; i < hlArray.length; ++i) {
                    if (hlArray[i].equals(httpListenerName)) continue;
                    tmp = tmp.equals("") ? hlArray[i] : tmp + "," + hlArray[i];
                }
                previousVS.setHTTPListeners(tmp);
                tmp = newVS.getHTTPListeners();
                if (GuiUtil.isEmpty((String)tmp)) {
                    newVS.setHTTPListeners(httpListenerName);
                } else {
                    tmp = newVS.getHTTPListeners() + "," + httpListenerName;
                    newVS.setHTTPListeners(tmp);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getDefaultVirtualServers(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXRoot.getInstance().getConfig(configName);
        Iterator iter = config.getHTTPServiceConfig().getVirtualServerConfigMap().keySet().iterator();
        ArrayList<String> options = new ArrayList<String>();
        options.add("");
        while (iter.hasNext()) {
            options.add((String)iter.next());
        }
        handlerCtx.setOutputValue("DefaultVirtualServers", options);
    }

    static {
        httpServiceSkipPropsList.add("accessLogBufferSize");
        httpServiceSkipPropsList.add("accessLogWriteInterval");
        httpServiceSkipPropsList.add("accessLoggingEnabled");
    }
}

