/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.JMXConnectorConfig;
import com.sun.appserv.management.config.NodeAgentConfig;
import com.sun.appserv.management.config.SSLConfig;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.faces.model.SelectItem;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.util.SunOptionUtil;

public class SSLHandlers {
    static String[] COMMON_CIPHERS = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    static String[] BIT_CIPHERS = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};

    public static void getSSLProperties(HandlerContext handlerCtx) {
        String oName = (String)handlerCtx.getInputValue("Name");
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        String selectedCiphers = null;
        String type = (String)handlerCtx.getInputValue("Type");
        JMXConnectorConfig sslContainerConfig = null;
        boolean ssl3Prop = false;
        boolean ssl2Prop = false;
        boolean tlsProp = false;
        boolean clientAuth = false;
        boolean isEdit = (Boolean)handlerCtx.getInputValue("Edit");
        Map sslProps = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("sslProps");
        if (isEdit) {
            sslProps = null;
            if (type.equals("jmx")) {
                JMXConnectorConfig jmxConfig;
                sslContainerConfig = jmxConfig = (JMXConnectorConfig)config.getAdminServiceConfig().getJMXConnectorConfigMap().get(oName);
            } else if (type.equals("iiop")) {
                IIOPListenerConfig iiopConfig = (IIOPListenerConfig)config.getIIOPServiceConfig().getIIOPListenerConfigMap().get(oName);
                sslContainerConfig = iiopConfig;
            } else if (type.equals("http")) {
                HTTPListenerConfig httpConfig = (HTTPListenerConfig)config.getHTTPServiceConfig().getHTTPListenerConfigMap().get(oName);
                sslContainerConfig = httpConfig;
            } else if (type.equals("nodeagent")) {
                JMXConnectorConfig jmxConfig;
                NodeAgentConfig agentConfig = (NodeAgentConfig)AMXRoot.getInstance().getDomainConfig().getNodeAgentsConfig().getNodeAgentConfigMap().get(oName);
                sslContainerConfig = jmxConfig = agentConfig.getJMXConnectorConfig();
            }
            SSLConfig sslConfig = sslContainerConfig.getSSLConfig();
            if (sslConfig != null) {
                clientAuth = Boolean.valueOf(sslConfig.getClientAuthEnabled());
                handlerCtx.setOutputValue("CertNickname", (Object)sslConfig.getCertNickname());
                ssl3Prop = Boolean.valueOf(sslConfig.getSSL3Enabled());
                ssl2Prop = Boolean.valueOf(sslConfig.getSSL2Enabled());
                tlsProp = Boolean.valueOf(sslConfig.getTLSEnabled());
                selectedCiphers = sslConfig.getSSL3TLSCiphers();
            }
        } else if (sslProps != null) {
            clientAuth = (Boolean)sslProps.get("clientAuth");
            ssl3Prop = (Boolean)sslProps.get("ssl3Prop");
            ssl2Prop = (Boolean)sslProps.get("ssl2Prop");
            tlsProp = (Boolean)sslProps.get("tlsProp");
            handlerCtx.setOutputValue("CertNickname", sslProps.get("certNickname"));
        }
        String[] supportedCiphers = SSLHandlers.getSupportedCipherSuites();
        Vector ciphers = SSLHandlers.getCiphersVector(supportedCiphers);
        SelectItem[] commonCiphers = SunOptionUtil.getOptions(SSLHandlers.getCommonCiphers(ciphers));
        SelectItem[] ephemeralCiphers = SunOptionUtil.getOptions(SSLHandlers.getEphemeralCiphers(ciphers));
        SelectItem[] otherCiphers = SunOptionUtil.getOptions(SSLHandlers.getOtherCiphers(ciphers));
        SelectItem[] eccCiphers = SunOptionUtil.getOptions(SSLHandlers.getEccCiphers(ciphers));
        handlerCtx.setOutputValue("ClientAuth", (Object)clientAuth);
        handlerCtx.setOutputValue("SSL3Prop", (Object)ssl3Prop);
        handlerCtx.setOutputValue("SSL2Prop", (Object)ssl2Prop);
        handlerCtx.setOutputValue("TLSProp", (Object)tlsProp);
        handlerCtx.setOutputValue("CommonCiphersList", (Object)commonCiphers);
        handlerCtx.setOutputValue("EphemeralCiphersList", (Object)ephemeralCiphers);
        handlerCtx.setOutputValue("OtherCiphersList", (Object)otherCiphers);
        handlerCtx.setOutputValue("EccCiphersList", (Object)eccCiphers);
        if (sslProps == null) {
            String[] ciphersArr = SSLHandlers.getSelectedCiphersList(selectedCiphers);
            Vector selValues = SSLHandlers.getCiphersVector(ciphersArr);
            handlerCtx.setOutputValue("SelectedCommon", (Object)SSLHandlers.getCommonCiphers(selValues));
            handlerCtx.setOutputValue("SelectedEph", (Object)SSLHandlers.getEphemeralCiphers(selValues));
            handlerCtx.setOutputValue("SelectedOther", (Object)SSLHandlers.getOtherCiphers(selValues));
            handlerCtx.setOutputValue("SelectedEcc", (Object)SSLHandlers.getEccCiphers(selValues));
        } else {
            handlerCtx.setOutputValue("SelectedCommon", sslProps.get("selectedCommon"));
            handlerCtx.setOutputValue("SelectedEph", sslProps.get("selectedEph"));
            handlerCtx.setOutputValue("SelectedOther", sslProps.get("selectedOther"));
            handlerCtx.setOutputValue("SelectedEcc", sslProps.get("selectedEcc"));
        }
    }

    public static void saveSSLProperties(HandlerContext handlerCtx) {
        try {
            AMXRoot amxRoot = AMXRoot.getInstance();
            String oName = (String)handlerCtx.getInputValue("Name");
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            ConfigConfig config = amxRoot.getConfig(configName);
            String certNickname = (String)handlerCtx.getInputValue("CertNickname");
            String type = (String)handlerCtx.getInputValue("Type");
            HTTPListenerConfig sslContainerConfig = null;
            boolean isEdit = (Boolean)handlerCtx.getInputValue("Edit");
            if (isEdit) {
                if (type.equals("http")) {
                    HTTPListenerConfig httpConfig;
                    sslContainerConfig = httpConfig = (HTTPListenerConfig)config.getHTTPServiceConfig().getHTTPListenerConfigMap().get(oName);
                }
                if (sslContainerConfig != null && sslContainerConfig.getSSLConfig() != null) {
                    sslContainerConfig.removeSSLConfig();
                }
            } else if (type.equals("http")) {
                Map props = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("httpProps");
                Map options = AMXUtil.convertToPropertiesOptionMap((Map)((Map)props.get("options")), null);
                int port = Integer.parseInt((String)props.get("port"));
                String vs = (String)props.get("virtualServer");
                String httpName = (String)props.get("httpName");
                String serverName = (String)props.get("serverName");
                if (GuiUtil.isEmpty((String)serverName)) {
                    serverName = "";
                }
                HTTPListenerConfig httpConfig = config.getHTTPServiceConfig().createHTTPListenerConfig(httpName, (String)props.get("address"), port, vs, serverName, options);
                httpConfig.setEnabled("" + GuiUtil.getBooleanValue((Map)props, (String)"enabled"));
                httpConfig.setSecurityEnabled("" + GuiUtil.getBooleanValue((Map)props, (String)"securityEnabled"));
                httpConfig.setXpoweredBy("" + GuiUtil.getBooleanValue((Map)props, (String)"xpowered-by"));
                httpConfig.setBlockingEnabled("" + GuiUtil.getBooleanValue((Map)props, (String)"blocking-enabled"));
                httpConfig.setRedirectPort((String)props.get("redirectPort"));
                httpConfig.setAcceptorThreads((String)props.get("acceptor-threads"));
                VirtualServerConfig vsConfig = (VirtualServerConfig)config.getHTTPServiceConfig().getVirtualServerConfigMap().get(vs);
                String listeners = vsConfig.getHTTPListeners();
                if (GuiUtil.isEmpty((String)listeners)) {
                    vsConfig.setHTTPListeners(httpName);
                } else {
                    vsConfig.setHTTPListeners(listeners + "," + httpName);
                }
                sslContainerConfig = httpConfig;
            }
            if (certNickname != null && !certNickname.equals("")) {
                SSLConfig sslConfig = sslContainerConfig.getSSLConfig();
                if (sslConfig == null) {
                    sslConfig = sslContainerConfig.createSSLConfig(certNickname, new HashMap());
                } else {
                    sslConfig.setCertNickname(certNickname);
                }
                sslConfig.setClientAuthEnabled("" + (Boolean)handlerCtx.getInputValue("ClientAuth"));
                Boolean ssl3Prop = (Boolean)handlerCtx.getInputValue("SSL3Prop");
                sslConfig.setSSL3Enabled(ssl3Prop.toString());
                if (!type.equals("iiop")) {
                    Boolean ssl2Prop = (Boolean)handlerCtx.getInputValue("SSL2Prop");
                    sslConfig.setSSL2Enabled(ssl2Prop.toString());
                }
                Boolean tlsProp = (Boolean)handlerCtx.getInputValue("TLSProp");
                sslConfig.setTLSEnabled(tlsProp.toString());
                if (ssl3Prop.booleanValue() || tlsProp.booleanValue()) {
                    String[] supportedCiphers = SSLHandlers.getSupportedCipherSuites();
                    Vector ciphersVector = SSLHandlers.getCiphersVector(supportedCiphers);
                    String[] selectedCiphers = SSLHandlers.getSelectedCiphersList(sslConfig.getSSL3TLSCiphers());
                    String[] selectedCommon = (String[])handlerCtx.getInputValue("SelectedCommon");
                    String[] selectedEph = (String[])handlerCtx.getInputValue("SelectedEph");
                    String[] selectedOther = (String[])handlerCtx.getInputValue("SelectedOther");
                    String[] selectedEcc = (String[])handlerCtx.getInputValue("SelectedEcc");
                    String ciphers = SSLHandlers.processSelectedCiphers(selectedCommon, "");
                    ciphers = SSLHandlers.processSelectedCiphers(selectedEph, ciphers);
                    ciphers = SSLHandlers.processSelectedCiphers(selectedOther, ciphers);
                    ciphers = SSLHandlers.processSelectedCiphers(selectedEcc, ciphers);
                    sslConfig.setSSL3TLSCiphers(ciphers);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void updateSSLProperties(HandlerContext handlerCtx) {
        HashMap<String, Object> sslPropsMap = new HashMap<String, Object>();
        sslPropsMap.put("certNickname", (String)handlerCtx.getInputValue("CertNickname"));
        sslPropsMap.put("clientAuth", (Boolean)handlerCtx.getInputValue("ClientAuth"));
        sslPropsMap.put("ssl3Prop", (Boolean)handlerCtx.getInputValue("SSL3Prop"));
        sslPropsMap.put("ssl2Prop", (Boolean)handlerCtx.getInputValue("SSL2Prop"));
        sslPropsMap.put("tlsProp", (Boolean)handlerCtx.getInputValue("TLSProp"));
        sslPropsMap.put("selectedCommon", (String[])handlerCtx.getInputValue("SelectedCommon"));
        sslPropsMap.put("selectedEph", (String[])handlerCtx.getInputValue("SelectedEph"));
        sslPropsMap.put("selectedOther", (String[])handlerCtx.getInputValue("SelectedOther"));
        sslPropsMap.put("selectedEcc", (String[])handlerCtx.getInputValue("SelectedEcc"));
        handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("sslProps", sslPropsMap);
    }

    private static String[] getSelectedCiphersList(String selectedCiphers) {
        Vector<String> selItems = new Vector<String>();
        if (selectedCiphers != null) {
            String[] sel = selectedCiphers.split(",");
            for (int i = 0; i < sel.length; ++i) {
                String cName = sel[i];
                if (!cName.startsWith("+")) continue;
                cName = cName.substring(1, cName.length());
                selItems.add(cName);
            }
        }
        return selItems.toArray(new String[selItems.size()]);
    }

    private static String processSelectedCiphers(String[] selectedCiphers, String ciphers) {
        if (selectedCiphers != null) {
            for (int i = 0; i < selectedCiphers.length; ++i) {
                if (!ciphers.equals("")) {
                    ciphers = ciphers + ",";
                }
                ciphers = ciphers + "+" + selectedCiphers[i];
            }
        }
        return ciphers;
    }

    private static String processDeletedCiphers(String[] oldCiphers, String ciphers) {
        if (oldCiphers != null) {
            for (int i = 0; i < oldCiphers.length; ++i) {
                String cipVal = oldCiphers[i];
                if (ciphers.indexOf(cipVal) == -1) continue;
                if (!ciphers.equals("")) {
                    ciphers = ciphers + ",";
                }
                ciphers = ciphers + "-" + cipVal;
            }
        }
        return ciphers;
    }

    private static Vector getCiphersVector(String[] allCiphers) {
        Vector<String> ciphers = new Vector<String>();
        for (int i = 0; i < allCiphers.length; ++i) {
            ciphers.add(allCiphers[i]);
        }
        return ciphers;
    }

    private static String[] getCommonCiphers(Vector ciphers) {
        Vector commonCiphers = SSLHandlers.filterCiphers(ciphers, COMMON_CIPHERS);
        String[] ciphersList = commonCiphers.toArray(new String[commonCiphers.size()]);
        return ciphersList;
    }

    private static String[] getEccCiphers(Vector ciphers) {
        Vector eccCiphers = SSLHandlers.breakUpCiphers(new Vector(), ciphers, "ECDH");
        eccCiphers = SSLHandlers.breakUpCiphers(eccCiphers, ciphers, "ECDHE");
        String[] ciphersList = eccCiphers.toArray(new String[eccCiphers.size()]);
        return ciphersList;
    }

    private static String[] getEphemeralCiphers(Vector ciphers) {
        Vector ephmCiphers = SSLHandlers.breakUpCiphers(new Vector(), ciphers, "DHE_RSA");
        ephmCiphers = SSLHandlers.breakUpCiphers(ephmCiphers, ciphers, "DHE_DSS");
        String[] ciphersList = ephmCiphers.toArray(new String[ephmCiphers.size()]);
        return ciphersList;
    }

    private static String[] getOtherCiphers(Vector ciphers) {
        Vector bitCiphers = SSLHandlers.filterCiphers(ciphers, BIT_CIPHERS);
        String[] ciphersList = bitCiphers.toArray(new String[bitCiphers.size()]);
        return ciphersList;
    }

    private static Vector filterCiphers(Vector ciphers, String[] filterList) {
        Vector listCiphers = new Vector();
        for (int i = 0; i < ciphers.size(); ++i) {
            String cipherName = ciphers.get(i).toString();
            if (!Arrays.asList(filterList).contains(cipherName)) continue;
            listCiphers.add(ciphers.get(i));
        }
        return listCiphers;
    }

    private static Vector breakUpCiphers(Vector cipherSubset, Vector allCiphers, String type) {
        for (int i = 0; i < allCiphers.size(); ++i) {
            String cipherName = allCiphers.get(i).toString();
            if (cipherName.indexOf(type) == -1 || Arrays.asList(BIT_CIPHERS).contains(cipherName)) continue;
            cipherSubset.add(cipherName);
        }
        return cipherSubset;
    }

    private static String[] getSupportedCipherSuites() {
        try {
            SSLUtils sslUtils = (SSLUtils)GuiUtil.getHabitat().getComponent(SSLUtils.class);
            return sslUtils.getSupportedCipherSuites();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new String[0];
        }
    }
}

