/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.AdminObjectResourceConfig;
import com.sun.appserv.management.config.BackendPrincipalConfig;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ConnectorConnectionPoolConfig;
import com.sun.appserv.management.config.ConnectorResourceConfig;
import com.sun.appserv.management.config.CustomResourceConfig;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.JDBCResourceConfig;
import com.sun.appserv.management.config.JNDIResourceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ResourceConfig;
import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.config.ResourcesConfig;
import com.sun.appserv.management.config.SecurityMapConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.model.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorsHandlers {
    private static final Set<String> RESOURCE_TYPES = GSetUtil.newUnmodifiableStringSet((String[])new String[]{"X-JDBCResourceConfig", "X-MailResourceConfig", "X-CustomResourceConfig", "X-JNDIResourceConfig", "X-ConnectorResourceConfig", "X-AdminObjectResourceConfig"});
    private static Map<String, String> editMap = new HashMap<String, String>();
    private static Map<String, String> typeMap = new HashMap<String, String>();

    public static void getConnectorResourceInfo(HandlerContext handlerCtx) {
        if (!((Boolean)handlerCtx.getInputValue("edit")).booleanValue()) {
            handlerCtx.setOutputValue("enabled", (Object)Boolean.TRUE);
            return;
        }
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        ConnectorResourceConfig resource = (ConnectorResourceConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorResourceConfigMap().get(jndiName);
        if (resource == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchConnectorResource"));
            return;
        }
        handlerCtx.setOutputValue("poolName", (Object)resource.getPoolName());
        handlerCtx.setOutputValue("description", (Object)resource.getDescription());
        if (AMXRoot.getInstance().isEE()) {
            handlerCtx.setOutputValue("enabledString", (Object)TargetUtil.getEnabledStatus((Enabled)resource, (boolean)false));
        } else {
            handlerCtx.setOutputValue("enabled", (Object)TargetUtil.isResourceEnabled((Enabled)resource, (String)"server"));
        }
    }

    public static void saveConnectorResource(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        String poolName = (String)handlerCtx.getInputValue("poolName");
        ConnectorResourceConfig resource = null;
        try {
            if (!((Boolean)handlerCtx.getInputValue("edit")).booleanValue()) {
                resource = AMXRoot.getInstance().getResourcesConfig().createConnectorResourceConfig(jndiName, poolName, null);
                if (AMXRoot.getInstance().isEE()) {
                    if (TargetUtil.getResourceRef((String)jndiName, (String)"server") != null) {
                        TargetUtil.removeResourceRef((String)jndiName, (String)"server");
                    }
                } else {
                    Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                    TargetUtil.setResourceEnabled((Enabled)resource, (String)"server", (boolean)enabled);
                }
            } else {
                GuiUtil.prepareSuccessful((HandlerContext)handlerCtx);
                resource = (ConnectorResourceConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorResourceConfigMap().get(jndiName);
                if (resource == null) {
                    GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoConnectResource"));
                }
                resource.setPoolName(poolName);
                if (!AMXRoot.getInstance().isEE()) {
                    Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                    TargetUtil.setResourceEnabled((Enabled)resource, (String)"server", (boolean)enabled);
                }
            }
            resource.setDescription((String)handlerCtx.getInputValue("description"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getConnectorConnectionPools(HandlerContext handlerCtx) {
        Set keys = AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().keySet();
        handlerCtx.setOutputValue("connectorConnectionPools", new ArrayList(keys));
    }

    public static void getConnectorConnectionPoolMaps(HandlerContext handlerCtx) {
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        try {
            Iterator iter = AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().values().iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    ConnectorConnectionPoolConfig res = (ConnectorConnectionPoolConfig)iter.next();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    oneRow.put("name", res.getName());
                    oneRow.put("selected", hasOrig ? GuiUtil.isSelected((String)res.getName(), (List)selectedList) : false);
                    oneRow.put("resInfo", res.getResourceAdapterName());
                    oneRow.put("extraInfo", res.getConnectionDefinitionName());
                    oneRow.put("description", GuiUtil.checkEmpty((String)res.getDescription()));
                    result.add(oneRow);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void getConnectorConnectionPoolInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        ConnectorConnectionPoolConfig pool = (ConnectorConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchConnectorConnectionPool"));
            return;
        }
        handlerCtx.setOutputValue("resourceAdapterName", (Object)pool.getResourceAdapterName());
        handlerCtx.setOutputValue("connectionDefinitionName", (Object)pool.getConnectionDefinitionName());
        handlerCtx.setOutputValue("description", (Object)pool.getDescription());
        handlerCtx.setOutputValue("steadyPoolSize", (Object)pool.getSteadyPoolSize());
        handlerCtx.setOutputValue("maxPoolSize", (Object)pool.getMaxPoolSize());
        handlerCtx.setOutputValue("poolResizeQuantity", (Object)pool.getPoolResizeQuantity());
        handlerCtx.setOutputValue("idleTimeoutInSeconds", (Object)pool.getIdleTimeoutInSeconds());
        handlerCtx.setOutputValue("maxWaitTimeInMillis", (Object)pool.getMaxWaitTimeInMillis());
        handlerCtx.setOutputValue("isConnectionValidationRequired", (Object)pool.getConnectionValidationRequired());
        handlerCtx.setOutputValue("failAllConnections", (Object)pool.getFailAllConnections());
        handlerCtx.setOutputValue("transactionSupport", (Object)pool.getTransactionSupport());
    }

    public static void getConnectorConnectionPoolProperty(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        ConnectorConnectionPoolConfig pool = (ConnectorConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchConnectorConnectionPool"));
            return;
        }
        handlerCtx.setOutputValue("properties", (Object)pool.getPropertyConfigMap());
    }

    public static void saveConnectorConnectionPool(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            ConnectorConnectionPoolConfig pool = (ConnectorConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().get(jndiName);
            if (pool == null) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchConnectorConnectionPool"));
                return;
            }
            Boolean jmsFactory = (Boolean)handlerCtx.getInputValue("jmsFactory");
            if (jmsFactory == null || !jmsFactory.booleanValue()) {
                pool.setDescription((String)handlerCtx.getInputValue("description"));
            }
            pool.setMaxPoolSize((String)handlerCtx.getInputValue("maxPoolSize"));
            pool.setSteadyPoolSize((String)handlerCtx.getInputValue("steadyPoolSize"));
            pool.setPoolResizeQuantity((String)handlerCtx.getInputValue("poolResizeQuantity"));
            pool.setIdleTimeoutInSeconds((String)handlerCtx.getInputValue("idleTimeoutInSeconds"));
            pool.setMaxWaitTimeInMillis((String)handlerCtx.getInputValue("maxWaitTimeInMillis"));
            pool.setConnectionValidationRequired((String)handlerCtx.getInputValue("isConnectionValidationRequired"));
            pool.setTransactionSupport((String)handlerCtx.getInputValue("transactionSupport"));
            pool.setFailAllConnections((String)handlerCtx.getInputValue("failAllConnections"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveConnectorConnectionPoolProperty(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            ConnectorConnectionPoolConfig pool = (ConnectorConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().get(jndiName);
            if (pool == null) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchConnectorConnectionPool"));
                return;
            }
            AMXRoot.getInstance().editProperties(handlerCtx, (PropertiesAccess)pool);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getConnectorConnectionPoolDefaultInfo(HandlerContext handlerCtx) {
        Map defaultMap = AMXRoot.getInstance().getResourcesConfig().getDefaultValues("X-ConnectorConnectionPoolConfig", true);
        handlerCtx.setOutputValue("steadyPoolSize", defaultMap.get("SteadyPoolSize"));
        handlerCtx.setOutputValue("maxPoolSize", defaultMap.get("MaxPoolSize"));
        handlerCtx.setOutputValue("poolResizeQuantity", defaultMap.get("PoolResizeQuantity"));
        handlerCtx.setOutputValue("idleTimeoutInSeconds", defaultMap.get("IdleTimeoutInSeconds"));
        handlerCtx.setOutputValue("maxWaitTimeInMillis", defaultMap.get("MaxWaitTimeInMillis"));
        handlerCtx.setOutputValue("isConnectionValidationRequired", defaultMap.get("IsConnectionValidationRequired"));
        handlerCtx.setOutputValue("failAllConnections", defaultMap.get("FailAllConnections"));
        handlerCtx.setOutputValue("transactionSupport", defaultMap.get("TransactionSupport"));
    }

    public static void getConnectorPoolAdvanceInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        ConnectorConnectionPoolConfig pool = (ConnectorConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.noSuchConnectorConnectionPool"));
            return;
        }
        HashMap<String, Object> advance = new HashMap<String, Object>();
        advance.put("validateAtMostOncePeriodInSeconds", pool.getValidateAtMostOncePeriodInSeconds());
        advance.put("connectionLeakTimeoutInSeconds", pool.getConnectionLeakTimeoutInSeconds());
        advance.put("connectionLeakReclaim", ConnectorsHandlers.StringToBoolean(pool.getConnectionLeakReclaim()));
        advance.put("connectionCreationRetryAttempts", pool.getConnectionCreationRetryAttempts());
        advance.put("connectionCreationRetryIntervalInSeconds", pool.getConnectionCreationRetryIntervalInSeconds());
        advance.put("lazyConnectionEnlistment", ConnectorsHandlers.StringToBoolean(pool.getLazyConnectionEnlistment()));
        advance.put("lazyConnectionAssociation", ConnectorsHandlers.StringToBoolean(pool.getLazyConnectionAssociation()));
        advance.put("associateWithThread", ConnectorsHandlers.StringToBoolean(pool.getAssociateWithThread()));
        advance.put("matchConnections", ConnectorsHandlers.StringToBoolean(pool.getMatchConnections()));
        advance.put("maxConnectionUsageCount", pool.getMaxConnectionUsageCount());
        handlerCtx.setOutputValue("advance", advance);
    }

    public static void getConnectorPoolAdvanceDefaultInfo(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        ConnectorConnectionPoolConfig pool = (ConnectorConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.noSuchConnectorConnectionPool"));
            return;
        }
        HashMap advance = new HashMap();
        HashMap defaultMap = new HashMap();
        advance.put("validateAtMostOncePeriodInSeconds", defaultMap.get("validate-atmost-once-period-in-seconds"));
        advance.put("connectionLeakTimeoutInSeconds", defaultMap.get("connection-leak-timeout-in-seconds"));
        advance.put("connectionLeakReclaim", ConnectorsHandlers.StringToBoolean(defaultMap.get("connection-leak-reclaim")));
        advance.put("connectionCreationRetryAttempts", defaultMap.get("connection-creation-retry-attempts"));
        advance.put("connectionCreationRetryIntervalInSeconds", defaultMap.get("connection-creation-retry-interval-in-seconds"));
        advance.put("lazyConnectionEnlistment", ConnectorsHandlers.StringToBoolean(defaultMap.get("lazy-connection-enlistment")));
        advance.put("lazyConnectionAssociation", ConnectorsHandlers.StringToBoolean(defaultMap.get("lazy-connection-association")));
        advance.put("associateWithThread", ConnectorsHandlers.StringToBoolean(defaultMap.get("associate-with-thread")));
        advance.put("matchConnections", ConnectorsHandlers.StringToBoolean(defaultMap.get("match-connections")));
        advance.put("maxConnectionUsageCount", defaultMap.get("max-connection-usage-count"));
        handlerCtx.setOutputValue("advance", advance);
    }

    public static void saveConnectorPoolAdvanceInfo(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            Map map = (Map)handlerCtx.getInputValue("advance");
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static String BooleanToString(Object test) {
        if (test == null) {
            return Boolean.FALSE.toString();
        }
        return test.toString();
    }

    private static Boolean StringToBoolean(Object test) {
        if (test == null) {
            return false;
        }
        if (test instanceof String) {
            return Boolean.valueOf((String)test);
        }
        if (test instanceof Boolean) {
            return (Boolean)test;
        }
        return false;
    }

    public static void getConnectorConnectionPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        Boolean fromStep1 = (Boolean)handlerCtx.getInputValue("fromStep1");
        if (fromStep2 != null && fromStep2.booleanValue()) {
            Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
            String resAdapter = (String)extra.get("resAdapter");
            List defs = ConnectorsHandlers.getConnectionDefinitions(resAdapter);
            handlerCtx.setOutputValue("connectionDefinitions", (Object)defs);
        } else if (fromStep1 != null && fromStep1.booleanValue()) {
            String resAdapter = (String)handlerCtx.getInputValue("resAdapter");
            String poolName = (String)handlerCtx.getInputValue("poolName");
            if (GuiUtil.isEmpty((String)resAdapter)) {
                handlerCtx.setOutputValue("connectionDefinitions", new ArrayList());
            } else {
                Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
                extra.put("resAdapter", resAdapter);
                extra.put("name", poolName);
                List defs = ConnectorsHandlers.getConnectionDefinitions(resAdapter);
                handlerCtx.setOutputValue("connectionDefinitions", (Object)defs);
            }
        } else {
            HashMap extra = new HashMap();
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolExtra", extra);
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", extra);
        }
    }

    public static void updateConnectorConnectionPoolWizard(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resAdapter = (String)extra.get("resAdapter");
        String definition = (String)extra.get("connectionDefinition");
        String previousDefinition = (String)extra.get("previousDefinition");
        String previousResAdapter = (String)extra.get("previousResAdapter");
        if (!definition.equals(previousDefinition) || !resAdapter.equals(previousResAdapter)) {
            if (!GuiUtil.isEmpty((String)definition) && !GuiUtil.isEmpty((String)resAdapter)) {
                Properties props = ConnectorsHandlers.getConnectorConnectionPoolProps("getMCFConfigProps", resAdapter, "connection-definition-name", definition);
                handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", props);
            }
            extra.put("previousDefinition", definition);
            extra.put("previousResAdapter", resAdapter);
        }
    }

    public static void createConnectorConnectionPool(HandlerContext handlerCtx) {
        try {
            Map pool = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPool");
            Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
            Map propsMap = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolProperties");
            String name = (String)extra.get("name");
            String resAdapter = (String)extra.get("resAdapter");
            String connectionDef = (String)extra.get("connectionDefinition");
            Map allOptions = new HashMap(pool);
            allOptions = AMXUtil.convertToPropertiesOptionMap((Map)propsMap, allOptions);
            ConnectorConnectionPoolConfig newPool = AMXRoot.getInstance().getResourcesConfig().createConnectorConnectionPoolConfig(name, resAdapter, connectionDef, allOptions);
            newPool.setDescription((String)extra.get("Description"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static List getConnectionDefinitions(String resAdapter) {
        ArrayList defs = new ArrayList();
        if (GuiUtil.isEmpty((String)resAdapter)) {
            return defs;
        }
        return defs;
    }

    public static void getConnectorSecurityMaps(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        ConnectorConnectionPoolConfig pool = (ConnectorConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().get(jndiName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchConnectorConnectionPool"));
            return;
        }
        Map securityMaps = pool.getSecurityMapConfigMap();
        ArrayList result = new ArrayList();
        for (String securityMapName : securityMaps.keySet()) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("name", securityMapName);
            oneRow.put("editLink", "/resourceNode/connectorSecurityMapEdit.jsf?poolName=" + jndiName + "&securityMapName=" + securityMapName);
            oneRow.put("selected", false);
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void deleteConnectorSecurityMaps(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
    }

    public static void getConnectorSecurityMapInfo(HandlerContext handlerCtx) {
        String poolName = (String)handlerCtx.getInputValue("poolName");
        ConnectorConnectionPoolConfig pool = (ConnectorConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().get(poolName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchConnectorConnectionPool"));
            return;
        }
        String securityMapName = (String)handlerCtx.getInputValue("securityMapName");
        SecurityMapConfig securityMap = (SecurityMapConfig)pool.getSecurityMapConfigMap().get(securityMapName);
        String[] groups = securityMap.getUserGroupNames();
        if (groups != null && groups.length > 0) {
            String userGroups = groups[0];
            for (int i = 1; i < groups.length; ++i) {
                userGroups = userGroups.concat("," + groups[i]);
            }
            handlerCtx.setOutputValue("userGroups", (Object)userGroups);
            handlerCtx.setOutputValue("hasUserGroups", (Object)true);
        } else {
            handlerCtx.setOutputValue("hasUserGroups", (Object)false);
            handlerCtx.setOutputValue("userGroups", (Object)"");
        }
        String[] principalNames = securityMap.getPrincipalNames();
        if (principalNames != null && principalNames.length > 0) {
            String principals = principalNames[0];
            for (int i = 1; i < principalNames.length; ++i) {
                principals = principals.concat("," + principalNames[i]);
            }
            handlerCtx.setOutputValue("principals", (Object)principals);
        } else {
            handlerCtx.setOutputValue("hasUserGroups", (Object)true);
            handlerCtx.setOutputValue("principals", (Object)"");
        }
        BackendPrincipalConfig bpc = securityMap.getBackendPrincipalConfig();
        if (bpc != null) {
            handlerCtx.setOutputValue("userName", (Object)bpc.getUserName());
            handlerCtx.setOutputValue("password", (Object)bpc.getPassword());
        }
    }

    public static void saveConnectorSecurityMap(HandlerContext handlerCtx) {
        String poolName = (String)handlerCtx.getInputValue("poolName");
        ConnectorConnectionPoolConfig pool = (ConnectorConnectionPoolConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorConnectionPoolConfigMap().get(poolName);
        if (pool == null) {
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchConnectorConnectionPool"));
            return;
        }
        String securityMapName = (String)handlerCtx.getInputValue("securityMapName");
        String userName = (String)handlerCtx.getInputValue("userName");
        String password = (String)handlerCtx.getInputValue("password");
        String option = (String)handlerCtx.getInputValue("usersOption");
        String userGroups = (String)handlerCtx.getInputValue("userGroups");
        String principals = (String)handlerCtx.getInputValue("principals");
        String value = null;
        String[] str = null;
        boolean usePrincipals = false;
        if (option.equals("users")) {
            value = userGroups;
            usePrincipals = false;
        } else {
            value = principals;
            usePrincipals = true;
        }
        str = value != null && value.indexOf(",") != -1 ? GuiUtil.stringToArray((String)value, (String)",") : new String[]{value};
        try {
            BackendPrincipalConfig bpc;
            int i;
            String[] oldPrincipals;
            if (!((Boolean)handlerCtx.getInputValue("edit")).booleanValue()) {
                pool.createSecurityMapConfig(securityMapName, userName, password, (String[])(usePrincipals ? str : null), usePrincipals ? null : str);
                return;
            }
            SecurityMapConfig securityMap = (SecurityMapConfig)pool.getSecurityMapConfigMap().get(securityMapName);
            String[] oldGroups = securityMap.getUserGroupNames();
            if (oldGroups != null && oldGroups.length > 0) {
                for (int i2 = 0; i2 < oldGroups.length; ++i2) {
                    securityMap.removeUserGroup(oldGroups[i2]);
                }
            }
            if ((oldPrincipals = securityMap.getPrincipalNames()) != null && oldPrincipals.length > 0) {
                for (i = 0; i < oldPrincipals.length; ++i) {
                    securityMap.removePrincipal(oldPrincipals[i]);
                }
            }
            if (usePrincipals) {
                for (i = 0; i < str.length; ++i) {
                    securityMap.createPrincipal(str[i]);
                }
            } else {
                for (i = 0; i < str.length; ++i) {
                    securityMap.createUserGroup(str[i]);
                }
            }
            if ((bpc = securityMap.getBackendPrincipalConfig()) != null) {
                bpc.setUserName(userName);
                bpc.setPassword(password);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getAdminObjectResourceInfo(HandlerContext handlerCtx) {
        if (!((Boolean)handlerCtx.getInputValue("edit")).booleanValue()) {
            handlerCtx.setOutputValue("enabled", (Object)Boolean.TRUE);
            handlerCtx.setOutputValue("resAdapter", (Object)"");
            return;
        }
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
    }

    public static void saveAdminObjectResource(HandlerContext handlerCtx) {
        try {
            String jndiName = (String)handlerCtx.getInputValue("jndiName");
            AdminObjectResourceConfig resource = (AdminObjectResourceConfig)AMXRoot.getInstance().getResourcesConfig().getAdminObjectResourceConfigMap().get(jndiName);
            if (resource == null) {
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)GuiUtil.getMessage((String)"msg.NoSuchAdminObjectResource"));
                return;
            }
            resource.setResType((String)handlerCtx.getInputValue("resType"));
            resource.setResAdapter((String)handlerCtx.getInputValue("resAdapter"));
            resource.setDescription((String)handlerCtx.getInputValue("description"));
            if (!AMXRoot.getInstance().isEE()) {
                Boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
                TargetUtil.setResourceEnabled((Enabled)resource, (String)"server", (boolean)enabled);
            }
            AMXRoot.getInstance().editProperties(handlerCtx, (PropertiesAccess)resource);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getResourceAdapter(HandlerContext handlerCtx) {
        Object embeddedConnectors;
        HashSet keys = new HashSet();
        ArrayList<Object> total = new ArrayList<Object>(keys);
        total.add(0, "");
        Boolean forAdminObject = (Boolean)handlerCtx.getInputValue("forAdminObject");
        if (forAdminObject.booleanValue()) {
            total.add("jmsra");
        }
        if ((embeddedConnectors = null) != null) {
            for (int i = 0; i < (embeddedConnectors).length; ++i) {
                total.add(embeddedConnectors[i]);
            }
        }
        handlerCtx.setOutputValue("resAdapters", total);
    }

    public static void setConnectionDefDropdown(HandlerContext handlerCtx) {
        DropDown dp = (DropDown)handlerCtx.getInputValue("dropDownComponent");
        Map poolMap = (Map)handlerCtx.getInputValue("poolMap");
        String resAdapter = (String)poolMap.get("resAdapter");
        if (GuiUtil.isEmpty((String)resAdapter)) {
            return;
        }
        Object connectionDefinitions = null;
        if (connectionDefinitions == null) {
            return;
        }
        ArrayList<Option> list = new ArrayList<Option>();
        for (int i = 0; i < (connectionDefinitions).length; ++i) {
            list.add(new Option((Object)connectionDefinitions[i], (String)connectionDefinitions[i]));
        }
        dp.setItems(list);
    }

    public static void getAdminObjectWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        if (fromStep2 == null || !fromStep2.booleanValue() || sessionMap.get("wizardPool") == null) {
            HashMap<String, Boolean> pool = new HashMap<String, Boolean>();
            pool.put("enabled", Boolean.TRUE);
            sessionMap.put("wizardPool", pool);
            sessionMap.put("wizardPoolProperties", new HashMap());
        }
    }

    public static void updateAdminObjectWizard(HandlerContext handlerCtx) {
        Map pool = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPool");
        String resType = (String)pool.get("resType");
        String resAdapter = (String)pool.get("resAdapter");
        String previousResType = (String)pool.get("previousResType");
        String previousResAdapter = (String)pool.get("previousResAdapter");
        try {
            if (!resType.equals(previousResType) || !resAdapter.equals(previousResAdapter)) {
                if (!GuiUtil.isEmpty((String)resType) && !GuiUtil.isEmpty((String)resAdapter)) {
                    Properties props = ConnectorsHandlers.getConnectorConnectionPoolProps("getAdminObjectConfigProps", resAdapter, "admin-object-interface", resType);
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", props);
                }
                pool.put("previousResType", resType);
                pool.put("previousResAdapter", resAdapter);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void createAdminObjectResource(HandlerContext handlerCtx) {
        Map pool = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPool");
        String name = (String)pool.get("name");
        String resType = (String)pool.get("resType");
        String resAdapter = (String)pool.get("resAdapter");
        String description = (String)pool.get("description");
        Boolean enabled = (Boolean)pool.get("enabled");
        AttributeList list = new AttributeList();
        list.add(new Attribute("jndi-name", name));
        list.add(new Attribute("res-type", resType));
        list.add(new Attribute("res-adapter", resAdapter));
        list.add(new Attribute("description", description));
        Map propsMap = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolProperties");
        Properties properties = ConnectorsHandlers.convertMapToProperties(propsMap);
    }

    public static void getJmsConnectionFactories(HandlerContext handlerCtx) {
        Object factories = null;
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        if (factories != null && (factories).length > 0) {
            for (int i = 0; i < (factories).length; ++i) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                void one = factories[i];
                String name = one.getKeyProperty("jndi-name");
                oneRow.put("name", name);
                ConnectorResourceConfig resource = (ConnectorResourceConfig)AMXRoot.getInstance().getResourcesConfig().getConnectorResourceConfigMap().get(name);
                oneRow.put("enabled", TargetUtil.getEnabledStatus((Enabled)resource, (boolean)false));
                oneRow.put("description", GuiUtil.checkEmpty((String)resource.getDescription()));
                oneRow.put("pool", resource.getPoolName());
                oneRow.put("selected", hasOrig ? GuiUtil.isSelected((String)name, (List)selectedList) : false);
                result.add(oneRow);
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void createJmsConnectionFactory(HandlerContext handlerCtx) {
        AttributeList list = new AttributeList();
        list.add(ConnectorsHandlers.createAttr("jndi-name", "jndiName", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("res-type", "resType", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("description", "description", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("steady-pool-size", "steadyPoolSize", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("max-pool-size", "maxPoolSize", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("pool-resize-quantity", "poolResizeQuantity", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("idle-timeout-in-seconds", "idleTimeoutInSeconds", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("max-wait-time-in-millis", "maxWaitTimeInMillis", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("transaction-support", "transactionSupport", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("is-connection-validation-required", "isConnectionValidationRequired", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("fail-all-connections", "failAllConnections", handlerCtx));
        Properties props = ConnectorsHandlers.convertMapToProperties((Map)handlerCtx.getInputValue("properties"));
    }

    private static Properties convertMapToProperties(Map<String, String> inputMap) {
        Properties props = new Properties();
        for (String key : inputMap.keySet()) {
            if (GuiUtil.isEmpty((String)inputMap.get(key))) continue;
            props.put(key, inputMap.get(key));
        }
        return props;
    }

    public static void createJmsDestinationResource(HandlerContext handlerCtx) {
        AttributeList list = new AttributeList();
        list.add(ConnectorsHandlers.createAttr("jndi-name", "jndiName", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("res-type", "resType", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("res-adapter", "resAdapter", handlerCtx));
        list.add(ConnectorsHandlers.createAttr("description", "description", handlerCtx));
        list.add(new Attribute("enabled", "true"));
        Properties props = ConnectorsHandlers.convertMapToProperties((Map)handlerCtx.getInputValue("properties"));
        props.put("Name", handlerCtx.getInputValue("name"));
    }

    private static Attribute createAttr(String name, String key, HandlerContext handlerCtx) {
        Object value = handlerCtx.getInputValue(key);
        Attribute attr = new Attribute(name, value == null ? "" : value.toString());
        return attr;
    }

    public static void getJmsDestinationProperties(HandlerContext handlerCtx) {
        Properties props = ConnectorsHandlers.getConnectorConnectionPoolProps("getAdminObjectConfigProps", "jmsra", "admin-object-interface", "javax.jms.Queue");
        props.remove("Name");
        handlerCtx.setOutputValue("properties", (Object)props);
    }

    public static void getJmsConnectionFactoriesProperties(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("properties", (Object)ConnectorsHandlers.getConnectorConnectionPoolProps("getMCFConfigProps", "jmsra", "connection-definition-name", "javax.jms.TopicConnectionFactory"));
    }

    private static Properties getConnectorConnectionPoolProps(String getMethodName, String resourceAdapter, String attrName, String connectionDefinition) {
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("resource-adapter-name", resourceAdapter));
        attrList.add(new Attribute(attrName, connectionDefinition));
        Object[] params = new Object[]{attrList};
        String[] types = new String[]{"javax.management.AttributeList"};
        Properties properties = null;
        return properties == null ? new Properties() : properties;
    }

    public static void getResourcesTargetTableList(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        String resourceType = (String)handlerCtx.getInputValue("resourceType");
        List targetList = TargetUtil.getDeployedTargets((String)jndiName, (boolean)false);
        ArrayList result = new ArrayList();
        for (String target : targetList) {
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("selected", false);
            oneRow.put("targetName", target);
            Enabled resourceConfig = ConnectorsHandlers.getEnabledConfig(jndiName, resourceType);
            oneRow.put("enabled", Boolean.toString(TargetUtil.isResourceEnabled((Enabled)resourceConfig, (String)target)));
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void changeResourceStatus(HandlerContext handlerCtx) {
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        String resourceType = (String)handlerCtx.getInputValue("resourceType");
        List selectedRows = obj;
        try {
            for (int i = 0; i < selectedRows.size(); ++i) {
                String msg;
                Map oneRow = (Map)selectedRows.get(i);
                String resourceName = (String)oneRow.get("name");
                Enabled resourceConfig = ConnectorsHandlers.getEnabledConfig(resourceName, resourceType);
                if (resourceConfig != null) {
                    List targetList = TargetUtil.getDeployedTargets((AMX)((AMX)resourceConfig), (boolean)false);
                    for (String target : targetList) {
                        TargetUtil.setResourceEnabled((Enabled)resourceConfig, (String)target, (boolean)enabled);
                    }
                }
                if (AMXRoot.getInstance().isEE()) {
                    msg = GuiUtil.getMessage((String)(enabled ? "msg.enableResourceSuccessful" : "msg.disableResourceSuccessful"));
                    GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"success", (String)msg, null);
                    continue;
                }
                msg = GuiUtil.getMessage((String)(enabled ? "msg.enableResourceSuccessfulPE" : "msg.disableResourceSuccessfulPE"));
                GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"success", (String)msg, null);
            }
        }
        catch (Exception ex) {
            GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"error", (String)GuiUtil.getMessage((String)"msg.Error"), (String)ex.getMessage());
        }
    }

    public static void changeResourceTargetStatus(HandlerContext handlerCtx) {
        String resourceType = (String)handlerCtx.getInputValue("resourceType");
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        Enabled resConfig = ConnectorsHandlers.getEnabledConfig(jndiName, resourceType);
        if (resConfig == null) {
            return;
        }
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        List selectedRows = obj;
        try {
            for (int i = 0; i < selectedRows.size(); ++i) {
                Map oneRow = (Map)selectedRows.get(i);
                String target = (String)oneRow.get("targetName");
                TargetUtil.setResourceEnabled((Enabled)resConfig, (String)target, (boolean)enabled);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    private static Enabled getEnabledConfig(String resourceName, String resourceType) {
        Enabled config = null;
        ResourcesConfig resourcesConfig = AMXRoot.getInstance().getResourcesConfig();
        if ("jdbcResource".equals(resourceType)) {
            config = (Enabled)resourcesConfig.getJDBCResourceConfigMap().get(resourceName);
        } else if ("adminObjectResource".equals(resourceType)) {
            config = (Enabled)resourcesConfig.getAdminObjectResourceConfigMap().get(resourceName);
        } else if ("connectorResource".equals(resourceType)) {
            config = (Enabled)resourcesConfig.getConnectorResourceConfigMap().get(resourceName);
        } else if ("javaMailSession".equals(resourceType)) {
            config = (Enabled)resourcesConfig.getMailResourceConfigMap().get(resourceName);
        } else if ("customResource".equals(resourceType)) {
            config = (Enabled)resourcesConfig.getCustomResourceConfigMap().get(resourceName);
        } else if ("externalResource".equals(resourceType)) {
            config = (Enabled)resourcesConfig.getJNDIResourceConfigMap().get(resourceName);
        }
        return config;
    }

    public static void getResourcesList(HandlerContext handlerCtx) {
        String type = (String)handlerCtx.getInputValue("type");
        boolean isJdbc = false;
        boolean isConnector = false;
        boolean isCustomResource = false;
        boolean isExternal = false;
        boolean isAdminObject = false;
        Iterator<Object> iter = null;
        ResourcesConfig resourcesConfig = AMXRoot.getInstance().getResourcesConfig();
        if ("jdbcResource".equals(type)) {
            iter = resourcesConfig.getJDBCResourceConfigMap().values().iterator();
            isJdbc = true;
        } else if ("connectorResource".equals(type)) {
            iter = resourcesConfig.getConnectorResourceConfigMap().values().iterator();
            isConnector = true;
        } else if ("jndiCustomResource".equals(type)) {
            iter = resourcesConfig.getCustomResourceConfigMap().values().iterator();
            isCustomResource = true;
        } else if ("jndiExternalResource".equals(type)) {
            iter = resourcesConfig.getJNDIResourceConfigMap().values().iterator();
            isExternal = true;
        } else if ("adminObjectResource".equals(type)) {
            iter = resourcesConfig.getAdminObjectResourceConfigMap().values().iterator();
            isAdminObject = true;
        } else if ("jmsDestResource".equals(type)) {
            iter = resourcesConfig.getAdminObjectResourceConfigMap().values().iterator();
            ArrayList<AdminObjectResourceConfig> jms = new ArrayList<AdminObjectResourceConfig>();
            while (iter.hasNext()) {
                AdminObjectResourceConfig aor = (AdminObjectResourceConfig)iter.next();
                if (!"jmsra".equals(aor.getResAdapter())) continue;
                jms.add(aor);
            }
            iter = jms.iterator();
            isAdminObject = true;
        } else if ("javaMailSession".equals(type)) {
            iter = resourcesConfig.getMailResourceConfigMap().values().iterator();
        }
        List selectedList = null;
        boolean hasOrig = false;
        ArrayList result = new ArrayList();
        if (iter != null) {
            while (iter.hasNext()) {
                try {
                    ResourceConfig resConfig = (ResourceConfig)iter.next();
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    String name = resConfig.getJNDIName();
                    oneRow.put("name", name);
                    oneRow.put("enabled", TargetUtil.getEnabledStatus((Enabled)resConfig, (boolean)false));
                    oneRow.put("selected", hasOrig ? GuiUtil.isSelected((String)name, selectedList) : false);
                    oneRow.put("description", GuiUtil.checkEmpty((String)resConfig.getDescription()));
                    if (isJdbc) {
                        oneRow.put("pool", ((JDBCResourceConfig)resConfig).getPoolName());
                    } else if (isConnector) {
                        oneRow.put("pool", ((ConnectorResourceConfig)resConfig).getPoolName());
                    } else if (isCustomResource) {
                        oneRow.put("resType", ((CustomResourceConfig)resConfig).getResType());
                    } else if (isExternal) {
                        oneRow.put("resType", ((JNDIResourceConfig)resConfig).getResType());
                    } else if (isAdminObject) {
                        oneRow.put("resType", ((AdminObjectResourceConfig)resConfig).getResType());
                    }
                    result.add(oneRow);
                }
                catch (Exception ex) {
                    System.out.println("!!!! Catch exception when trying to iterate through resource list.  Resource Name ");
                    ex.printStackTrace();
                }
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void deleteResource(HandlerContext handlerCtx) {
        String target = "server";
        ResourcesConfig resourcesConfig = AMXRoot.getInstance().getResourcesConfig();
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        String resourceType = (String)handlerCtx.getInputValue("resourceType");
        Boolean isJmsConnectionFactory = (Boolean)handlerCtx.getInputValue("isJmsConnectionFactory");
        boolean isJms = isJmsConnectionFactory == null ? false : isJmsConnectionFactory;
        List selectedRows = obj;
        try {
            for (Map oneRow : selectedRows) {
                String resourceName = (String)oneRow.get("name");
                if ("jdbcResource".equals(resourceType)) {
                    resourcesConfig.removeJDBCResourceConfig(resourceName);
                    continue;
                }
                if (!"jdbcConnectionPool".equals(resourceType)) continue;
                Iterator iter = resourcesConfig.getJDBCResourceConfigMap().values().iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        JDBCResourceConfig jdbc = (JDBCResourceConfig)iter.next();
                        if (!jdbc.getPoolName().equals(resourceName)) continue;
                        resourcesConfig.removeJDBCResourceConfig(jdbc.getName());
                    }
                }
                resourcesConfig.removeJDBCConnectionPoolConfig(resourceName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"error", (String)GuiUtil.getMessage((String)"msg.Error"), (String)ex.getMessage());
        }
    }

    public static void getResourceRefListForTarget(HandlerContext handlerCtx) {
        String target = (String)handlerCtx.getInputValue("target");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        boolean isServer = (Boolean)handlerCtx.getInputValue("isServer");
        Collection<Object> refs = new ArrayList();
        ArrayList result = new ArrayList();
        if (isServer) {
            StandaloneServerConfig server = (StandaloneServerConfig)AMXRoot.getInstance().getServersConfig().getStandaloneServerConfigMap().get(target);
            refs = server.getResourceRefConfigMap().values();
        } else {
            ClusterConfig cluster = (ClusterConfig)AMXRoot.getInstance().getClustersConfig().getClusterConfigMap().get(target);
            refs = cluster.getResourceRefConfigMap().values();
        }
        for (ResourceRefConfig resourceRefConfig : refs) {
            String resName = resourceRefConfig.getName();
            String resType = ConnectorsHandlers.getResourceType(resName);
            if (!GuiUtil.isEmpty((String)filterValue) && !resType.equals(filterValue)) continue;
            HashMap<String, Object> oneRow = new HashMap<String, Object>();
            oneRow.put("enabled", resourceRefConfig.getEnabled());
            oneRow.put("selected", false);
            oneRow.put("name", resName);
            oneRow.put("link", "/resourceNode/" + editMap.get(resType) + "?name=" + resName);
            oneRow.put("resType", typeMap.get(resType));
            ObjectName nn = Util.getObjectName((AMX)resourceRefConfig);
            oneRow.put("objectName", nn.toString());
            result.add(oneRow);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void changeEnableForTarget(HandlerContext handlerCtx) {
        List selectedRows = (List)handlerCtx.getInputValue("selectedRows");
        String enabled = "" + handlerCtx.getInputValue("enabled");
        String target = (String)handlerCtx.getInputValue("target");
        List allResourceRefs = TargetUtil.getAllResourceRefConfig((String)target);
        for (Map oneRow : selectedRows) {
            String name = (String)oneRow.get("name");
            for (Map oneResourceMap : allResourceRefs) {
                ResourceRefConfig ref = (ResourceRefConfig)oneResourceMap.get(name);
                ref.setEnabled(enabled);
            }
        }
    }

    public static void getResourceFilterTypes(HandlerContext handlerCtx) {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(GuiUtil.getMessage((String)"common.showAll"));
        labels.add(GuiUtil.getMessage((String)"tree.jdbcResources"));
        labels.add(GuiUtil.getMessage((String)"tree.javaMailSessions"));
        labels.add(GuiUtil.getMessage((String)"tree.customResources"));
        labels.add(GuiUtil.getMessage((String)"tree.externalResources"));
        labels.add(GuiUtil.getMessage((String)"tree.connectorResources"));
        labels.add(GuiUtil.getMessage((String)"tree.adminObjectResources"));
        ArrayList<String> values = new ArrayList<String>();
        values.add("");
        values.add("X-JDBCResourceConfig");
        values.add("X-MailResourceConfig");
        values.add("X-CustomResourceConfig");
        values.add("X-JNDIResourceConfig");
        values.add("X-ConnectorResourceConfig");
        values.add("X-AdminObjectResourceConfig");
        handlerCtx.setOutputValue("values", values);
        handlerCtx.setOutputValue("labels", labels);
    }

    private static String getResourceType(String name) {
        Set resources = AMXRoot.getInstance().getQueryMgr().queryJ2EETypesSet(RESOURCE_TYPES);
        for (ResourceConfig res : resources) {
            if (!res.getName().equals(name)) continue;
            return res.getJ2EEType();
        }
        return "";
    }

    static {
        editMap.put("X-JDBCResourceConfig", "jdbcResourceEdit.jsf");
        editMap.put("X-MailResourceConfig", "javaMailSessionEdit.jsf");
        editMap.put("X-CustomResourceConfig", "customResourceEdit.jsf");
        editMap.put("X-JNDIResourceConfig", "externalResourceEdit.jsf");
        editMap.put("X-ConnectorResourceConfig", "connectorResourceEdit.jsf");
        editMap.put("X-AdminObjectResourceConfig", "adminObjectEdit.jsf");
        typeMap.put("X-JDBCResourceConfig", GuiUtil.getMessage((String)"tree.jdbcResources"));
        typeMap.put("X-MailResourceConfig", GuiUtil.getMessage((String)"tree.javaMailSessions"));
        typeMap.put("X-CustomResourceConfig", GuiUtil.getMessage((String)"tree.customResources"));
        typeMap.put("X-JNDIResourceConfig", GuiUtil.getMessage((String)"tree.externalResources"));
        typeMap.put("X-ConnectorResourceConfig", GuiUtil.getMessage((String)"tree.connectorResources"));
        typeMap.put("X-AdminObjectResourceConfig", GuiUtil.getMessage((String)"tree.adminObjectResources"));
    }
}

