/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.handlers;

import com.sun.appserv.management.config.ApplicationConfig;
import com.sun.appserv.management.ext.runtime.RuntimeMgr;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.model.UploadedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.DeployUtil;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.TargetUtil;
import org.glassfish.deployment.client.DFDeploymentProperties;
import org.glassfish.deployment.client.DFDeploymentStatus;
import org.glassfish.deployment.client.DFProgressObject;
import org.glassfish.deployment.client.DeploymentFacility;

public class DeploymentHandler {
    public static final String KEEP_SESSIONS = "keepSessions";

    public static void deploy(HandlerContext handlerCtx) {
        Properties deploymentProps = new Properties();
        String appName = (String)handlerCtx.getInputValue("appName");
        String origPath = (String)handlerCtx.getInputValue("origPath");
        String filePath = (String)handlerCtx.getInputValue("filePath");
        String ctxtRoot = (String)handlerCtx.getInputValue("ctxtRoot");
        String[] vs = (String[])handlerCtx.getInputValue("VS");
        String enabled = (String)handlerCtx.getInputValue("enabled");
        String libraries = (String)handlerCtx.getInputValue("libraries");
        String precompile = (String)handlerCtx.getInputValue("precompileJSP");
        String desc = (String)handlerCtx.getInputValue("description");
        String[] targets = (String[])handlerCtx.getInputValue("targets");
        if (targets == null || targets.length == 0 || !AMXRoot.getInstance().isEE()) {
            targets = null;
        }
        if (GuiUtil.isEmpty((String)origPath)) {
            String mesg = GuiUtil.getMessage((String)"msg.deploy.nullArchiveError");
            GuiUtil.handleError((HandlerContext)handlerCtx, (String)mesg);
            return;
        }
        deploymentProps.setProperty("name", appName != null ? appName : "");
        if (!GuiUtil.isEmpty((String)ctxtRoot)) {
            deploymentProps.setProperty("contextroot", ctxtRoot);
        }
        deploymentProps.setProperty("enabled", enabled != null ? enabled : "false");
        deploymentProps.setProperty("libraries", libraries != null ? libraries : "");
        deploymentProps.setProperty("description", desc != null ? desc : "");
        deploymentProps.setProperty("precompilejsp", precompile != null ? precompile : "false");
        if (vs != null && vs.length > 0 && !GuiUtil.isEmpty((String)vs[0])) {
            String vsTargets = GuiUtil.arrayToString((String[])vs, (String)",");
            deploymentProps.setProperty("virtualservers", vsTargets);
        }
        try {
            DeployUtil.deploy((String[])targets, (Properties)deploymentProps, (String)filePath, (HandlerContext)handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void uploadFileToTempDir(HandlerContext handlerCtx) {
        UploadedFile uploadedFile = (UploadedFile)handlerCtx.getInputValue("file");
        File tmpFile = null;
        String uploadTmpFile = "";
        if (uploadedFile != null) {
            int index;
            String name = uploadedFile.getOriginalName();
            int lastIndex = name.lastIndexOf("\\");
            if (lastIndex != -1) {
                name = name.substring(lastIndex + 1, name.length());
            }
            if ((index = name.indexOf(".")) <= 0) {
                String mesg = GuiUtil.getMessage((String)"msg.deploy.nullArchiveError");
                GuiUtil.handleError((HandlerContext)handlerCtx, (String)mesg);
                return;
            }
            String suffix = name.substring(index);
            String prefix = name.substring(0, index);
            handlerCtx.setOutputValue("origPath", (Object)prefix);
            try {
                if (prefix.length() <= 2) {
                    prefix = prefix + new Random().nextInt(100000);
                }
                tmpFile = File.createTempFile(prefix, suffix);
                uploadedFile.write(tmpFile);
                uploadTmpFile = tmpFile.getCanonicalPath();
            }
            catch (IOException ioex) {
                try {
                    uploadTmpFile = tmpFile.getAbsolutePath();
                }
                catch (Exception ex) {}
            }
            catch (Exception ex) {
                GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
            }
        }
        handlerCtx.setOutputValue("uploadedTempFile", (Object)uploadTmpFile);
    }

    public static void redeploy(HandlerContext handlerCtx) {
        try {
            String filePath = (String)handlerCtx.getInputValue("filePath");
            String origPath = (String)handlerCtx.getInputValue("origPath");
            String appName = (String)handlerCtx.getInputValue("appName");
            Boolean keepSessions = (Boolean)handlerCtx.getInputValue(KEEP_SESSIONS);
            DFDeploymentProperties deploymentProps = new DFDeploymentProperties();
            ApplicationConfig appConfig = AMXUtil.getApplicationConfigByName((String)appName);
            if (appConfig != null) {
                deploymentProps.setContextRoot(appConfig.getContextRoot());
            }
            deploymentProps.setForce(true);
            deploymentProps.setUpload(false);
            deploymentProps.setName(appName);
            Properties prop = new Properties();
            String ks = keepSessions == null ? "false" : keepSessions.toString();
            prop.setProperty(KEEP_SESSIONS, ks);
            deploymentProps.setProperties(prop);
            DeployUtil.invokeDeploymentFacility(null, (Properties)deploymentProps, (String)filePath, (HandlerContext)handlerCtx);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void undeploy(HandlerContext handlerCtx) {
        Object obj = handlerCtx.getInputValue("selectedRows");
        Properties dProps = new Properties();
        List selectedRows = (List)obj;
        DFProgressObject progressObject = null;
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        String[] targetNames = new String[]{"server"};
        for (int i = 0; i < selectedRows.size(); ++i) {
            Map oneRow = (Map)selectedRows.get(i);
            String appName = (String)oneRow.get("name");
            if (AMXRoot.getInstance().isEE()) {
                List refList = TargetUtil.getDeployedTargets((String)appName, (boolean)true);
                targetNames = refList.size() > 0 ? refList.toArray(new String[refList.size()]) : new String[]{"domain"};
            }
            progressObject = df.undeploy(df.createTargets(targetNames), appName, (Map)dProps);
            progressObject.waitFor();
            DFDeploymentStatus status = progressObject.getCompletedStatus();
            if (!DeployUtil.checkDeployStatus((DFDeploymentStatus)status, (HandlerContext)handlerCtx, (boolean)false)) continue;
            String mesg = GuiUtil.getMessage((String)"msg.deploySuccess", (Object[])new Object[]{appName, "undeployed"});
        }
    }

    public static void changeAppStatus(HandlerContext handlerCtx) {
        List obj = (List)handlerCtx.getInputValue("selectedRows");
        boolean enabled = (Boolean)handlerCtx.getInputValue("enabled");
        DeploymentFacility df = GuiUtil.getDeploymentFacility();
        String[] targetNames = new String[]{"server"};
        List selectedRows = obj;
        try {
            for (int i = 0; i < selectedRows.size(); ++i) {
                String msg;
                Map oneRow = (Map)selectedRows.get(i);
                String appName = (String)oneRow.get("name");
                if (enabled) {
                    df.enable(df.createTargets(targetNames), appName);
                } else {
                    df.disable(df.createTargets(targetNames), appName);
                }
                if (AMXRoot.getInstance().isEE()) {
                    msg = GuiUtil.getMessage((String)(enabled ? "msg.enableSuccessful" : "msg.disableSuccessful"));
                    GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"success", (String)msg, null);
                    continue;
                }
                msg = GuiUtil.getMessage((String)(enabled ? "msg.enableSuccessfulPE" : "msg.disableSuccessfulPE"));
                GuiUtil.prepareAlert((HandlerContext)handlerCtx, (String)"success", (String)msg, null);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getDescriptors(HandlerContext handlerCtx) {
        String appName = (String)handlerCtx.getInputValue("appName");
        ArrayList list = new ArrayList();
        RuntimeMgr runtimeMgr = AMXRoot.getInstance().getRuntimeMgr();
        Map descriptors = runtimeMgr.getDeploymentConfigurations(appName);
        try {
            for (String dd : descriptors.keySet()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", appName);
                map.put("moduleName", "");
                int index = dd.lastIndexOf(File.separator) + 1;
                map.put("descriptor", dd.substring(index));
                map.put("descriptorPath", dd);
                list.add(map);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
        handlerCtx.setOutputValue("descriptors", list);
    }
}

