/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.jdbc.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.V3AMX;

public class ConnectorsHandlers {
    public static final String STRING_ARRAY_KEY = "StringArrayKey";
    public static final String MAP_KEY = "MapKey";

    public static void getConnectorConnectionPoolWizard(HandlerContext handlerCtx) {
        Boolean fromStep2 = (Boolean)handlerCtx.getInputValue("fromStep2");
        Boolean fromStep1 = (Boolean)handlerCtx.getInputValue("fromStep1");
        if (fromStep2 != null && fromStep2.booleanValue()) {
            Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
            String resAdapter = (String)extra.get("ResourceAdapterName");
            List defs = ConnectorsHandlers.getConnectionDefinitions(resAdapter);
            handlerCtx.setOutputValue("connectionDefinitions", (Object)defs);
        } else if (fromStep1 != null && fromStep1.booleanValue()) {
            String resAdapter = (String)handlerCtx.getInputValue("resAdapter");
            String poolName = (String)handlerCtx.getInputValue("poolName");
            if (resAdapter == null || resAdapter.equals("")) {
                handlerCtx.setOutputValue("connectionDefinitions", new ArrayList());
            } else {
                Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
                extra.put("ResourceAdapterName", resAdapter);
                extra.put("Name", poolName);
                List defs = ConnectorsHandlers.getConnectionDefinitions(resAdapter);
                handlerCtx.setOutputValue("connectionDefinitions", (Object)defs);
            }
        } else {
            HashMap extra = new HashMap();
            Map attrMap = (Map)handlerCtx.getInputValue("attrMap");
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("valueMap", attrMap);
            handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolExtra", extra);
        }
    }

    public static void updateConnectorConnectionPoolWizard(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        String resAdapter = (String)extra.get("ResourceAdapterName");
        String definition = (String)extra.get("ConnectionDefinitionName");
        String previousDefinition = (String)extra.get("previousDefinition");
        String previousResAdapter = (String)extra.get("previousResAdapter");
        if (!definition.equals(previousDefinition) || !resAdapter.equals(previousResAdapter)) {
            ArrayList propsList = new ArrayList();
            if (!GuiUtil.isEmpty((String)definition) && !GuiUtil.isEmpty((String)resAdapter)) {
                Map result = V3AMX.getInstance().getConnectorRuntime().getMCFConfigProps(resAdapter, definition);
                Map props = (Map)result.get(MAP_KEY);
                if (props != null) {
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", GuiUtil.convertMapToListOfMap((Map)props));
                } else {
                    handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("wizardPoolProperties", propsList);
                }
            }
            extra.put("previousDefinition", definition);
            extra.put("previousResAdapter", resAdapter);
        }
    }

    public static void updateConnectorConnectionPoolWizardStep2(HandlerContext handlerCtx) {
        Map extra = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("wizardPoolExtra");
        Map attrs = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("valueMap");
        String resAdapter = (String)extra.get("ResourceAdapterName");
        String definition = (String)extra.get("ConnectionDefinitionName");
        String name = (String)extra.get("Name");
        attrs.put("Name", name);
        attrs.put("ConnectionDefinitionName", definition);
        attrs.put("ResourceAdapterName", resAdapter);
    }

    private static List getConnectionDefinitions(String resAdapter) {
        ArrayList defs = new ArrayList();
        if (resAdapter == null || resAdapter.equals("")) {
            return defs;
        }
        Map result = V3AMX.getInstance().getConnectorRuntime().getConnectionDefinitionNames(resAdapter);
        String[] names = (String[])result.get(STRING_ARRAY_KEY);
        if (names != null) {
            return Arrays.asList(names);
        }
        return defs;
    }
}

