
package org.glassfish.admingui.plugin;

import java.util.ArrayList;
import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.InjectionTarget;

@Service(name = "console-config", metadata = "target=org.glassfish.admingui.plugin.ConsoleConfig,<integration-point>=collection:org.glassfish.admingui.plugin.IntegrationPoint,@id=required,@id=datatype:java.lang.String,@id=leaf")
@InjectionTarget(ConsoleConfig.class)
public class ConsoleConfigInjector
    extends ConfigInjector<ConsoleConfig>
{


    public void inject(Dom dom, ConsoleConfig target) {
        element_setIntegrationPoints(dom, target);
        attribute_setId(dom, target);
    }

    public void injectAttribute(Dom dom, String name, ConsoleConfig target) {
        if ("id".equals(name)) {
            attribute_setId(dom, target);
        }
    }

    public void injectElement(Dom dom, String name, ConsoleConfig target) {
        if ("integration-point".equals(name)) {
            element_setIntegrationPoints(dom, target);
        }
    }

    public void element_setIntegrationPoints(Dom dom, ConsoleConfig target) {
        List<Dom> v1 = dom.nodeElements("integration-point");
        if (v1 == null) {
            return ;
        }
        List v2 = new ArrayList<org.glassfish.admingui.plugin.IntegrationPoint>(v1 .size());
        for (Dom v3 : v1) {
            v2 .add(((org.glassfish.admingui.plugin.IntegrationPoint) v3 .get()));
        }
        target.setIntegrationPoints(v2);
    }

    public void attribute_setId(Dom dom, ConsoleConfig target) {
        String v1 = dom.attribute("id");
        target.setId(v1);
    }

}
