
package org.glassfish.admingui.plugin;

import java.util.ArrayList;
import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.InjectionTarget;

@Service(name = "toc", metadata = "<tocitem>=collection:org.glassfish.admingui.plugin.TOCItem,target=org.glassfish.admingui.plugin.TOC,@version=required,@version=datatype:java.lang.String,@version=leaf")
@InjectionTarget(TOC.class)
public class TOCInjector
    extends ConfigInjector<TOC>
{


    public void inject(Dom dom, TOC target) {
        element_setTOCItems(dom, target);
        attribute_setVersion(dom, target);
    }

    public void injectAttribute(Dom dom, String name, TOC target) {
        if ("version".equals(name)) {
            attribute_setVersion(dom, target);
        }
    }

    public void injectElement(Dom dom, String name, TOC target) {
        if ("tocitem".equals(name)) {
            element_setTOCItems(dom, target);
        }
    }

    public void element_setTOCItems(Dom dom, TOC target) {
        List<Dom> v1 = dom.nodeElements("tocitem");
        if (v1 == null) {
            return ;
        }
        List v2 = new ArrayList<org.glassfish.admingui.plugin.TOCItem>(v1 .size());
        for (Dom v3 : v1) {
            v2 .add(((org.glassfish.admingui.plugin.TOCItem) v3 .get()));
        }
        target.setTOCItems(v2);
    }

    public void attribute_setVersion(Dom dom, TOC target) {
        String v1 = dom.attribute("version");
        target.setVersion(v1);
    }

}
