/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admingui.handlers;

import com.sun.appserv.management.config.AccessLogConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.PropertyConfig;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.admingui.common.util.AMXRoot;
import org.glassfish.admingui.common.util.AMXUtil;
import org.glassfish.admingui.common.util.GuiUtil;

public class HttpServiceHandlers {
    private static List httpServiceSkipPropsList = new ArrayList();

    public static void getAccessLogSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        AccessLogConfig al = config.getHTTPServiceConfig().getAccessLogConfig();
        String policy = "";
        String interval = "";
        String suffix = "";
        String format = "";
        String rotation = "true";
        if (al != null) {
            rotation = al.getRotationEnabled();
            policy = al.getRotationPolicy();
            interval = al.getRotationIntervalInMinutes();
            suffix = al.getRotationSuffix();
            format = al.getFormat();
        } else {
            Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-AccessLogConfig", true);
            policy = (String)defaultMap.get("RotationPolicy");
            interval = (String)defaultMap.get("RotationIntervalInMinutes");
            suffix = (String)defaultMap.get("RotationSuffix");
            format = (String)defaultMap.get("Format");
            rotation = (String)defaultMap.get("RotationEnabled");
        }
        handlerCtx.setOutputValue("Rotation", (Object)rotation);
        handlerCtx.setOutputValue("Policy", (Object)policy);
        handlerCtx.setOutputValue("Interval", (Object)interval);
        handlerCtx.setOutputValue("Suffix", (Object)suffix);
        handlerCtx.setOutputValue("Format", (Object)format);
    }

    public static void getAccessLogDefaultSettings(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        Map defaultMap = config.getHTTPServiceConfig().getDefaultValues("X-AccessLogConfig", true);
        String rotationKey = (String)defaultMap.get("RotationEnabled");
        boolean rotation = rotationKey == null ? false : Boolean.valueOf(rotationKey);
        handlerCtx.setOutputValue("Rotation", (Object)rotation);
        handlerCtx.setOutputValue("Policy", defaultMap.get("RotationPolicy"));
        handlerCtx.setOutputValue("Interval", defaultMap.get("RotationIntervalInMinutes"));
        handlerCtx.setOutputValue("Suffix", defaultMap.get("RotationSuffix"));
        handlerCtx.setOutputValue("Format", defaultMap.get("Format"));
    }

    public static void saveAccessLogSettings(HandlerContext handlerCtx) {
        try {
            ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
            AccessLogConfig al = config.getHTTPServiceConfig().getAccessLogConfig();
            if (al == null) {
                al = config.getHTTPServiceConfig().createAccessLogConfig(new HashMap());
            }
            al.setRotationEnabled((String)handlerCtx.getInputValue("Rotation"));
            al.setRotationPolicy((String)handlerCtx.getInputValue("Policy"));
            al.setRotationIntervalInMinutes((String)handlerCtx.getInputValue("Interval"));
            al.setRotationSuffix((String)handlerCtx.getInputValue("Suffix"));
            al.setFormat((String)handlerCtx.getInputValue("Format"));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void getHttpService(HandlerContext handlerCtx) {
        ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
        HTTPServiceConfig hConfig = config.getHTTPServiceConfig();
        try {
            handlerCtx.setOutputValue("Properties", (Object)AMXUtil.getNonSkipPropertiesMap((PropertiesAccess)hConfig, (List)httpServiceSkipPropsList));
            Map origProps = hConfig.getPropertyConfigMap();
            handlerCtx.setOutputValue("accessLogBufferSize", (Object)AMXUtil.getPropertyValue((PropertiesAccess)hConfig, (String)"accessLogBufferSize"));
            handlerCtx.setOutputValue("accessLogWriteInterval", (Object)AMXUtil.getPropertyValue((PropertiesAccess)hConfig, (String)"accessLogWriteInterval"));
            PropertyConfig pValue = (PropertyConfig)origProps.get("accessLoggingEnabled");
            String alog = pValue == null ? "" : pValue.getValue();
            Boolean accessLoggingEnabled = true;
            accessLoggingEnabled = GuiUtil.isEmpty((String)alog) ? Boolean.valueOf(false) : Boolean.valueOf(alog.equals("true"));
            handlerCtx.setOutputValue("accessLoggingEnabled", (Object)accessLoggingEnabled);
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    public static void saveHttpService(HandlerContext handlerCtx) {
        try {
            ConfigConfig config = AMXRoot.getInstance().getConfig((String)handlerCtx.getInputValue("ConfigName"));
            HTTPServiceConfig hConfig = config.getHTTPServiceConfig();
            Map newProps = (Map)handlerCtx.getInputValue("newProps");
            AMXUtil.updateProperties((PropertiesAccess)hConfig, (Map)newProps, (List)httpServiceSkipPropsList);
            AMXUtil.setPropertyValue((PropertiesAccess)hConfig, (String)"accessLogBufferSize", (String)((String)handlerCtx.getInputValue("accessLogBufferSize")));
            AMXUtil.setPropertyValue((PropertiesAccess)hConfig, (String)"accessLogWriteInterval", (String)((String)handlerCtx.getInputValue("accessLogWriteInterval")));
            AMXUtil.setPropertyValue((PropertiesAccess)hConfig, (String)"accessLoggingEnabled", (String)("" + handlerCtx.getInputValue("accessLoggingEnabled")));
        }
        catch (Exception ex) {
            GuiUtil.handleException((HandlerContext)handlerCtx, (Throwable)ex);
        }
    }

    static {
        httpServiceSkipPropsList.add("accessLogBufferSize");
        httpServiceSkipPropsList.add("accessLogWriteInterval");
        httpServiceSkipPropsList.add("accessLoggingEnabled");
    }
}

