/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataFilter;
import com.sun.data.provider.TableDataProvider;
import java.util.ArrayList;

public class BasicTableDataFilter
implements TableDataFilter {
    protected FilterCriteria[] filterCriteria;
    protected boolean matchAll = true;

    public void setFilterCriteria(FilterCriteria[] filterCriteria) {
        this.filterCriteria = filterCriteria;
    }

    public FilterCriteria[] getFilterCriteria() {
        return this.filterCriteria;
    }

    public void setMatchAllCriteria(boolean matchAll) {
        this.matchAll = matchAll;
    }

    public boolean isMatchAllCriteria() {
        return this.matchAll;
    }

    public RowKey[] filter(TableDataProvider provider, RowKey[] rows) throws DataProviderException {
        if (this.filterCriteria == null || this.filterCriteria.length == 0) {
            return rows;
        }
        ArrayList<RowKey> acceptRows = new ArrayList<RowKey>();
        for (int r = 0; rows != null && r < rows.length; ++r) {
            RowKey row = rows[r];
            int acceptCount = 0;
            boolean handled = false;
            for (int i = 0; i < this.filterCriteria.length; ++i) {
                boolean accept;
                boolean match = this.filterCriteria[i].match(provider, row);
                boolean bl = this.filterCriteria[i].isInclude() ? match : (accept = !match);
                if (!this.matchAll && accept) {
                    acceptRows.add(row);
                    handled = true;
                    break;
                }
                if (this.matchAll && !accept) {
                    handled = true;
                    break;
                }
                if (!accept) continue;
                ++acceptCount;
            }
            if (handled) continue;
            if (this.matchAll && this.filterCriteria.length == acceptCount) {
                acceptRows.add(row);
                continue;
            }
            if (this.matchAll || acceptCount <= 0) continue;
            acceptRows.add(row);
        }
        return acceptRows.toArray(new RowKey[acceptRows.size()]);
    }
}

