/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.glassfish.build.utils.MavenUtils;

public class AttachAllArtifactsMojo
extends AbstractMojo {
    private MavenProject project;
    private File pomFile;
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping artifact attachment");
            return;
        }
        File targetPom = MavenUtils.getPomInTarget(this.project.getBuild().getDirectory());
        if (targetPom != null) {
            this.pomFile = targetPom;
        }
        if (this.pomFile == null || !this.pomFile.exists()) {
            this.pomFile = this.project.getFile();
        }
        if (!this.pomFile.exists()) {
            this.getLog().info((CharSequence)"Skipping as there is no model to read from");
            return;
        }
        Model model = MavenUtils.readModel(this.pomFile);
        Artifact artifact = MavenUtils.createArtifact(this.project.getBuild().getDirectory(), model);
        if (artifact == null) {
            this.getLog().info((CharSequence)"Skipping as there is no file found for this artifact");
            return;
        }
        List<Artifact> attachedArtifacts = MavenUtils.createAttachedArtifacts(this.project.getBuild().getDirectory(), artifact, model);
        if (!"pom".equals(model.getPackaging())) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        this.project.setArtifact(artifact);
        this.project.setFile(this.pomFile);
        Iterator<Artifact> i = attachedArtifacts.iterator();
        while (i.hasNext()) {
            this.project.addAttachedArtifact(i.next());
        }
    }
}

