/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.PomHelper;
import org.glassfish.build.utils.MavenUtils;

public class GeneratePomMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDirectory;
    protected File pomFile;
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected Parent parent;
    protected String description;
    protected String name;
    protected Scm scm;
    protected IssueManagement issueManagement;
    protected List<MailingList> mailingLists;
    protected List<Developer> devevelopers;
    protected List<License> licenses;
    protected Organization organization;
    protected String excludeDependencies;
    protected String excludeDependencyScopes;
    protected List<Dependency> dependencies;
    protected Boolean skip;
    protected Boolean attach;

    private static boolean validateString(String str) {
        return str != null && !str.isEmpty();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String input;
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"skipping...");
            return;
        }
        try {
            input = PomHelper.readXmlFile((File)this.pomFile).toString();
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        Model model = MavenUtils.readModel(input);
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        model.setDevelopers(this.devevelopers);
        if (this.parent != null && GeneratePomMojo.validateString(this.parent.getGroupId()) && GeneratePomMojo.validateString(this.parent.getArtifactId()) && GeneratePomMojo.validateString(this.parent.getVersion())) {
            model.setParent(this.parent);
        } else {
            model.setParent(null);
        }
        model.setName(this.name);
        model.setDescription(this.description);
        model.setScm(this.scm);
        model.setIssueManagement(this.issueManagement);
        model.setMailingLists(this.mailingLists);
        model.setLicenses(this.licenses);
        model.setOrganization(this.organization);
        model.setBuild(new Build());
        List<String> artifactIdExclusions = MavenUtils.getCommaSeparatedList(this.excludeDependencies);
        List<String> scopeExclusions = MavenUtils.getCommaSeparatedList(this.excludeDependencyScopes);
        for (Object o : this.dependencies.toArray()) {
            Dependency d = (Dependency)o;
            if (!artifactIdExclusions.contains(d.getArtifactId()) && !scopeExclusions.contains(d.getScope())) continue;
            this.dependencies.remove(d);
        }
        model.setDependencies(this.dependencies);
        File newPomFile = new File(this.outputDirectory, "pom.xml");
        newPomFile.getParentFile().mkdirs();
        FileWriter fw = null;
        try {
            String line;
            fw = new FileWriter(newPomFile);
            BufferedReader br = new BufferedReader(new StringReader(input));
            while ((line = br.readLine()) != null && !line.startsWith("<project")) {
                fw.write(line);
                fw.write(10);
            }
            String pom = MavenUtils.writePomToOutputStream(model).toString();
            int ind = pom.indexOf(10);
            fw.write(pom.substring(ind));
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Exception ex) {}
        }
        if (this.attach.booleanValue()) {
            this.project.setFile(newPomFile);
        }
    }
}

