/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenUtils {
    public static Model readModel(File pom) throws MojoExecutionException {
        try {
            return new DefaultModelReader().read(pom, null);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    public static Model readModel(String input) throws MojoExecutionException {
        try {
            return new DefaultModelReader().read((InputStream)new ByteArrayInputStream(input.getBytes("UTF-8")), null);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private static String getFinalName(Model model) {
        String finalName;
        Build b = model.getBuild();
        if (b != null && b.getFinalName() != null) {
            finalName = b.getFinalName();
        } else {
            String version = model.getVersion() != null ? model.getVersion() : model.getParent().getVersion();
            finalName = model.getArtifactId() + "-" + version;
        }
        return finalName;
    }

    public static List<org.apache.maven.artifact.Artifact> createAttachedArtifacts(String dir, org.apache.maven.artifact.Artifact artifact, Model model) throws MojoExecutionException {
        String finalName;
        String artifactName = "";
        if (artifact != null && artifact.getFile() != null && artifact.getFile().exists()) {
            artifactName = artifact.getFile().getName();
            finalName = artifactName.substring(0, artifactName.lastIndexOf(46));
        } else {
            finalName = MavenUtils.getFinalName(model);
        }
        List<File> attachedFiles = MavenUtils.getFiles(dir, finalName + "*.*", artifactName);
        ArrayList<org.apache.maven.artifact.Artifact> attachedArtifacts = new ArrayList<org.apache.maven.artifact.Artifact>();
        if (!attachedFiles.isEmpty()) {
            for (File attached : attachedFiles) {
                String classifier;
                String tokens = attached.getName().substring(finalName.length());
                if (tokens.endsWith(".pom")) continue;
                String type = tokens.endsWith(".asc") ? tokens.substring(tokens.substring(0, tokens.length() - 4).lastIndexOf(46) + 1, tokens.length()) : tokens.substring(tokens.lastIndexOf(46) + 1, tokens.length());
                if (tokens.endsWith(".pom.asc")) {
                    classifier = "";
                } else {
                    classifier = tokens.substring(tokens.lastIndexOf(45) + 1, tokens.length() - (type.length() + 1));
                    if (classifier.contains(artifact.getVersion())) {
                        classifier = classifier.substring(classifier.indexOf(artifact.getVersion() + 1, classifier.length() - artifact.getVersion().length()));
                    }
                }
                org.apache.maven.artifact.Artifact attachedArtifact = MavenUtils.createArtifact(model, type, classifier);
                attachedArtifact.setFile(attached);
                attachedArtifacts.add(attachedArtifact);
            }
        }
        return attachedArtifacts;
    }

    private static org.apache.maven.artifact.Artifact getArtifactFile(String dir, String finalName, Model model) throws MojoExecutionException {
        List<File> files = MavenUtils.getFiles(dir, finalName + ".*", finalName + "-*.");
        HashMap<String, File> extensionMap = new HashMap<String, File>(files.size());
        for (File f : files) {
            extensionMap.put(f.getName().substring(finalName.length() + 1), f);
        }
        File artifactFile = (File)extensionMap.get(model.getPackaging());
        if (artifactFile != null) {
            org.apache.maven.artifact.Artifact artifact = MavenUtils.createArtifact(model);
            artifact.setFile(artifactFile);
            return artifact;
        }
        for (String ext : extensionMap.keySet()) {
            if (ext.equals("pom") || ext.endsWith(".asc")) continue;
            org.apache.maven.artifact.Artifact artifact = MavenUtils.createArtifact(model, ext, null);
            artifact.setFile((File)extensionMap.get(ext));
            return artifact;
        }
        return null;
    }

    public static org.apache.maven.artifact.Artifact createArtifact(String dir, Model model) throws MojoExecutionException {
        org.apache.maven.artifact.Artifact artifact = MavenUtils.getArtifactFile(dir, MavenUtils.getFinalName(model), model);
        if (artifact == null) {
            artifact = MavenUtils.getArtifactFile(dir, model.getArtifactId(), model);
        }
        return artifact;
    }

    public static File getPomInTarget(String dir) throws MojoExecutionException {
        List<File> poms = MavenUtils.getFiles(dir, "*.pom", "");
        if (!poms.isEmpty()) {
            return poms.get(0);
        }
        return null;
    }

    public static List<File> getFiles(String dir, String includes, String excludes) throws MojoExecutionException {
        File f = new File(dir);
        if (f.exists() && f.isDirectory()) {
            try {
                return FileUtils.getFiles((File)f, (String)includes, (String)excludes);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static org.apache.maven.artifact.Artifact createArtifact(Model m) {
        return MavenUtils.createArtifact(m, m.getPackaging(), null);
    }

    public static org.apache.maven.artifact.Artifact createArtifact(Model m, String type, String classifier) {
        String groupId = m.getGroupId();
        groupId = groupId == null ? m.getParent().getGroupId() : groupId;
        String version = m.getVersion();
        version = version == null ? m.getParent().getVersion() : version;
        return new org.apache.maven.artifact.DefaultArtifact(groupId, m.getArtifactId(), VersionRange.createFromVersion((String)version), "runtime", type, classifier, (ArtifactHandler)new DefaultArtifactHandler(type));
    }

    public static org.apache.maven.artifact.Artifact createArtifact(String groupId, String artifactId, String version, String type, String classifier) {
        return new org.apache.maven.artifact.DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "runtime", type, classifier, (ArtifactHandler)new DefaultArtifactHandler(type));
    }

    public static org.apache.maven.artifact.Artifact createArtifact(String groupId, String artifactId, String version, String type) {
        return MavenUtils.createArtifact(groupId, artifactId, version, type, null);
    }

    public static org.apache.maven.artifact.Artifact createArtifact(Dependency dep) {
        return MavenUtils.createArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), dep.getClassifier());
    }

    public static void writePom(Model m, File buildDir) throws IOException {
        MavenUtils.writePom(m, buildDir, null);
    }

    public static void writePom(Model m, File buildDir, String pomFileName) throws IOException {
        if (pomFileName == null) {
            pomFileName = m.getBuild() != null && m.getBuild().getFinalName() != null ? m.getBuild().getFinalName() + ".pom" : "pom.xml";
        }
        File pomFile = new File(buildDir, pomFileName);
        new DefaultModelWriter().write(pomFile, null, m);
        m.setPomFile(pomFile);
    }

    public static ByteArrayOutputStream writePomToOutputStream(Model m) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new DefaultModelWriter().write((OutputStream)baos, null, m);
        return baos;
    }

    public static void installPom(ArtifactInstaller installer, ArtifactRepository repository, MavenProject p, Model m) throws MojoExecutionException {
        org.apache.maven.artifact.Artifact artifact = MavenUtils.createArtifact(p.getArtifact().getGroupId(), p.getArtifact().getArtifactId(), p.getArtifact().getVersion(), p.getArtifact().getType());
        artifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(artifact, m.getPomFile()));
        try {
            installer.install(m.getPomFile(), artifact, repository);
        }
        catch (ArtifactInstallationException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public static void installAttached(ArtifactInstaller installer, ArtifactRepository repository, MavenProject project, File file, String type, String classifier) throws MojoExecutionException {
        org.apache.maven.artifact.Artifact attached = MavenUtils.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), type, classifier);
        try {
            installer.install(file, attached, repository);
        }
        catch (ArtifactInstallationException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    public static String getManagedVersion(MavenProject module, String groupId, String artifactId) throws MojoExecutionException {
        for (Dependency d : module.getModel().getDependencyManagement().getDependencies()) {
            if (!d.getGroupId().equals(groupId) || !d.getArtifactId().equals(artifactId)) continue;
            return d.getVersion();
        }
        for (org.apache.maven.artifact.Artifact a : MavenUtils.getDependencySet(module, null)) {
            if (!a.getGroupId().equals(groupId) || !a.getArtifactId().equals(artifactId)) continue;
            return a.getVersion();
        }
        if (module.getGroupId().equals(groupId)) {
            return module.getModel().getVersion();
        }
        return "";
    }

    public static Set<org.apache.maven.artifact.Artifact> getDependencySet(MavenProject p, Map<MavenProject, Set<org.apache.maven.artifact.Artifact>> dependencySets) throws MojoExecutionException {
        if (dependencySets != null && dependencySets.containsKey(p)) {
            return dependencySets.get(p);
        }
        Set<org.apache.maven.artifact.Artifact> artifacts = MavenUtils.filterArtifacts(p.getArtifacts(), p.getDependencyArtifacts(), false, "runtime", "test", "jar", "");
        if (dependencySets != null) {
            dependencySets.put(p, artifacts);
        }
        return artifacts;
    }

    public static Set<org.apache.maven.artifact.Artifact> filterArtifacts(Set<org.apache.maven.artifact.Artifact> artifacts, Set<org.apache.maven.artifact.Artifact> dependencyArtifacts, boolean excludeTransitive, String includeScope, String excludeScope, String excludeTypes, String includeTypes) throws MojoExecutionException {
        return MavenUtils.filterArtifacts(artifacts, dependencyArtifacts, excludeTransitive, includeScope, excludeScope, includeTypes, excludeTypes, null, null, null, null, null, null);
    }

    public static Set<org.apache.maven.artifact.Artifact> filterArtifacts(Set<org.apache.maven.artifact.Artifact> artifacts, Set<org.apache.maven.artifact.Artifact> dependencyArtifacts, boolean excludeTransitive, String includeScope, String excludeScope, String excludeTypes, String includeTypes, String includeClassifiers, String excludeClassifiers, String includeGroupIds, String excludeGroupIds, String includeArtifactIds, String excludeArtifactIds) throws MojoExecutionException {
        includeScope = includeScope == null ? "" : includeScope;
        excludeScope = excludeScope == null ? "" : excludeScope;
        includeTypes = includeTypes == null ? "" : includeTypes;
        excludeTypes = excludeTypes == null ? "" : excludeTypes;
        includeClassifiers = includeClassifiers == null ? "" : includeClassifiers;
        excludeClassifiers = excludeClassifiers == null ? "" : excludeClassifiers;
        includeGroupIds = includeGroupIds == null ? "" : includeGroupIds;
        excludeGroupIds = excludeGroupIds == null ? "" : excludeGroupIds;
        includeArtifactIds = includeArtifactIds == null ? "" : includeArtifactIds;
        excludeArtifactIds = excludeArtifactIds == null ? "" : excludeArtifactIds;
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(dependencyArtifacts, excludeTransitive));
        filter.addFilter((ArtifactsFilter)new ScopeFilter(MavenUtils.cleanToBeTokenizedString(includeScope), MavenUtils.cleanToBeTokenizedString(excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(MavenUtils.cleanToBeTokenizedString(includeTypes), MavenUtils.cleanToBeTokenizedString(excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(MavenUtils.cleanToBeTokenizedString(includeClassifiers), MavenUtils.cleanToBeTokenizedString(excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(MavenUtils.cleanToBeTokenizedString(includeGroupIds), MavenUtils.cleanToBeTokenizedString(excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(MavenUtils.cleanToBeTokenizedString(includeArtifactIds), MavenUtils.cleanToBeTokenizedString(excludeArtifactIds)));
        try {
            artifacts = filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return artifacts;
    }

    public static void unpack(File file, File location, String includes, String excludes, boolean silent, Log log, ArchiverManager archiverManager) throws MojoExecutionException {
        if (log != null && log.isInfoEnabled() && !silent) {
            log.info((CharSequence)MavenUtils.logUnpack(file, location, includes, excludes));
        }
        location.mkdirs();
        try {
            UnArchiver unArchiver = archiverManager.getUnArchiver(file);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            if (StringUtils.isNotEmpty((String)excludes) || StringUtils.isNotEmpty((String)includes)) {
                IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
                if (StringUtils.isNotEmpty((String)excludes)) {
                    selectors[0].setExcludes(excludes.split(","));
                }
                if (StringUtils.isNotEmpty((String)includes)) {
                    selectors[0].setIncludes(includes.split(","));
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
            }
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + location + "\r\n" + e.toString(), (Exception)((Object)e));
        }
    }

    private static String logUnpack(File file, File location, String includes, String excludes) {
        StringBuilder msg = new StringBuilder();
        msg.append("Unpacking ");
        msg.append(file);
        msg.append(" to ");
        msg.append(location);
        if (includes != null && excludes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\" and excludes \"");
            msg.append(excludes);
            msg.append("\"");
        } else if (includes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\"");
        } else if (excludes != null) {
            msg.append(" with excludes \"");
            msg.append(excludes);
            msg.append("\"");
        }
        return msg.toString();
    }

    public static ArtifactResult resolveArtifact(DefaultArtifact requestArtifact, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) throws MojoExecutionException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)requestArtifact);
        request.setRepositories(remoteRepos);
        try {
            result = repoSystem.resolveArtifact(repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return result;
    }

    public static String cleanToBeTokenizedString(String str) {
        String ret = "";
        if (!StringUtils.isEmpty((String)str)) {
            ret = str.trim().replaceAll("[\\s]*,[\\s]*", ",");
        }
        return ret;
    }

    public static ModifiedPomXMLEventReader newModifiedPomXER(StringBuilder input) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
        inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
        return new ModifiedPomXMLEventReader(input, inputFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File outFile, StringBuilder input) throws IOException {
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)outFile);
        try {
            IOUtil.copy((String)input.toString(), (Writer)writer);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    public static List<String> getCommaSeparatedList(String list) {
        String[] listArray;
        if (list != null && (listArray = list.split(",")) != null) {
            return Arrays.asList(listArray);
        }
        return Collections.EMPTY_LIST;
    }
}

