/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.glassfish.build.AbstractAggregatorMojo;
import org.glassfish.build.utils.MavenUtils;

public class GenerateBomPomMojo
extends AbstractAggregatorMojo {
    protected File outputFile;
    protected String groupId;
    protected String artifactId;
    protected String version;
    protected Parent parentPom;
    protected String description;
    protected Boolean skip;

    protected void executeAggregate() throws MojoExecutionException {
        if (this.skip.booleanValue()) {
            this.getLog().info((CharSequence)"skipping...");
            return;
        }
        Model model = new Model();
        if (this.parentPom != null) {
            model.setParent(this.parentPom);
        }
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        if (this.description != null && !this.description.isEmpty()) {
            model.setDescription(this.description);
        }
        DependencyManagement dependencyMgmt = new DependencyManagement();
        for (MavenProject p : this.reactorProjects) {
            Dependency d = new Dependency();
            d.setGroupId(p.getGroupId());
            d.setArtifactId(p.getArtifactId());
            d.setVersion(p.getVersion());
            if (p.getArtifact().getFile().exists()) {
                String name = p.getArtifact().getFile().getName();
                d.setType(name.substring(name.lastIndexOf(".")));
            }
            dependencyMgmt.addDependency(d);
            for (Artifact a : p.getAttachedArtifacts()) {
                if (!a.getFile().exists()) continue;
                Dependency attached = d.clone();
                attached.setClassifier(a.getClassifier());
                String name = a.getFile().getName();
                attached.setType(name.substring(name.lastIndexOf(".")));
                dependencyMgmt.addDependency(attached);
            }
        }
        try {
            MavenUtils.writePom(model, this.outputFile);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }
}

