/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.glassfish.build.AbstractAggregatorMojo;

public class PkgDeployMojo
extends AbstractAggregatorMojo {
    private ArtifactDeployer deployer;
    protected ArtifactRepository localRepository;
    private File pomFile;
    private Artifact artifact;
    private List attachedArtifacts;

    protected void executeAggregate() throws MojoExecutionException {
        ArtifactRepository repo = this.project.getDistributionManagementArtifactRepository();
        Iterator it = this.modules.iterator();
        try {
            while (it.hasNext()) {
                MavenProject p = (MavenProject)it.next();
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)("Deploying sub-module (" + p.getName() + ")"));
                this.deployer.deploy(p.getArtifact().getFile(), p.getArtifact(), repo, this.localRepository);
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Deploying parent-module (" + this.project.getName() + ")"));
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(this.artifact, this.pomFile);
            this.artifact.addMetadata((ArtifactMetadata)metadata);
            this.deployer.deploy(this.pomFile, this.artifact, repo, this.localRepository);
            Iterator it2 = this.attachedArtifacts.iterator();
            while (it.hasNext()) {
                Artifact attached = (Artifact)it2.next();
                this.getLog().info((CharSequence)("Deploying parent-module attached artifact (" + attached.getClassifier() + ")"));
                this.deployer.deploy(attached.getFile(), attached, repo, this.localRepository);
            }
        }
        catch (ArtifactDeploymentException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }
}

