/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.glassfish.build.utils.MavenUtils;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class UnpackSourcesMojo
extends AbstractMojo {
    protected MavenProject project;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;
    protected ArchiverManager archiverManager;
    private String includes;
    private String excludes;
    protected boolean excludeTransitive;
    protected String includeTypes;
    protected String excludeTypes;
    protected String includeScope;
    protected String excludeScope;
    protected String includeClassifiers;
    protected String excludeClassifiers;
    protected String excludeArtifactIds;
    protected String includeArtifactIds;
    protected String excludeGroupIds;
    protected String includeGroupIds;
    private File outputDirectory;
    private boolean silent;
    private boolean attachSources;
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping unpack-sources");
            return;
        }
        Set<Artifact> filteredDependencies = MavenUtils.filterArtifacts(this.project.getArtifacts(), this.project.getDependencyArtifacts(), this.excludeTransitive, this.includeScope, this.excludeScope, this.excludeTypes, this.includeTypes, this.includeClassifiers, this.excludeClassifiers, this.includeGroupIds, this.excludeGroupIds, this.includeArtifactIds, this.excludeArtifactIds);
        for (Artifact artifact : filteredDependencies) {
            DefaultArtifact requestArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "sources", "jar", artifact.getVersion());
            ArtifactResult result = MavenUtils.resolveArtifact(requestArtifact, this.repoSystem, this.repoSession, this.remoteRepos);
            MavenUtils.unpack(result.getArtifact().getFile(), this.outputDirectory, MavenUtils.cleanToBeTokenizedString(this.includes), MavenUtils.cleanToBeTokenizedString(this.excludes), this.silent, this.getLog(), this.archiverManager);
        }
        if (this.attachSources) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
    }
}

