/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.descriptors;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
public class Packages {
    public static final String DEFAULT_TYPE = "zip";
    private static HashSet<String> artifactsIds;
    private List<Package> packages;
    private String groupId;
    private String artifactId;
    private String version;

    public Packages() {
    }

    public Packages(MavenProject p) {
        artifactsIds = new HashSet();
        this.packages = new ArrayList<Package>();
        this.groupId = p.getGroupId();
        this.artifactId = p.getArtifactId();
        this.version = p.getVersion();
    }

    @XmlElement(name="package")
    public List<Package> getPackages() {
        return this.packages;
    }

    @XmlAttribute
    public String getGroupId() {
        return this.groupId;
    }

    @XmlAttribute
    public String getArtifactId() {
        return this.artifactId;
    }

    @XmlAttribute
    public String getVersion() {
        return this.version;
    }

    public void addPackage(Package p) {
        this.packages.add(p);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setPackages(List<Package> packages) {
        this.packages = packages;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void writeXML(File output) throws MojoExecutionException, JAXBException {
        JAXBContext ctxt = JAXBContext.newInstance((Class[])new Class[]{Packages.class});
        Marshaller m = ctxt.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)this, output);
    }

    public static Packages readXML(File input) throws JAXBException {
        JAXBContext ctxt = JAXBContext.newInstance((Class[])new Class[]{Packages.class});
        Unmarshaller m = ctxt.createUnmarshaller();
        return (Packages)m.unmarshal(input);
    }

    public static Package getPackageWithDependency(List<Packages> packagesList, String gid, String aId, String version) {
        Package pkg = null;
        for (Packages pkgs : packagesList) {
            pkg = pkgs.getPackageWithDependency(gid, aId, version);
            if (pkg == null) continue;
            return pkg;
        }
        return pkg;
    }

    public Package getPackageWithDependency(String gid, String aId, String version) {
        for (Package curPkg : this.getPackages()) {
            if (!curPkg.isInPackages(gid, aId, version)) continue;
            return curPkg;
        }
        return null;
    }

    public static class DuplicatedArtifactIdEx
    extends Exception {
        public DuplicatedArtifactIdEx(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlType
    public static class Package {
        @XmlAttribute(name="groupId")
        String packageGroupId;
        @XmlAttribute(name="artifactId")
        String packageArtifactId;
        @XmlAttribute(name="version")
        String packageVersion;
        private List<PackageItem> packageItems;

        public Package() {
        }

        public Package(String gId, String aId, String version) {
            this.packageItems = new ArrayList<PackageItem>();
            this.packageGroupId = gId;
            this.packageArtifactId = aId;
            this.packageVersion = version;
        }

        public void setPackageArtifactId(String packageArtifactId) {
            this.packageArtifactId = packageArtifactId;
        }

        public void setPackageGroupId(String packageGroupId) {
            this.packageGroupId = packageGroupId;
        }

        public void setPackageVersion(String packageVersion) {
            this.packageVersion = packageVersion;
        }

        public void setPackageItems(List<PackageItem> packageItems) {
            this.packageItems = packageItems;
        }

        public String getGroupId() {
            return this.packageGroupId;
        }

        public String getArtifactId() {
            return this.packageArtifactId;
        }

        public String getVersion() {
            return this.packageVersion;
        }

        @XmlElement(name="packageItem")
        public List<PackageItem> getPackageItems() {
            return this.packageItems;
        }

        public void addPackageItem(PackageItem pkgMbr) {
            this.packageItems.add(pkgMbr);
        }

        public boolean isInPackages(String gId, String aId, String version) {
            for (PackageItem pkgItem : this.getPackageItems()) {
                if (gId != null && !pkgItem.getGroupId().equals(gId) || version != null && !pkgItem.getVersion().equals(version) || !pkgItem.getArtifactId().equals(aId)) continue;
                return true;
            }
            return false;
        }

        @XmlType
        public static class PackageItem {
            @XmlAttribute(name="groupId")
            private String memberGroupId;
            @XmlAttribute(name="artifactId")
            private String memberArtifactId;
            @XmlAttribute(name="version")
            private String memberVersion;

            public PackageItem() {
            }

            public PackageItem(String gId, String aId, String version) throws DuplicatedArtifactIdEx {
                if (artifactsIds.contains(aId)) {
                    throw new DuplicatedArtifactIdEx("artifactId(" + aId + ") is duplicated in package");
                }
                this.memberGroupId = gId;
                this.memberArtifactId = aId;
                this.memberVersion = version;
            }

            public void setMemberArtifactId(String memberArtifactId) {
                this.memberArtifactId = memberArtifactId;
            }

            public void setMemberGroupId(String memberGroupId) {
                this.memberGroupId = memberGroupId;
            }

            public void setMemberVersion(String memberVersion) {
                this.memberVersion = memberVersion;
            }

            public String getGroupId() {
                return this.memberGroupId;
            }

            public String getArtifactId() {
                return this.memberArtifactId;
            }

            public String getVersion() {
                return this.memberVersion;
            }
        }
    }
}

