/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnRemoteDelete;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class DeleteSvnTagMojo
extends AbstractMojo {
    private MavenProject project;
    protected Settings settings;
    private String tagBase;
    private String tagName;
    private String commitPrefix;
    private ScmManager scmManager;
    private SvnTarget target = null;
    private SvnOperationFactory svnOperationFactory = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.init();
        if (this.tagExists()) {
            this.getLog().info((CharSequence)("deleting " + this.target.getPathOrUrlString()));
            SvnRemoteDelete delete = this.svnOperationFactory.createRemoteDelete();
            delete.addTarget(this.target);
            delete.setCommitMessage(this.commitPrefix + this.tagName);
            try {
                SVNCommitInfo commitInfo = (SVNCommitInfo)delete.run();
                this.getLog().debug((CharSequence)("committed revision " + commitInfo.getNewRevision()));
            }
            catch (SVNException ex) {
                throw new MojoExecutionException("failed to remove tag " + this.target.getPathOrUrlString(), (Exception)((Object)ex));
            }
        } else {
            this.getLog().info((CharSequence)(this.target.getPathOrUrlString() + " does not exist"));
        }
    }

    private boolean tagExists() {
        SvnGetInfo info = this.svnOperationFactory.createGetInfo();
        info.setSingleTarget(this.target);
        try {
            info.run();
        }
        catch (SVNException ex) {
            return false;
        }
        return true;
    }

    private void init() throws MojoExecutionException {
        try {
            this.scmManager.setScmProviderImplementation("svn", "javasvn");
            ScmRepository repo = this.scmManager.makeScmRepository(this.project.getScm().getDeveloperConnection());
            if (!repo.getProvider().equals("svn")) {
                this.getLog().warn((CharSequence)"only svn SCM is supported");
                return;
            }
            SvnJavaScmProviderRepository providerRepo = (SvnJavaScmProviderRepository)repo.getProviderRepository();
            this.svnOperationFactory = new SvnOperationFactory();
            this.svnOperationFactory.setOptions(providerRepo.getClientManager().getOptions());
            StringBuilder tagStrUrl = new StringBuilder();
            if (this.tagBase != null && !this.tagBase.isEmpty()) {
                tagStrUrl.append(this.tagBase);
            } else {
                tagStrUrl.append(providerRepo.getTagBase());
            }
            tagStrUrl.append('/');
            tagStrUrl.append(this.tagName);
            URL tagURL = new URL(tagStrUrl.toString());
            SVNURL svnTagURL = SVNURL.create((String)tagURL.getProtocol(), (String)tagURL.getUserInfo(), (String)tagURL.getHost(), (int)tagURL.getPort(), (String)tagURL.getPath(), (boolean)false);
            this.target = SvnTarget.fromURL((SVNURL)svnTagURL);
            Server server = this.settings.getServer(tagURL.getHost());
            if (server != null) {
                this.svnOperationFactory.setAuthenticationManager((ISVNAuthenticationManager)new BasicAuthenticationManager(server.getUsername(), server.getPassword()));
            }
        }
        catch (SVNException ex) {
            throw new MojoExecutionException("init failed", (Exception)((Object)ex));
        }
        catch (ScmRepositoryException ex) {
            throw new MojoExecutionException("init failed", (Exception)((Object)ex));
        }
        catch (NoSuchScmProviderException ex) {
            throw new MojoExecutionException("init failed", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new MojoExecutionException("init failed", (Exception)ex);
        }
    }
}

