/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.glassfish.build.AbstractAggregatorMojo;
import org.glassfish.build.descriptors.Packages;
import org.glassfish.build.utils.DependencyWrapper;
import org.glassfish.build.utils.MavenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PkgDependencyMojo
extends AbstractAggregatorMojo {
    private ArtifactResolver artifactResolver;
    protected ArtifactInstaller installer;
    protected ArtifactRepository localRepository;
    protected String descriptorName;
    protected Boolean strictResolution;
    protected Boolean processHidden;
    protected Boolean skipPkgDependency;
    protected Boolean failForDuplicates;
    protected List<Dependency> hiddenDependencies;
    protected List<String> excludeGroupIds;
    protected List<String> excludeArtifactIds;
    protected String staggingDir;
    protected String packagingTypes;
    protected static final String DESCRIPTOR_CLASSIFIER = "packages-descriptor";
    protected static final String DESC_TYPE = "xml";
    protected static final String GF_PLUGIN_KEY = "org.glassfish.build:glassfishbuild-maven-plugin";
    protected File descriptorFile = null;

    @Override
    protected void executeAggregate() throws MojoExecutionException {
        if (this.skipPkgDependency.booleanValue()) {
            return;
        }
        HashMap<MavenProject, Set<Artifact>> allDeps = new HashMap<MavenProject, Set<Artifact>>();
        List<String> packagingTypesList = Arrays.asList(this.packagingTypes.split(","));
        File buildDirectory = new File(this.parent.getBuild().getDirectory());
        buildDirectory.mkdir();
        this.descriptorFile = new File(buildDirectory, this.descriptorName + "." + DESC_TYPE);
        Packages descriptor = null;
        try {
            descriptor = PkgDependencyMojo.createDescriptor(this.parent, this.modules, this.descriptorFile, allDeps, this.staggingDir, packagingTypesList, this.processHidden);
        }
        catch (Packages.DuplicatedArtifactIdEx ex) {
            if (this.failForDuplicates.booleanValue()) {
                throw new MojoExecutionException(ex.getMessage());
            }
            this.getLog().warn((CharSequence)ex.getMessage());
        }
        List<Packages> providedDescriptors = this.readDescriptors(this.parent, this.localRepository);
        providedDescriptors.add(descriptor);
        for (MavenProject module : this.modules) {
            if (!packagingTypesList.isEmpty() && !packagingTypesList.contains(module.getPackaging())) continue;
            Model originalModel = module.getOriginalModel();
            HashSet<DependencyWrapper> generatedDeps = new HashSet<DependencyWrapper>();
            for (Artifact artifact : MavenUtils.getDependencySet(module, allDeps)) {
                if (this.excludeGroupIds == null || this.excludeGroupIds.contains(artifact.getGroupId()) || this.excludeArtifactIds == null || this.excludeArtifactIds.contains(artifact.getArtifactId())) continue;
                Dependency dep = this.resolveDependency(providedDescriptors, artifact);
                if (dep != null) {
                    if (dep.getGroupId().equals(module.getGroupId()) && dep.getArtifactId().equals(module.getArtifactId()) && dep.getVersion().equals(module.getVersion())) continue;
                    this.getLog().debug((CharSequence)("Creating new dependency(" + dep + ") for (" + module.getName() + ")"));
                    generatedDeps.add(new DependencyWrapper(dep));
                    continue;
                }
                String msg = "No package found to resolve: " + artifact + " in " + module.getArtifactId();
                if (this.strictResolution.booleanValue()) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().warn((CharSequence)msg);
            }
            if (generatedDeps.isEmpty()) continue;
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Post processing - " + module.getName()));
            for (DependencyWrapper d : generatedDeps) {
                originalModel.getDependencies().add(d.getDependency());
            }
            try {
                MavenUtils.writePom(originalModel, new File(module.getBuild().getDirectory()));
            }
            catch (IOException ex) {
                this.getLog().error((Throwable)ex);
            }
            MavenUtils.installPom(this.installer, this.localRepository, module, originalModel);
        }
        try {
            descriptor.writeXML(this.descriptorFile);
        }
        catch (JAXBException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
        MavenUtils.installAttached(this.installer, this.localRepository, this.parent, this.descriptorFile, DESC_TYPE, DESCRIPTOR_CLASSIFIER);
    }

    protected Dependency resolveDependency(List<Packages> packagesList, Artifact art) {
        Packages.Package pkg;
        if (!art.getScope().equals("test") && (pkg = Packages.getPackageWithDependency(packagesList, null, art.getArtifactId(), null)) != null) {
            Dependency dep = new Dependency();
            dep.setGroupId(pkg.getGroupId());
            dep.setArtifactId(pkg.getArtifactId());
            dep.setType("zip");
            dep.setVersion(pkg.getVersion());
            return dep;
        }
        return null;
    }

    protected List<Packages> readDescriptors(MavenProject parent, ArtifactRepository repository) throws MojoExecutionException {
        ArrayList<Packages> parentDescriptors = new ArrayList<Packages>();
        for (Dependency dep : parent.getDependencies()) {
            if (dep.getClassifier() == null || !dep.getClassifier().equals(DESCRIPTOR_CLASSIFIER)) continue;
            try {
                Artifact artifact = MavenUtils.createArtifact(dep);
                this.artifactResolver.resolve(artifact, parent.getRemoteArtifactRepositories(), repository);
                parentDescriptors.add(Packages.readXML(artifact.getFile()));
            }
            catch (ArtifactResolutionException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (ArtifactNotFoundException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
            }
            catch (JAXBException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
            }
        }
        return parentDescriptors;
    }

    protected static Packages createDescriptor(MavenProject parent, List<MavenProject> modules, File desc, Map<MavenProject, Set<Artifact>> allDeps, String dirsString, List<String> includePackagingTypes, boolean processHidden) throws MojoExecutionException, Packages.DuplicatedArtifactIdEx {
        Packages packages = new Packages(parent);
        for (MavenProject module : modules) {
            if (!includePackagingTypes.isEmpty() && !includePackagingTypes.contains(module.getPackaging())) continue;
            List<String> packageContent = PkgDependencyMojo.getPackageContent(module, dirsString);
            Set<Artifact> deps = MavenUtils.getDependencySet(module, allDeps);
            Packages.Package curPackage = new Packages.Package(module.getGroupId(), module.getArtifactId(), module.getVersion());
            if (processHidden) {
                curPackage = PkgDependencyMojo.processHiddenDependencies(module, curPackage);
            }
            for (Artifact dep : deps) {
                if (!PkgDependencyMojo.hasItemEndingWith(packageContent, dep.getArtifactId().concat(".").concat(dep.getType()))) continue;
                curPackage.addPackageItem(new Packages.Package.PackageItem(dep.getGroupId(), dep.getArtifactId(), dep.getBaseVersion()));
            }
            packages.addPackage(curPackage);
        }
        return packages;
    }

    protected static Packages.Package processHiddenDependencies(MavenProject module, Packages.Package pkg) throws MojoExecutionException, Packages.DuplicatedArtifactIdEx {
        Xpp3Dom hiddenDeps;
        Xpp3Dom dom;
        if (pkg != null && (dom = (Xpp3Dom)module.getPlugin(GF_PLUGIN_KEY).getConfiguration()) != null && (hiddenDeps = dom.getChild("hiddenDependencies")) != null) {
            for (Xpp3Dom hiddenDep : hiddenDeps.getChildren()) {
                Xpp3Dom artifactId;
                Xpp3Dom groupId = hiddenDep.getChild("groupId");
                if (groupId == null || (artifactId = hiddenDep.getChild("artifactId")) == null) continue;
                if (groupId.getValue() == null || artifactId.getValue() == null) {
                    throw new MojoExecutionException("dom value missing!");
                }
                String version = hiddenDep.getChild("version") != null ? hiddenDep.getChild("version").getValue() : MavenUtils.getManagedVersion(module, groupId.getValue(), artifactId.getValue());
                pkg.addPackageItem(new Packages.Package.PackageItem(groupId.getValue(), artifactId.getValue(), version));
            }
        }
        return pkg;
    }

    protected static List<String> getPackageContent(MavenProject module, String staggingDir) throws MojoExecutionException {
        File basedir = new File(module.getBuild().getDirectory());
        ArrayList<String> fileNames = new ArrayList<String>();
        File dir = new File(basedir, staggingDir);
        if (dir.exists()) {
            try {
                fileNames.addAll(FileUtils.getFileNames((File)dir, (String)"**/*", (String)"", (boolean)true));
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
        return fileNames;
    }

    public static boolean hasItemEndingWith(List<String> list, String str) throws MojoExecutionException {
        for (String s : list) {
            if (!s.endsWith(str)) continue;
            return true;
        }
        return false;
    }
}

