/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import com.sun.enterprise.build.DistributionArtifactHandler;
import java.io.File;
import java.util.Properties;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;
import org.glassfish.build.AbstractAntMojo;

public class ZipMojo
extends AbstractAntMojo {
    protected File outputDirectory;
    protected String finalName;
    protected String duplicate;
    protected ZipFileSet[] filesets;
    protected File dir;
    protected String includes;
    protected String excludes;
    protected String extension;
    protected Boolean attach;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Project antProject = new Project();
        antProject.addBuildListener((BuildListener)this);
        this.project.addCompileSourceRoot(null);
        Properties mavenProperties = this.project.getProperties();
        for (String string : mavenProperties.keySet()) {
            antProject.setProperty(string, mavenProperties.getProperty(string));
        }
        Zip zip = new Zip();
        zip.setProject(antProject);
        StringBuilder finalFileName = new StringBuilder(this.finalName);
        finalFileName.append('.');
        finalFileName.append(this.extension);
        File target = new File(this.outputDirectory, finalFileName.toString());
        zip.setDestFile(target);
        Zip.Duplicate df = new Zip.Duplicate();
        df.setValue(this.duplicate);
        zip.setDuplicate(df);
        this.getLog().info((CharSequence)("duplicate: " + this.duplicate));
        if (this.filesets.length > 0) {
            for (ZipFileSet zfs : this.filesets) {
                this.getLog().info((CharSequence)("file set : " + zfs.getDir() + " (excludes: " + ZipMojo.displayStringArray(zfs.mergeExcludes(antProject)) + ", includes: " + ZipMojo.displayStringArray(zfs.mergeIncludes(antProject)) + ")"));
                zip.addZipfileset(zfs);
            }
        } else {
            ZipFileSet zfs = new ZipFileSet();
            zfs.setDir(this.dir);
            zfs.setIncludes(this.includes);
            zfs.setExcludes(this.excludes);
            zfs.setDirMode("755");
            zfs.setFileMode("644");
            this.getLog().info((CharSequence)("default file set: " + zfs.getDir() + " ( excludes: [ " + this.excludes + " ]" + ", includes: [ " + this.includes + " ])"));
            zip.addZipfileset(zfs);
        }
        zip.executeMain();
        if (this.attach.booleanValue()) {
            this.project.getArtifact().setFile(target);
            this.project.getArtifact().setArtifactHandler((ArtifactHandler)new DistributionArtifactHandler(this.extension, this.project.getPackaging()));
        }
    }

    public static String displayStringArray(String[] strArray) {
        StringBuilder sb = new StringBuilder("[");
        if (strArray != null) {
            for (int i = 0; i < strArray.length; ++i) {
                sb.append(strArray[i]);
                if (i == strArray.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    String prefix() {
        return "[zip]";
    }
}

