/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.descriptors;

public class Prototype {
    private String name = null;
    private String version = null;
    private Attribute[] attributes = null;
    private Default[] defaults = null;
    private Depend[] depends = null;
    private Dir[] dirs = null;
    private DirTree[] dirTrees = null;
    private File[] files = null;
    private ExcludeFile[] excludeFiles = null;
    private ExcludesDir[] excludeDirs = null;
    private License[] licences = null;

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
    }

    public Default[] getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Default[] defaults) {
        this.defaults = defaults;
    }

    public Depend[] getDepends() {
        return this.depends;
    }

    public void setDepends(Depend[] depends) {
        this.depends = depends;
    }

    public DirTree[] getDirTrees() {
        return this.dirTrees;
    }

    public void setDirTrees(DirTree[] dirTrees) {
        this.dirTrees = dirTrees;
    }

    public Dir[] getDirs() {
        return this.dirs;
    }

    public void setDirs(Dir[] dirs) {
        this.dirs = dirs;
    }

    public ExcludesDir[] getExcludeDirs() {
        return this.excludeDirs;
    }

    public void setExcludsDirs(ExcludesDir[] excludeDirs) {
        this.excludeDirs = excludeDirs;
    }

    public ExcludeFile[] getExcludeFiles() {
        return this.excludeFiles;
    }

    public void setExcludeFiles(ExcludeFile[] excludeFiles) {
        this.excludeFiles = excludeFiles;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFiles(File[] files) {
        this.files = files;
    }

    public License[] getLicences() {
        return this.licences;
    }

    public void setLicences(License[] licences) {
        this.licences = licences;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toPythonString() {
        StringBuilder sb = new StringBuilder("pkg = {\n");
        if (this.name != null) {
            sb.append("\"name\" : \"");
            sb.append(this.name);
            sb.append("\",\n");
        }
        if (this.version != null) {
            sb.append("\"version\" : \"");
            sb.append(this.version);
            sb.append("\",\n");
        }
        if (this.attributes != null) {
            sb.append("\"attributes\" : {\n");
            for (Attribute attribute : this.attributes) {
                sb.append(attribute.toPythonString());
                sb.append(",\n");
            }
            sb.append("},\n");
        }
        if (this.defaults != null) {
            sb.append("\"defaults\" : {\n");
            for (Default default_ : this.defaults) {
                sb.append(default_.toPythonString());
                sb.append(",\n");
            }
            sb.append("},\n");
        }
        if (this.depends != null) {
            sb.append("\"depends\" : {\n");
            for (Depend depend : this.depends) {
                sb.append(depend.toPythonString());
                sb.append(",\n");
            }
            sb.append("},\n");
        }
        if (this.dirs != null) {
            sb.append("\"dirs\" : {\n");
            for (Dir dir : this.dirs) {
                sb.append(dir.toPythonString());
                sb.append(",\n");
            }
            sb.append("},\n");
        }
        if (this.dirTrees != null) {
            sb.append("\"dirtrees\" : {\n");
            for (DirTree dirTree : this.dirTrees) {
                sb.append(dirTree.toPythonString());
                sb.append(",\n");
            }
            sb.append("},\n");
        }
        if (this.files != null) {
            sb.append("\"files\" : {\n");
            for (File file : this.files) {
                sb.append(file.toPythonString());
                sb.append(",\n");
            }
            sb.append("},\n");
        }
        if (this.excludeFiles != null) {
            sb.append("\"excludesfiles\" : [\n");
            for (ExcludeFile excludeFile : this.excludeFiles) {
                sb.append(excludeFile.toPythonString());
                sb.append(",\n");
            }
            sb.append("],\n");
        }
        if (this.excludeDirs != null) {
            sb.append("\"excludedirs\" : [\n");
            for (ExcludesDir excludesDir : this.excludeDirs) {
                sb.append(excludesDir.toPythonString());
                sb.append(",\n");
            }
            sb.append("],\n");
        }
        if (this.licences != null) {
            sb.append("\"licences\" : {\n");
            for (License license : this.licences) {
                sb.append(license.toPythonString());
                sb.append(",\n");
            }
            sb.append("},\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public static class License {
        String file;
        String name;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toPythonString() {
            return "\"pkg/" + this.file + "\" : {\"licence\" : \"" + this.name + "\"},";
        }
    }

    public static class ExcludesDir
    extends ExcludeFile {
    }

    public static class ExcludeFile {
        String path;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String toPythonString() {
            return "\"pkg/" + this.path + "\"";
        }
    }

    public static class DirTree
    extends File {
    }

    public static class Dir
    extends File {
    }

    public static class File {
        String path = null;
        String mode = null;
        String owner = null;
        String group = null;
        String os = null;
        String preserve = null;

        public String getPreserve() {
            return this.preserve;
        }

        public void setPreserve(String preserve) {
            this.preserve = preserve;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getOs() {
            return this.os;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String toPythonString() {
            String pythonStr = "\"" + this.path + "\" : {";
            if (this.mode != null) {
                pythonStr = pythonStr + "\"mode\" : \"" + this.mode + "\", ";
            }
            if (this.os != null) {
                pythonStr = pythonStr + "\"os\" : \"" + this.os + "\",  ";
            }
            if (this.owner != null) {
                pythonStr = pythonStr + "\"owner\" : \"" + this.owner + "\", ";
            }
            if (this.group != null) {
                pythonStr = pythonStr + "\"group\" : \"" + this.group + "\", ";
            }
            if (this.preserve != null) {
                pythonStr = pythonStr + "\"preserve\" : \"" + this.preserve + "\", ";
            }
            return pythonStr + "}";
        }
    }

    public static class Depend {
        String pkg;
        String version;
        String type;

        public String getPkg() {
            return this.pkg;
        }

        public void setPkg(String pkg) {
            this.pkg = pkg;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toPythonString() {
            return "\"pkg:/" + this.pkg + "@" + this.version + " : {\"type\" : \"" + this.type + "\"}";
        }
    }

    public static class Default {
        private String type;
        private String mode;
        private String group;
        private String owner;

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String toPythonString() {
            return "\"" + this.type + "\" : {\"mode\" \"" + this.mode + "\", \"group\" : \"" + this.group + "\", \"owner\" : \"" + this.owner + "\",}";
        }
    }

    public static class Attribute {
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toPythonString() {
            return "\"" + this.key + "\" : \"" + this.value + "\",";
        }
    }
}

