/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build;

import java.io.File;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.condition.Os;

@Mojo(name="exec", requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public final class ExecMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="executable")
    private String executable;
    @Parameter(property="workingDir", defaultValue="${project.build.directory}")
    private File workingDir;
    @Parameter(property="commandlineArgs")
    private String commandlineArgs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Project antProject = new Project();
        antProject.addBuildListener((BuildListener)new AntBuildListener());
        Properties mavenProperties = this.project.getProperties();
        for (String string : mavenProperties.keySet()) {
            antProject.setProperty(string, mavenProperties.getProperty(string));
        }
        ExecTask execTask = new ExecTask();
        execTask.setProject(antProject);
        execTask.setDir(this.workingDir);
        if (new Os("Windows").eval() && !this.executable.endsWith(".bat") && new File(this.executable + ".bat").exists()) {
            this.executable = this.executable + ".bat";
        }
        execTask.setExecutable(this.executable);
        this.getLog().info((CharSequence)("executable: " + this.executable));
        execTask.createArg().setLine(this.commandlineArgs);
        this.getLog().info((CharSequence)("commandLineArgs: " + this.commandlineArgs));
        execTask.execute();
    }

    private class AntBuildListener
    implements BuildListener {
        private static final int MAX_EVENT_PRIORITY = 3;

        private AntBuildListener() {
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if (event.getPriority() < 3) {
                ExecMojo.this.getLog().info((CharSequence)("[exec] " + event.getMessage()));
            } else {
                ExecMojo.this.getLog().debug((CharSequence)("[exec] " + event.getMessage()));
            }
        }
    }
}

