/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.apache.tools.ant.types.ZipFileSet;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.glassfish.build.utils.ZipHelper;

public final class MavenHelper {
    private MavenHelper() {
    }

    public static Model readModel(File pom) throws MojoExecutionException {
        try {
            return new DefaultModelReader().read(pom, null);
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private static String getFinalName(Model model) {
        String finalName;
        Build build = model.getBuild();
        if (build != null && build.getFinalName() != null) {
            finalName = build.getFinalName();
        } else {
            String version;
            if (model.getVersion() != null) {
                version = model.getVersion();
            } else {
                if (model.getParent() == null) {
                    throw new IllegalStateException("no version defined and no parent found");
                }
                version = model.getParent().getVersion();
            }
            finalName = model.getArtifactId() + "-" + version;
        }
        return finalName;
    }

    public static List<Artifact> createAttachedArtifacts(String dir, Artifact artifact, Model model) throws MojoExecutionException {
        String finalName;
        if (dir == null || dir.isEmpty()) {
            throw new IllegalArgumentException("dir is null or empty");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("artifact is null");
        }
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        String artifactName = "";
        if (artifact.getFile() != null && artifact.getFile().exists()) {
            artifactName = artifact.getFile().getName();
            finalName = artifactName.substring(0, artifactName.lastIndexOf(46));
        } else {
            finalName = MavenHelper.getFinalName(model);
        }
        List<File> attachedFiles = MavenHelper.getFiles(dir, finalName + "*.*", artifactName);
        ArrayList<Artifact> attachedArtifacts = new ArrayList<Artifact>();
        if (!attachedFiles.isEmpty()) {
            for (File attached : attachedFiles) {
                String classifier;
                String tokens = attached.getName().substring(finalName.length());
                if (tokens.endsWith(".pom")) continue;
                String type = tokens.endsWith(".asc") ? tokens.substring(tokens.substring(0, tokens.length() - ".asc".length()).lastIndexOf(46) + 1, tokens.length()) : tokens.substring(tokens.lastIndexOf(46) + 1, tokens.length());
                if (tokens.endsWith(".pom.asc")) {
                    classifier = "";
                } else {
                    classifier = tokens.substring(tokens.lastIndexOf(45) + 1, tokens.length() - (type.length() + 1));
                    if (classifier.contains(artifact.getVersion())) {
                        classifier = classifier.substring(classifier.indexOf(artifact.getVersion() + 1, classifier.length() - artifact.getVersion().length()));
                    }
                }
                Artifact attachedArtifact = MavenHelper.createArtifact(model, type, classifier);
                attachedArtifact.setFile(attached);
                attachedArtifacts.add(attachedArtifact);
            }
        }
        return attachedArtifacts;
    }

    private static Artifact getArtifactFile(String dir, String finalName, Model model) throws MojoExecutionException {
        if (dir == null || dir.isEmpty()) {
            throw new IllegalArgumentException("dir is null or empty");
        }
        if (finalName == null || finalName.isEmpty()) {
            throw new IllegalArgumentException("finalName is null");
        }
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        List<File> files = MavenHelper.getFiles(dir, finalName + ".*", finalName + "-*.");
        HashMap<String, File> extensionMap = new HashMap<String, File>(files.size());
        for (File file : files) {
            extensionMap.put(file.getName().substring(finalName.length() + 1), file);
        }
        File artifactFile = (File)extensionMap.get(model.getPackaging());
        if (artifactFile != null) {
            Artifact artifact = MavenHelper.createArtifact(model);
            artifact.setFile(artifactFile);
            return artifact;
        }
        for (String ext : extensionMap.keySet()) {
            if (ext.equals("pom") || ext.endsWith(".asc")) continue;
            Artifact artifact = MavenHelper.createArtifact(model, ext, null);
            artifact.setFile((File)extensionMap.get(ext));
            return artifact;
        }
        return null;
    }

    public static Artifact createArtifact(String dir, Model model) throws MojoExecutionException {
        Artifact artifact = MavenHelper.getArtifactFile(dir, MavenHelper.getFinalName(model), model);
        if (artifact == null) {
            artifact = MavenHelper.getArtifactFile(dir, model.getArtifactId(), model);
        }
        return artifact;
    }

    public static File getPomInTarget(String dir) throws MojoExecutionException {
        List<File> poms = MavenHelper.getFiles(dir, "*.pom", "");
        if (!poms.isEmpty()) {
            return poms.get(0);
        }
        return null;
    }

    public static List<File> getFiles(String dirPath, String includes, String excludes) throws MojoExecutionException {
        if (dirPath == null || dirPath.isEmpty()) {
            throw new IllegalArgumentException("dir is null or empty");
        }
        File dir = new File(dirPath);
        if (dir.exists() && dir.isDirectory()) {
            try {
                return FileUtils.getFiles((File)dir, (String)includes, (String)excludes);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static Artifact createArtifact(String groupId, String artifactId, String version, String type, String classifier) {
        return new org.apache.maven.artifact.DefaultArtifact(groupId, artifactId, VersionRange.createFromVersion((String)version), "runtime", type, classifier, (ArtifactHandler)new DefaultArtifactHandler(type));
    }

    public static Artifact createArtifact(Model model, String type, String classifier) {
        String version;
        String groupId = model.getGroupId();
        if (groupId == null) {
            if (model.getParent() == null) {
                throw new IllegalStateException("groupId is null and parent is null");
            }
            groupId = model.getParent().getGroupId();
        }
        if ((version = model.getVersion()) == null) {
            if (model.getParent() == null) {
                throw new IllegalStateException("version is null and parent is null");
            }
            version = model.getParent().getVersion();
        }
        return MavenHelper.createArtifact(groupId, model.getArtifactId(), version, type, classifier);
    }

    public static Artifact createArtifact(Model model) {
        return MavenHelper.createArtifact(model, model.getPackaging(), null);
    }

    public static Artifact createArtifact(String groupId, String artifactId, String version, String type) {
        return MavenHelper.createArtifact(groupId, artifactId, version, type, null);
    }

    public static Artifact createArtifact(Dependency dep) {
        return MavenHelper.createArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), dep.getClassifier());
    }

    public static void writePom(Model model, File buildDir) throws IOException {
        MavenHelper.writePom(model, buildDir, null);
    }

    public static void writePom(Model model, File buildDir, String pomFileName) throws IOException {
        String pom = pomFileName == null ? (model.getBuild() != null && model.getBuild().getFinalName() != null ? model.getBuild().getFinalName() + ".pom" : "pom.xml") : pomFileName;
        File pomFile = new File(buildDir, pom);
        new DefaultModelWriter().write(pomFile, null, model);
        model.setPomFile(pomFile);
    }

    public static String modelAsString(Model model) throws MojoExecutionException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new DefaultModelWriter().write((OutputStream)baos, null, model);
            return new String(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    public static Set<Artifact> filterArtifacts(Set<Artifact> artifacts, Set<Artifact> dependencyArtifacts, boolean excludeTransitive, String includeScope, String excludeScope, String excludeTypes, String includeTypes) throws MojoExecutionException {
        return MavenHelper.filterArtifacts(artifacts, dependencyArtifacts, excludeTransitive, includeScope, excludeScope, includeTypes, excludeTypes, null, null, null, null, null, null);
    }

    public static Set<Artifact> excludeTransitive(Set<Artifact> artifacts, Set<Artifact> dependencyArtifacts) throws MojoExecutionException {
        return MavenHelper.filterArtifacts(artifacts, dependencyArtifacts, true, null, null, null, null, null, null, null, null, null, null);
    }

    public static Set<Artifact> filterArtifacts(Set<Artifact> artifacts, Set<Artifact> dependencyArtifacts, boolean excludeTransitive, String includeScope, String excludeScope, String excludeTypes, String includeTypes, String includeClassifiers, String excludeClassifiers, String includeGroupIds, String excludeGroupIds, String includeArtifactIds, String excludeArtifactIds) throws MojoExecutionException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ProjectTransitivityFilter(dependencyArtifacts, excludeTransitive));
        filter.addFilter((ArtifactsFilter)new ScopeFilter(MavenHelper.cleanToBeTokenizedString(includeScope), MavenHelper.cleanToBeTokenizedString(excludeScope)));
        filter.addFilter((ArtifactsFilter)new TypeFilter(MavenHelper.cleanToBeTokenizedString(includeTypes), MavenHelper.cleanToBeTokenizedString(excludeTypes)));
        filter.addFilter((ArtifactsFilter)new ClassifierFilter(MavenHelper.cleanToBeTokenizedString(includeClassifiers), MavenHelper.cleanToBeTokenizedString(excludeClassifiers)));
        filter.addFilter((ArtifactsFilter)new GroupIdFilter(MavenHelper.cleanToBeTokenizedString(includeGroupIds), MavenHelper.cleanToBeTokenizedString(excludeGroupIds)));
        filter.addFilter((ArtifactsFilter)new ArtifactIdFilter(MavenHelper.cleanToBeTokenizedString(includeArtifactIds), MavenHelper.cleanToBeTokenizedString(excludeArtifactIds)));
        try {
            return filter.filter(artifacts);
        }
        catch (ArtifactFilterException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public static void unpack(File file, File location, String includes, String excludes, boolean silent, Log log, ArchiverManager archiverManager) throws MojoExecutionException {
        if (log != null && log.isInfoEnabled() && !silent) {
            log.info((CharSequence)MavenHelper.logUnpack(file, location, includes, excludes));
        }
        location.mkdirs();
        try {
            UnArchiver unArchiver = archiverManager.getUnArchiver(file);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            if (StringUtils.isNotEmpty((String)excludes) || StringUtils.isNotEmpty((String)includes)) {
                IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
                if (StringUtils.isNotEmpty((String)excludes)) {
                    selectors[0].setExcludes(excludes.split(","));
                }
                if (StringUtils.isNotEmpty((String)includes)) {
                    selectors[0].setIncludes(includes.split(","));
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
            }
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + location + "\r\n" + e.toString(), (Exception)((Object)e));
        }
    }

    private static String logUnpack(File file, File location, String includes, String excludes) {
        StringBuilder msg = new StringBuilder();
        msg.append("Unpacking ");
        msg.append(file);
        msg.append(" to ");
        msg.append(location);
        if (includes != null && excludes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\" and excludes \"");
            msg.append(excludes);
            msg.append("\"");
        } else if (includes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\"");
        } else if (excludes != null) {
            msg.append(" with excludes \"");
            msg.append(excludes);
            msg.append("\"");
        }
        return msg.toString();
    }

    public static ArtifactResult resolveArtifact(String groupId, String artifactId, String classifier, String type, String version, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) throws MojoExecutionException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(groupId, artifactId, classifier, type, version));
        request.setRepositories(remoteRepos);
        try {
            result = repoSystem.resolveArtifact(repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return result;
    }

    public static String cleanToBeTokenizedString(String str) {
        String ret = "";
        if (!StringUtils.isEmpty((String)str)) {
            ret = str.trim().replaceAll("[\\s]*,[\\s]*", ",");
        }
        return ret;
    }

    public static void writeFile(File outfile, StringBuilder input) throws IOException {
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)outfile);
        try {
            IOUtil.copy((String)input.toString(), (Writer)writer);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    public static List<String> getCommaSeparatedList(String list) {
        String[] listArray;
        if (list != null && (listArray = list.split(",")) != null) {
            return Arrays.asList(listArray);
        }
        return Collections.EMPTY_LIST;
    }

    private static String listToString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static ZipFileSet createZipFileSet(File dir, List<String> includes, List<String> excludes) {
        return MavenHelper.createZipFileSet(dir, MavenHelper.listToString(includes), MavenHelper.listToString(excludes));
    }

    public static ZipFileSet createZipFileSet(File dir, String includePatterns, String excludePatterns) {
        String includes = includePatterns;
        if (includePatterns == null) {
            includes = "";
        }
        String excludes = excludePatterns;
        if (excludePatterns == null) {
            excludes = "";
        }
        ZipFileSet fset = new ZipFileSet();
        fset.setDir(dir);
        fset.setIncludes(includes);
        fset.setExcludes(excludes);
        fset.setDescription(String.format("file set: %s ( excludes: [ %s ], includes: [ %s ])", dir.getAbsolutePath(), excludes, includes));
        return fset;
    }

    public static File createZip(Properties props, Log log, String duplicate, List<ZipFileSet> fsets, File target) {
        ZipHelper.getInstance().zip(props, log, duplicate, fsets, target);
        return target;
    }
}

