/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

final class MavenModelResolver
implements ModelResolver {
    private final List<RemoteRepository> repositories;
    private final Set<String> repositoryIds;
    private final RepositorySystem system;
    private final RepositorySystemSession session;

    MavenModelResolver(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) {
        this.system = repoSystem;
        this.session = repoSession;
        this.repositories = new ArrayList<RemoteRepository>(remoteRepos);
        this.repositoryIds = new HashSet<String>();
        for (RemoteRepository repository : this.repositories) {
            this.repositoryIds.add(repository.getId());
        }
    }

    private MavenModelResolver(MavenModelResolver clone) {
        this.system = clone.system;
        this.session = clone.session;
        this.repositories = new ArrayList<RemoteRepository>(clone.repositories);
        this.repositoryIds = new HashSet<String>(clone.repositoryIds);
    }

    public void addRepository(Repository repository, boolean replace) throws InvalidRepositoryException {
        if (!replace && this.repositoryIds.contains(repository.getId())) {
            return;
        }
        if (!this.repositoryIds.add(repository.getId())) {
            return;
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ArtifactDescriptorUtils.toRemoteRepository((Repository)repository));
        this.repositoryIds.add(repository.getId());
        this.repositories.addAll(newRepositories);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        this.addRepository(repository, false);
    }

    public ModelResolver newCopy() {
        return new MavenModelResolver(this);
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest((Artifact)artifact, this.repositories, null);
            artifact = this.system.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException(String.format("Failed to resolve POM for %s:%s:%s due to %s", groupId, artifactId, version, e.getMessage()), groupId, artifactId, version, (Throwable)e);
        }
        return new FileModelSource(artifact.getFile());
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        return this.resolveModel(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
    }
}

