/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.utils;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;
import org.glassfish.build.utils.MavenHelper;

final class ZipHelper {
    private ZipHelper() {
    }

    static ZipHelper getInstance() {
        return LazyHolder.INSTANCE;
    }

    void zip(Properties properties, Log mavenLog, String duplicate, List<ZipFileSet> fsets, File target) {
        Project antProject = new Project();
        antProject.addBuildListener((BuildListener)new AntBuildListener(mavenLog));
        for (String string : properties.keySet()) {
            antProject.setProperty(string, properties.getProperty(string));
        }
        Zip zip = new Zip();
        zip.setProject(antProject);
        zip.setDestFile(target);
        Zip.Duplicate df = new Zip.Duplicate();
        df.setValue(duplicate);
        zip.setDuplicate(df);
        mavenLog.info((CharSequence)String.format("[zip] duplicate: %s", duplicate));
        List<ZipFileSet> filesets = fsets == null ? Collections.EMPTY_LIST : fsets;
        if (filesets.isEmpty()) {
            ZipFileSet zfs = MavenHelper.createZipFileSet(new File(""), "", "");
            zfs.setDirMode("755");
            zfs.setFileMode("644");
            filesets.add(zfs);
        }
        for (ZipFileSet fset : filesets) {
            zip.addZipfileset(fset);
            String desc = fset.getDescription();
            if (desc == null || desc.isEmpty()) continue;
            mavenLog.info((CharSequence)String.format("[zip] %s", desc));
        }
        zip.executeMain();
    }

    private static final class AntBuildListener
    implements BuildListener {
        private static final int MAX_EVENT_PRIORITY = 3;
        private final Log log;

        private AntBuildListener(Log mavenLog) {
            this.log = mavenLog;
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if (event.getPriority() < 3) {
                this.log.info((CharSequence)String.format("[zip] %s", event.getMessage()));
            } else {
                this.log.debug((CharSequence)String.format("[zip] %s", event.getMessage()));
            }
        }
    }

    private static class LazyHolder {
        static final ZipHelper INSTANCE = new ZipHelper();

        private LazyHolder() {
        }
    }
}

