/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.build;

import com.sun.enterprise.build.AbstractGlassfishMojo;
import com.sun.enterprise.build.DistributionVisitor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionDashboardMojo
extends AbstractGlassfishMojo {
    protected MavenProjectHelper projectHelper;
    protected ArtifactFactory artifactFactory;
    protected File outputDirectory;
    protected String finalName;
    protected String generatorName;
    protected Map<String, List<Artifact>> dependentsXRef = null;
    protected final Pattern scmURLPattern = Pattern.compile("scm:([^:]*):(.*)");

    public void execute() throws MojoExecutionException, MojoFailureException {
        Object o;
        Set<Artifact> ourArtifacts = this.findArtifactsOfScope(this.project.getArtifacts(), "compile");
        this.initXRefs(ourArtifacts);
        this.outputDirectory.mkdirs();
        File target = new File(this.outputDirectory, this.finalName);
        this.getLog().info((CharSequence)("Creating the wiki page with " + this.generatorName));
        try {
            Class<?> c = Class.forName(this.generatorName);
            o = c.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)("Generator " + this.generatorName + " not found, aborting"));
            return;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Cannot instantiate generator " + this.generatorName));
            return;
        }
        DistributionVisitor generator = (DistributionVisitor)DistributionVisitor.class.cast(o);
        try {
            HashMap<String, ArrayList<Artifact>> modules = new HashMap<String, ArrayList<Artifact>>();
            ArrayList<Artifact> libraries = new ArrayList<Artifact>();
            for (Artifact a : ourArtifacts) {
                if (this.isModule(a)) {
                    String key = a.getGroupId().substring(0, a.getGroupId().lastIndexOf(46));
                    ArrayList<Artifact> values = (ArrayList<Artifact>)modules.get(key);
                    if (values == null) {
                        values = new ArrayList<Artifact>();
                        modules.put(key, values);
                    }
                    values.add(a);
                    continue;
                }
                libraries.add(a);
            }
            PrintWriter writer = new PrintWriter(new FileWriter(target));
            generator.beginDistribution(writer, this.project);
            generator.beginCategory("Modules");
            for (Map.Entry item : modules.entrySet()) {
                if (((List)item.getValue()).isEmpty()) continue;
                this.dumpArtifacts(generator, (List)item.getValue(), false);
            }
            generator.endCategory();
            if (!libraries.isEmpty()) {
                generator.beginCategory("Libraries");
                this.dumpArtifacts(generator, libraries, true);
                generator.endCategory();
            }
            generator.endDistribution();
            writer.close();
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
        this.getLog().info((CharSequence)"done...");
        this.project.getArtifact().setFile(target);
    }

    private void dumpArtifacts(DistributionVisitor generator, List<Artifact> artifacts, boolean showGroup) throws IOException {
        generator.beginGroup(artifacts.get(0).getGroupId(), showGroup);
        for (Artifact module : artifacts) {
            generator.beginArtifact(module);
            generator.addSize(module.getFile().length());
            try {
                MavenProject moduleProject = null;
                try {
                    moduleProject = this.loadPom(module);
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Cannot load pom for " + module.getId()));
                }
                if (moduleProject != null) {
                    HashMap<String, ArtifactRepository> repos = new HashMap<String, ArtifactRepository>();
                    for (ArtifactRepository repo : this.project.getRemoteArtifactRepositories()) {
                        repos.put(repo.getUrl(), repo);
                    }
                    for (ArtifactRepository repo : moduleProject.getRemoteArtifactRepositories()) {
                        repos.put(repo.getUrl(), repo);
                    }
                    boolean found = false;
                    if (moduleProject.getDistributionManagementArtifactRepository() != null) {
                        String publishRepoID = moduleProject.getDistributionManagementArtifactRepository().getId();
                        for (ArtifactRepository repo : repos.values()) {
                            if (!repo.getId().equals(publishRepoID)) continue;
                            generator.addRepository(repo);
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        for (ArtifactRepository repo : repos.values()) {
                            HttpURLConnection httpConnection;
                            String tentativeLocation = repo.getUrl() + "/" + repo.pathOf(module);
                            URL tentativeURL = new URL(tentativeLocation);
                            URLConnection connection = tentativeURL.openConnection();
                            connection.connect();
                            if (!(connection instanceof HttpURLConnection) || (httpConnection = (HttpURLConnection)connection).getResponseCode() != 200) continue;
                            generator.addRepository(repo);
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        generator.addRepository(null);
                    }
                    generator.addDevelopers(moduleProject.getDevelopers());
                    generator.addMailingLists(moduleProject.getMailingLists());
                    generator.addImports(this.filterImports(moduleProject.getModel().getDependencies()));
                    generator.addImportedBy(this.getImporting(module));
                    if (moduleProject.getScm() == null) {
                        MavenProject parentProject = moduleProject;
                        while (parentProject.hasParent()) {
                            parentProject = parentProject.getParent();
                        }
                        generator.addSCM(parentProject.getModel().getScm());
                    } else {
                        generator.addSCM(moduleProject.getModel().getScm());
                    }
                    generator.addLicenses(moduleProject.getLicenses());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            generator.endArtifact();
        }
        generator.endGroup();
    }

    private List<Dependency> filterImports(List<Dependency> dependencies) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency artifact : dependencies) {
            if (artifact.getScope() == null) {
                result.add(artifact);
                continue;
            }
            if (artifact.getScope().equals("test") || artifact.getScope().equals("compile") && artifact.isOptional()) continue;
            result.add(artifact);
        }
        return result;
    }

    protected void initXRefs(Set<Artifact> modules) {
        this.dependentsXRef = new HashMap<String, List<Artifact>>();
        for (Artifact module : modules) {
            List moduleDeps;
            System.out.println("Importing module " + module.getId());
            MavenProject moduleProject = null;
            try {
                moduleProject = this.loadPom(module);
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("cannot load " + module.getId()));
            }
            if (moduleProject == null || (moduleDeps = moduleProject.getModel().getDependencies()) == null) continue;
            for (Dependency moduleDep : moduleDeps) {
                String depKey = moduleDep.getGroupId() + ":" + moduleDep.getArtifactId();
                List<Artifact> importing = this.dependentsXRef.get(depKey);
                if (importing == null) {
                    importing = new ArrayList<Artifact>();
                    this.dependentsXRef.put(depKey, importing);
                }
                importing.add(module);
            }
        }
    }

    protected List<Artifact> getImporting(Artifact module) {
        if (this.dependentsXRef == null) {
            return null;
        }
        return this.dependentsXRef.get(module.getGroupId() + ":" + module.getArtifactId());
    }

    protected String getSCMType(String scmConnection) {
        Matcher m = this.scmURLPattern.matcher(scmConnection);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    protected String getSCMSpecficPart(String scmConnection) {
        Matcher m = this.scmURLPattern.matcher(scmConnection);
        if (m.matches()) {
            return m.group(2);
        }
        return null;
    }
}

