/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.build;

import com.sun.enterprise.build.AbstractGlassfishMojo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeMojo
extends AbstractGlassfishMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<String, Dep> ndd = this.determineAllNonDirectDependencies();
        boolean foundIssue = false;
        for (Dependency d : this.project.getDependencies()) {
            Dep dep = ndd.get(this.toKey(d));
            if (dep == null) continue;
            this.getLog().warn((CharSequence)("Dependency " + d + " is redundant. It's included through" + dep.trail));
            foundIssue = true;
        }
        if (!foundIssue) {
            this.getLog().info((CharSequence)"No redundant dependency found");
        }
    }

    private Map<String, Dep> determineAllNonDirectDependencies() throws MojoExecutionException {
        HashMap<String, Dep> m = new HashMap<String, Dep>();
        for (Artifact a : this.project.getArtifacts()) {
            try {
                MavenProject p = this.loadPom(a);
                for (Dependency d : p.getDependencies()) {
                    if (d.isOptional() || d.getScope() != null && d.getScope().equals("test")) continue;
                    m.put(this.toKey(d), new Dep(d, a));
                }
            }
            catch (ProjectBuildingException e) {
                throw new MojoExecutionException("Failed to resolve " + a, (Exception)((Object)e));
            }
        }
        return m;
    }

    private String toKey(Dependency d) {
        return d.getGroupId() + ':' + d.getArtifactId();
    }

    private static class Dep {
        final List<String> trail;

        public Dep(Dependency d, Artifact a) {
            this.trail = a.getDependencyTrail();
        }
    }
}

