/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.build;

import com.sun.enterprise.build.DistributionVisitor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardWikiGenerator
implements DistributionVisitor {
    String category = null;
    PrintWriter writer = null;
    boolean groupInTable = false;
    Artifact module;
    MavenProject distribution;
    List<String> footNotes = new ArrayList<String>();
    protected final Pattern scmURLPattern = Pattern.compile("scm:([^:]*):(.*)");

    @Override
    public void beginDistribution(PrintWriter writer, MavenProject distribution) {
        this.writer = writer;
        this.distribution = distribution;
        writer.append("!!! Dashboard for the ").append(distribution.getArtifactId()).append(":").append(distribution.getVersion()).println(" Distribution");
    }

    @Override
    public void beginCategory(String categoryName) {
        this.writer.println("!! " + categoryName + " List");
    }

    @Override
    public void beginGroup(String groupName, boolean inTable) {
        this.groupInTable = inTable;
        if (!this.groupInTable) {
            this.writer.append("! Group : ").println(groupName);
        }
        this.writer.println("%%sortable");
        if (this.groupInTable) {
            this.writer.append("|| group-id");
        }
        this.writer.println("|| module-id || version || size || repository || lead || mailing-lists || imports || importedBy || SCM || license");
    }

    @Override
    public void beginArtifact(Artifact artifact) {
        this.module = artifact;
        if (this.groupInTable) {
            this.writer.write("|" + artifact.getGroupId());
        }
        this.writer.append("| <a name=\"").append(artifact.getArtifactId()).append("\"/>").append(artifact.getArtifactId()).append("|").append(artifact.getVersion());
    }

    @Override
    public void addSize(long size) {
        this.writer.append("| ").append(String.valueOf(size / 1024L)).append(" KB");
    }

    @Override
    public void addRepository(ArtifactRepository repository) {
        if (repository != null) {
            this.writer.append(" | [").append(repository.getId()).append("|").append(repository.getUrl()).append("/").append(this.artifactToPath(this.module)).append("]");
        } else {
            this.writer.write(" | unknown");
        }
    }

    @Override
    public void addDevelopers(List<Developer> devs) {
        boolean foundLead = false;
        block0: for (Developer dev : devs) {
            for (String role : dev.getRoles()) {
                if (!"lead".equalsIgnoreCase(role)) continue;
                foundLead = true;
                if (dev.getUrl() != null) {
                    this.writer.append("| [").append(dev.getName()).append("|").append(dev.getUrl()).append("]");
                    continue block0;
                }
                this.writer.append("|").append(dev.getName());
                continue block0;
            }
        }
        if (!foundLead) {
            this.writer.write("| no owner");
        }
    }

    @Override
    public void addMailingLists(List<MailingList> mailingLists) {
        if (mailingLists.isEmpty()) {
            this.writer.write("| none");
        } else {
            this.writer.write("|");
            for (MailingList mailingList : mailingLists) {
                this.writer.append(" [").append(mailingList.getName()).append("|").append(mailingList.getArchive()).append("]\\\\");
            }
        }
    }

    @Override
    public void addImports(List<Dependency> dependencies) {
        this.writer.write(" | ");
        if (dependencies != null) {
            for (Dependency moduleDep : dependencies) {
                this.writer.append("<a href=#").append(moduleDep.getArtifactId()).append(">").append(moduleDep.getArtifactId()).append(":").append(moduleDep.getVersion()).append("</a>\\\\");
            }
        }
    }

    @Override
    public void addImportedBy(List<Artifact> importers) {
        this.writer.write(" | ");
        if (importers == null || importers.isEmpty()) {
            this.writer.append(this.distribution.getArtifactId()).append(":").append(this.distribution.getVersion());
        } else {
            for (Artifact importer : importers) {
                this.writer.write(" <a href=#" + importer.getArtifactId() + ">" + importer.getArtifactId() + ":" + importer.getVersion() + "</a>\\\\");
            }
        }
    }

    @Override
    public void addSCM(Scm scm) {
        if (scm != null) {
            String scmType = this.getSCMType(scm.getConnection());
            if (scmType.equals("hg")) {
                String scmSpecificPart = this.getSCMSpecficPart(scm.getConnection());
                this.writer.append("| [").append(scmType).append("|").append(scmSpecificPart).append("]");
            } else {
                int insertionIndex;
                String group = this.module.getGroupId().substring(this.module.getGroupId().lastIndexOf(46) + 1);
                String subProjectScm = this.module.getArtifactId() + "/" + group + "/" + this.module.getArtifactId();
                String proposedScm = scm.getConnection().substring(4);
                if (proposedScm.endsWith(subProjectScm)) {
                    proposedScm = proposedScm.substring(0, proposedScm.length() - subProjectScm.length());
                }
                if (this.footNotes.contains(proposedScm)) {
                    insertionIndex = this.footNotes.indexOf(proposedScm);
                } else {
                    this.footNotes.add(proposedScm);
                    insertionIndex = this.footNotes.size();
                }
                this.writer.write("|[" + insertionIndex + "]");
            }
        } else {
            this.writer.write("| unknown");
        }
    }

    @Override
    public void addLicenses(List<License> licenses) {
        this.writer.write("|");
        if (licenses == null || licenses.isEmpty()) {
            this.writer.write("unknown");
        } else {
            for (License license : licenses) {
                this.writer.append("[").append(license.getName()).append("|").append(license.getUrl()).append("]\\\\");
            }
        }
    }

    @Override
    public void endArtifact() {
        this.writer.println();
    }

    @Override
    public void endGroup() {
        this.writer.println("%%");
    }

    @Override
    public void endCategory() {
    }

    @Override
    public void endDistribution() {
        int index = 1;
        for (String footNote : this.footNotes) {
            this.writer.append("[#").append(String.valueOf(index++)).append("]").append(footNote).append("\\\\").println();
        }
        this.writer.println();
        this.writer.append("Generated by ").append(System.getProperty("user.name")).append(" on ").append(Calendar.getInstance().getTime().toString());
    }

    private String artifactToPath(Artifact a) {
        return a.getGroupId().replace('.', '/') + "/" + a.getArtifactId() + "/" + a.getVersion();
    }

    protected String getSCMType(String scmConnection) {
        Matcher m = this.scmURLPattern.matcher(scmConnection);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    protected String getSCMSpecficPart(String scmConnection) {
        Matcher m = this.scmURLPattern.matcher(scmConnection);
        if (m.matches()) {
            return m.group(2);
        }
        return null;
    }
}

