/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.build;

import com.sun.enterprise.build.AbstractGlassfishMojo;
import com.sun.enterprise.build.DistributionArtifactHandler;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionAssemblyMojo
extends AbstractGlassfishMojo {
    protected File outputDirectory;
    protected String finalName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set artifacts = this.project.getArtifacts();
        Set<Artifact> images = this.findArtifactsOfType(artifacts, "zip");
        Artifact baseImage = this.findBaseImage(images);
        Set<Artifact> modules = this.findArtifactsOfScope(artifacts, "runtime");
        this.outputDirectory.mkdirs();
        Zip zip = new Zip();
        zip.setProject(new Project());
        File target = new File(this.outputDirectory, this.finalName);
        zip.setDestFile(target);
        ZipFileSet zfs = new ZipFileSet();
        zfs.setSrc(baseImage.getFile());
        zfs.setDirMode("755");
        zfs.setFileMode("644");
        zip.addZipfileset(zfs);
        for (Artifact a : modules) {
            zfs = new ZipFileSet();
            zfs.setFile(a.getFile());
            zfs.setPrefix("glassfish/modules");
            zip.addZipfileset(zfs);
        }
        this.getLog().info((CharSequence)"Creating the distribution");
        long time = System.currentTimeMillis();
        zip.execute();
        this.getLog().info((CharSequence)("Packaging took " + (System.currentTimeMillis() - time) + "ms"));
        this.project.getArtifact().setFile(target);
        this.project.getArtifact().setArtifactHandler((ArtifactHandler)new DistributionArtifactHandler());
    }

    private Artifact findBaseImage(Set<Artifact> images) throws MojoExecutionException {
        if (images.isEmpty()) {
            throw new MojoExecutionException("No base image zip dependency is given");
        }
        HashSet<Artifact> shortest = new HashSet<Artifact>();
        int shortestLen = Integer.MAX_VALUE;
        for (Artifact a : images) {
            int l = a.getDependencyTrail().size();
            if (l < shortestLen) {
                shortest.clear();
                shortestLen = l;
            }
            if (l != shortestLen) continue;
            shortest.add(a);
        }
        if (shortest.size() > 1) {
            throw new MojoExecutionException("More than one base image zip dependency is specified: " + shortest);
        }
        return (Artifact)shortest.iterator().next();
    }
}

