/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.build;

import com.sun.enterprise.build.DistributionVisitor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Developer;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributorsWikiGenerator
implements DistributionVisitor {
    PrintWriter writer = null;
    MavenProject distribution;
    Artifact currentArtifact;
    Map<String, Developer> contributors = new HashMap<String, Developer>();
    Map<String, List<Artifact>> contributorProjects = new HashMap<String, List<Artifact>>();

    @Override
    public void beginDistribution(PrintWriter writer, MavenProject distribution) {
        this.writer = writer;
        this.distribution = distribution;
        writer.append("!!! Contributors list for the ").append(distribution.getArtifactId()).append(":").append(distribution.getVersion()).println(" Distribution");
        writer.println("%%sortable");
        writer.println("|| module-id || version || lead || developers");
    }

    @Override
    public void beginCategory(String categoryName) {
    }

    @Override
    public void beginGroup(String groupName, boolean inTable) {
    }

    @Override
    public void beginArtifact(Artifact artifact) {
        this.writer.append("| <a name=\"").append(artifact.getArtifactId()).append("\"/>").append(artifact.getGroupId() + ":" + artifact.getArtifactId()).append("|").append(artifact.getVersion());
        this.currentArtifact = artifact;
    }

    @Override
    public void addSize(long size) {
    }

    @Override
    public void addRepository(ArtifactRepository repository) {
    }

    private void addDeveloperXRef(Developer dev, Artifact artifact) {
        List<Artifact> artifacts = this.contributorProjects.get(dev.getName());
        if (artifacts == null) {
            artifacts = new ArrayList<Artifact>();
            this.contributorProjects.put(dev.getName(), artifacts);
        }
        if (!artifacts.contains(artifact)) {
            artifacts.add(artifact);
        }
        this.contributors.put(dev.getName(), dev);
    }

    @Override
    public void addDevelopers(List<Developer> devs) {
        boolean foundLead = false;
        block0: for (Developer dev : devs) {
            for (String role : dev.getRoles()) {
                if (!"lead".equalsIgnoreCase(role)) continue;
                foundLead = true;
                String title = dev.getName();
                if (dev.getOrganization() != null && !dev.getOrganization().startsWith("Sun")) {
                    title = title + "(" + dev.getOrganization() + ")";
                }
                if (dev.getUrl() != null) {
                    this.writer.append("| [").append(title).append("|").append(dev.getUrl()).append("]");
                } else {
                    this.writer.append("|").append(title);
                }
                this.addDeveloperXRef(dev, this.currentArtifact);
                continue block0;
            }
        }
        if (!foundLead) {
            this.writer.append("| Unknown");
        }
        boolean foundDev = false;
        this.writer.append("| ");
        for (Developer dev : devs) {
            for (String role : dev.getRoles()) {
                if (!"developer".equalsIgnoreCase(role)) continue;
                foundDev = true;
                String title = dev.getName();
                if (dev.getOrganization() != null && !dev.getOrganization().startsWith("Sun")) {
                    title = title + "(" + dev.getOrganization() + ")";
                }
                if (dev.getUrl() != null) {
                    this.writer.append("[").append(title).append("|").append(dev.getUrl()).append("]");
                } else {
                    this.writer.append(title);
                }
                this.writer.append("\\\\");
                this.addDeveloperXRef(dev, this.currentArtifact);
            }
        }
        if (!foundDev) {
            this.writer.append("Unknown");
        }
    }

    @Override
    public void addMailingLists(List<MailingList> lists) {
    }

    @Override
    public void addImports(List<Dependency> dependencies) {
    }

    @Override
    public void addImportedBy(List<Artifact> importers) {
    }

    @Override
    public void addSCM(Scm scm) {
    }

    @Override
    public void addLicenses(List<License> licenses) {
    }

    @Override
    public void endArtifact() {
        this.writer.println();
    }

    @Override
    public void endGroup() {
    }

    @Override
    public void endCategory() {
    }

    @Override
    public void endDistribution() {
        Developer dev;
        String devName;
        this.writer.println();
        this.writer.append("!! List of project per contributors ").append(this.distribution.getArtifactId()).append(":").append(this.distribution.getVersion()).println(" Distribution");
        this.writer.append("! Sun Contributors");
        this.writer.println("%%sortable");
        this.writer.println("|| name || module-id");
        for (Map.Entry<String, List<Artifact>> entry : this.contributorProjects.entrySet()) {
            devName = entry.getKey();
            dev = this.contributors.get(devName);
            if (dev.getOrganization() != null && !dev.getOrganization().startsWith("Sun")) continue;
            this.writer.append("| " + devName + " | ");
            for (Artifact module : entry.getValue()) {
                this.writer.append("<a href=#").append(module.getArtifactId()).append(">").append(module.getGroupId()).append(":").append(module.getArtifactId()).append("</a>\\\\");
            }
            this.writer.println("");
        }
        this.writer.append("! External Contributors");
        this.writer.println("%%sortable");
        this.writer.println("|| name || company || module-id");
        for (Map.Entry<String, List<Artifact>> entry : this.contributorProjects.entrySet()) {
            devName = entry.getKey();
            dev = this.contributors.get(devName);
            if (dev.getOrganization() != null && dev.getOrganization().startsWith("Sun")) continue;
            this.writer.append("| " + devName + " | " + dev.getOrganization() + " | ");
            for (Artifact module : entry.getValue()) {
                this.writer.append("<a href=#").append(module.getArtifactId()).append(">").append(module.getGroupId()).append(":").append(module.getArtifactId()).append("</a>\\\\");
            }
            this.writer.println("");
        }
        this.writer.append("Generated by ").append(System.getProperty("user.name")).append(" on ").append(Calendar.getInstance().getTime().toString());
    }
}

