/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class Unpack200Mojo
extends AbstractMojo {
    private String sourceDirectory;
    private String outputDirectory;

    public void execute() throws MojoExecutionException {
        File destinationDir;
        File sourceDir = this.sourceDirectory != null && this.sourceDirectory.length() > 0 ? new File(this.sourceDirectory) : new File(System.getProperty("user.dir"));
        System.out.println("Source directory is " + this.sourceDirectory);
        System.out.println("Out is " + this.outputDirectory);
        Pack200.Unpacker unpkr = Pack200.newUnpacker();
        if (!sourceDir.exists()) {
            this.getLog().warn((CharSequence)("source directory " + sourceDir.getAbsolutePath() + "does not exist"));
            return;
        }
        if (this.outputDirectory == null) {
            this.outputDirectory = this.sourceDirectory;
        }
        if (!(destinationDir = new File(this.outputDirectory)).exists() && !destinationDir.mkdirs()) {
            throw new MojoExecutionException("Aborting - Cannot create destination directory " + destinationDir.getAbsolutePath());
        }
        for (File file : sourceDir.listFiles()) {
            if (file.isDirectory()) continue;
            try {
                BufferedInputStream is;
                block11: {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        FileType fileType = this.getMagic(file);
                        if (fileType == FileType.gzip) {
                            is = new BufferedInputStream(new GZIPInputStream(fis));
                            break block11;
                        }
                        if (fileType == FileType.pack200) {
                            is = new BufferedInputStream(fis);
                            break block11;
                        }
                        fis.close();
                    }
                    catch (IOException ioe) {
                        this.getLog().info((CharSequence)ioe.getMessage());
                    }
                    continue;
                }
                this.getLog().info((CharSequence)("Unpacking " + file.getName()));
                StringTokenizer stoken = new StringTokenizer(file.getName(), ".");
                String destFileName = stoken.nextToken() + ".";
                if (stoken.hasMoreElements()) {
                    destFileName = destFileName + stoken.nextToken();
                }
                FileOutputStream fos = new FileOutputStream(new File(destinationDir, destFileName));
                JarOutputStream jout = new JarOutputStream(new BufferedOutputStream(fos));
                unpkr.unpack((InputStream)is, jout);
                ((InputStream)is).close();
                jout.close();
                file.delete();
            }
            catch (IOException ioe) {
                throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
            }
        }
    }

    private FileType getMagic(File in) throws IOException {
        DataInputStream is = new DataInputStream(new FileInputStream(in));
        int i = is.readInt();
        is.close();
        if ((i & 0xFFFFFF00) == 529205248) {
            return FileType.gzip;
        }
        if (i == -889270259) {
            return FileType.pack200;
        }
        if (i == 1347093252) {
            return FileType.zip;
        }
        return FileType.unknown;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileType {
        unknown,
        gzip,
        pack200,
        zip;

    }
}

