/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Cvs;

public class CheckoutMojo
extends AbstractMojo {
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        try {
            String module = FileUtils.readFileToString((File)new File("./CVS/Repository")).trim();
            String cvsroot = FileUtils.readFileToString((File)new File("./CVS/Root")).trim();
            this.getLog().info((CharSequence)("CVSROOT=" + cvsroot));
            String currentTag = null;
            File tagFile = new File("./CVS/Tag");
            if (tagFile.exists() && (currentTag = FileUtils.readFileToString((File)tagFile).trim()).startsWith("T")) {
                currentTag = currentTag.substring(1);
            }
            this.getLog().info((CharSequence)("tag=" + currentTag));
            HashSet<String> modulesChecked = new HashSet<String>();
            for (String modulePath : this.project.getModules()) {
                this.getLog().debug((CharSequence)("module path = " + modulePath));
                int i = modulePath.indexOf("/");
                if (modulePath.startsWith("..") && i != -1 && (i = modulePath.indexOf("/", i + 1)) != -1) {
                    modulePath = modulePath.substring(0, i);
                }
                this.getLog().debug((CharSequence)("o = " + modulePath));
                if (!modulesChecked.add(modulePath)) {
                    this.getLog().debug((CharSequence)(modulePath + " already done"));
                    continue;
                }
                Cvs cvs = new Cvs();
                cvs.setTaskName("cvs");
                cvs.setProject(this.createAntProject());
                File moduleDir = new File(this.project.getBasedir(), modulePath).getCanonicalFile();
                if (new File(moduleDir, "CVS").exists()) {
                    this.getLog().info((CharSequence)("update  " + moduleDir));
                    cvs.setCommand("update");
                    cvs.setDest(moduleDir);
                } else {
                    this.getLog().info((CharSequence)("checkout " + moduleDir));
                    cvs.setCommand(currentTag == null ? "checkout" : "checkout -r " + currentTag);
                    cvs.setDest(this.project.getBasedir().getParentFile().getParentFile());
                    cvs.setCvsRoot(cvsroot);
                    cvs.setPackage(this.canonicalize(module + "/" + modulePath));
                }
                cvs.execute();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot run checkout command : ", (Exception)e);
        }
    }

    private String canonicalize(String s) {
        ArrayList<String> r = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(s, "/");
        while (tokens.hasMoreTokens()) {
            String t = tokens.nextToken();
            if (t.equals(".")) continue;
            if (t.equals("..")) {
                r.remove(r.size() - 1);
                continue;
            }
            r.add(t);
        }
        StringBuilder buf = new StringBuilder();
        for (String t : r) {
            if (buf.length() > 0) {
                buf.append('/');
            }
            buf.append(t);
        }
        return buf.toString();
    }

    private Project createAntProject() {
        Project project = new Project();
        DefaultLogger antLogger = new DefaultLogger();
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        antLogger.setMessageOutputLevel(this.getLog().isDebugEnabled() ? 4 : 2);
        project.addBuildListener((BuildListener)antLogger);
        return project;
    }
}

