/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.build;

import com.sun.enterprise.module.common_impl.Jar;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGlassfishMojo
extends AbstractMojo {
    protected MavenProject project;
    protected MavenProjectBuilder projectBuilder;

    AbstractGlassfishMojo() {
    }

    protected boolean isModule(Artifact a) throws MojoExecutionException {
        try {
            Jar jar = Jar.create((File)a.getFile());
            if (jar.getManifest() == null) {
                return false;
            }
            Attributes attributes = jar.getManifest().getMainAttributes();
            String name = attributes.getValue("Bundle-SymbolicName");
            return name != null;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to open " + a.getFile(), (Exception)e);
        }
    }

    protected MavenProject loadPom(Artifact artifact) throws ProjectBuildingException {
        return this.projectBuilder.buildFromRepository(artifact, this.project.getRemoteArtifactRepositories(), artifact.getRepository());
    }

    protected Set<Artifact> findArtifacts(Set<Artifact> artifacts, ArtifactFilter filter) {
        HashSet<Artifact> r = new HashSet<Artifact>();
        for (Artifact a : artifacts) {
            if (!filter.find(a)) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Including " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion()));
                this.getLog().debug((CharSequence)"From dependency trail : ");
                for (int i = a.getDependencyTrail().size() - 1; i >= 0; --i) {
                    this.getLog().debug((CharSequence)(" " + a.getDependencyTrail().get(i).toString()));
                }
                this.getLog().debug((CharSequence)"");
            }
            r.add(a);
        }
        return r;
    }

    protected Set<Artifact> findArtifactsOfType(Set<Artifact> artifacts, final String type) {
        return this.findArtifacts(artifacts, new ArtifactFilter(){

            public boolean find(Artifact a) {
                String t = a.getType();
                if (t == null) {
                    t = "jar";
                }
                return t.equals(type);
            }
        });
    }

    protected Set<Artifact> findArtifactsOfScope(Set<Artifact> artifacts, final String scope) {
        return this.findArtifacts(artifacts, new ArtifactFilter(){

            public boolean find(Artifact a) {
                String s = a.getScope();
                return s.equals(scope);
            }
        });
    }

    protected static interface ArtifactFilter {
        public boolean find(Artifact var1);
    }
}

