/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.build;

import com.sun.enterprise.build.AbstractGlassfishMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class SetPropertiesMojo
extends AbstractGlassfishMojo {
    private File[] files;
    private String[] filePaths;
    private boolean ignoreMissingFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties projectProperties = new Properties();
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            this.getLog().debug((CharSequence)("file = " + file));
            String propFileName = file.getName();
            MavenProject mp = this.project;
            File baseDir = mp.getBasedir();
            this.getLog().debug((CharSequence)(" propFileName = " + propFileName));
            while (baseDir != null && !new File(baseDir, propFileName).exists()) {
                mp = mp.getParent();
                baseDir = mp.getBasedir();
                this.getLog().debug((CharSequence)("mp.getBasedir() = " + mp.getBasedir()));
            }
            if (baseDir != null && new File(baseDir, propFileName).exists()) {
                file = new File(baseDir, propFileName);
                try {
                    this.getLog().debug((CharSequence)("Loading property file: " + file));
                    FileInputStream stream = new FileInputStream(file);
                    projectProperties = this.project.getProperties();
                    try {
                        projectProperties.load(stream);
                        continue;
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error reading properties file " + file.getAbsolutePath(), (Exception)e);
                }
            }
            if (this.ignoreMissingFile) {
                this.getLog().warn((CharSequence)("Ignoring missing properties file: " + file.getAbsolutePath()));
                continue;
            }
            throw new MojoExecutionException("Properties file not found: " + file.getAbsolutePath());
        }
    }
}

