/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Property;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-admin-object")
@Scoped(value=PerLookup.class)
@I18n(value="create.admin.object")
public class CreateAdminObject
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateAdminObject.class);
    @Param(name="restype")
    String resType;
    @Param(name="raname")
    String raName;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(optional=true)
    String description;
    @Param(name="property", optional=true)
    Properties properties;
    @Param(optional=true)
    String target = "server";
    @Param(name="jndi_name", primary=true)
    String jndiName;
    @Inject
    Resources resources;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Server targetServer = this.domain.getServerNamed(this.target);
        if (this.jndiName == null) {
            report.setMessage(localStrings.getLocalString("create.admin.object.noJndiName", "No JNDI name defined for administered object."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        for (Resource resource : this.resources.getResources()) {
            if (!(resource instanceof AdminObjectResource) || !((AdminObjectResource)resource).getJndiName().equals(this.jndiName)) continue;
            report.setMessage(localStrings.getLocalString("create.admin.object.duplicate", "An administered object named {0} already exists.", new Object[]{this.jndiName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    AdminObjectResource newResource = (AdminObjectResource)ConfigSupport.createChildOf((Object)param, AdminObjectResource.class);
                    newResource.setJndiName(CreateAdminObject.this.jndiName);
                    if (CreateAdminObject.this.description != null) {
                        newResource.setDescription(CreateAdminObject.this.description);
                    }
                    newResource.setResAdapter(CreateAdminObject.this.raName);
                    newResource.setResType(CreateAdminObject.this.resType);
                    newResource.setEnabled(CreateAdminObject.this.enabled.toString());
                    if (CreateAdminObject.this.properties != null) {
                        for (Map.Entry<Object, Object> e : CreateAdminObject.this.properties.entrySet()) {
                            Property prop = (Property)ConfigSupport.createChildOf((Object)newResource, Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newResource.getProperty().add(prop);
                        }
                    }
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)this.resources);
            if (!targetServer.isResourceRefExists(this.jndiName)) {
                targetServer.createResourceRef(this.enabled.toString(), this.jndiName);
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.admin.object.fail", "Unable to create administered object {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        report.setMessage(localStrings.getLocalString("create.admin.object.success", "Administered object {0} created.", new Object[]{this.jndiName}));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

