/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BackendPrincipal;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.SecurityMap;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.connectors.admin.cli.ConnectorSecurityMap;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-connector-security-maps")
@Scoped(value=PerLookup.class)
@I18n(value="list.connector.security.maps")
public class ListConnectorSecurityMaps
extends ConnectorSecurityMap
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListConnectorSecurityMaps.class);
    @Param(name="securitymap", optional=true)
    String securityMap;
    @Param(name="verbose", optional=true, defaultValue="false")
    Boolean verbose;
    @Param(name="pool-name", primary=true)
    String poolName;
    @Inject
    ConnectorConnectionPool[] ccPools;

    public void execute(AdminCommandContext context) {
        ActionReport report;
        block11: {
            report = context.getActionReport();
            ActionReport.MessagePart mp = report.getTopMessagePart();
            if (!this.doesPoolNameExist(this.poolName, this.ccPools)) {
                report.setMessage(localStrings.getLocalString("create.connector.security.map.noSuchPoolFound", "Specified connector connection pool {0} does not exist. Please specify a valid pool name.", new Object[]{this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (this.securityMap != null && !this.doesMapNameExist(this.poolName, this.securityMap, this.ccPools)) {
                report.setMessage(localStrings.getLocalString("list.connector.security.maps.securityMapNotFound", "Security map {0} does not exist for connector connection pool {1}. Please give a valid map name.", new Object[]{this.securityMap, this.poolName}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            try {
                List<SecurityMap> securityMaps = this.getAllSecurityMapsForPool(this.poolName, this.ccPools);
                if (securityMaps == null || securityMaps.isEmpty()) break block11;
                if (this.securityMap == null && this.verbose.booleanValue()) {
                    for (SecurityMap sm : securityMaps) {
                        this.listSecurityMapDetails(sm, mp);
                    }
                    break block11;
                }
                if (this.securityMap == null && !this.verbose.booleanValue()) {
                    for (SecurityMap sm : securityMaps) {
                        this.listSecurityMapNames(sm, mp);
                    }
                    break block11;
                }
                for (SecurityMap sm : securityMaps) {
                    if (!sm.getName().equals(this.securityMap)) continue;
                    if (this.verbose.booleanValue()) {
                        this.listSecurityMapDetails(sm, mp);
                    } else {
                        this.listSecurityMapNames(sm, mp);
                    }
                    break;
                }
            }
            catch (Exception e) {
                Logger.getLogger(ListConnectorSecurityMaps.class.getName()).log(Level.SEVERE, "list-connector-security-maps failed", e);
                report.setMessage(localStrings.getLocalString("list.connector.security.maps.fail", "Unable to list security map {0} for connector connection pool {1}", new Object[]{this.securityMap, this.poolName}) + " " + e.getLocalizedMessage());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)e);
                return;
            }
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void listSecurityMapNames(SecurityMap sm, ActionReport.MessagePart mp) {
        ActionReport.MessagePart part = mp.addChild();
        part.setMessage(sm.getName());
    }

    private void listSecurityMapDetails(SecurityMap sm, ActionReport.MessagePart mp) {
        ActionReport.MessagePart part;
        List principalList = sm.getPrincipal();
        List groupList = sm.getUserGroup();
        BackendPrincipal bp = sm.getBackendPrincipal();
        for (String principal : principalList) {
            part = mp.addChild();
            part.setMessage(localStrings.getLocalString("list.connector.security.maps.eisPrincipal", "{0}: EIS principal={1}", new Object[]{sm.getName(), principal}));
        }
        for (String group : groupList) {
            part = mp.addChild();
            part.setMessage(localStrings.getLocalString("list.connector.security.maps.eisGroup", "{0}: EIS user group={1}", new Object[]{sm.getName(), group}));
        }
        ActionReport.MessagePart part2 = mp.addChild();
        part2.setMessage(localStrings.getLocalString("list.connector.security.maps.backendPrincipal", "{0}: backend username={1}, password={2}", new Object[]{sm.getName(), bp.getUserName(), bp.getPassword()}));
    }
}

