/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-resource-adapter-configs")
@Scoped(value=PerLookup.class)
@I18n(value="list.resource.adapter.configs")
public class ListResourceAdapterConfigs
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListResourceAdapterConfigs.class);
    @Inject
    ResourceAdapterConfig[] resources;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (ResourceAdapterConfig r : this.resources) {
                list.add(r.getResourceAdapterName());
            }
            if (list.isEmpty()) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(localStrings.getLocalString("nothingToList", "Nothing to list."));
            } else {
                for (String jndiName : list) {
                    ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                    part.setMessage(jndiName);
                }
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.resource.adapter.config.fail", "Unable to list resource adapter configs") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

