/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="connector-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.connector.resource")
public class ConnectorResourceManager
implements ResourceManager {
    private static final String DESCRIPTION = "description";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConnectorResourceManager.class);
    private String poolName = null;
    private String enabled = Boolean.TRUE.toString();
    private String jndiName = null;
    private String description = null;
    private String objectType = "user";

    public String getResourceType() {
        return "connector-resource";
    }

    /*
     * Unable to fully structure code
     */
    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, Server targetServer, boolean requiresNewTransaction) throws Exception {
        this.setAttributes(attributes);
        if (this.jndiName == null) {
            msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.noJndiName", "No JNDI name defined for connector resource.");
            return new ResourceStatus(1, msg);
        }
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof BindableResource) || !((BindableResource)resource).getJndiName().equals(this.jndiName)) continue;
            msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.duplicate", "A resource named {0} already exists.", new Object[]{this.jndiName});
            return new ResourceStatus(1, msg);
        }
        if (!this.isConnPoolExists(resources, this.poolName)) {
            msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.connPoolNotFound", "Attribute value (pool-name = {0}) is not found in list of connector connection pools.", new Object[]{this.poolName});
            return new ResourceStatus(1, msg);
        }
        if (requiresNewTransaction) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        ConnectorResource newResource = ConnectorResourceManager.this.createResource(param, properties);
                        return newResource;
                    }
                }, (ConfigBeanProxy)resources);
                if (targetServer.isResourceRefExists(this.jndiName)) ** GOTO lbl24
                targetServer.createResourceRef(this.enabled, this.jndiName);
            }
            catch (TransactionFailure tfe) {
                msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.fail", "Connector resource {0} create failed ", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
                return new ResourceStatus(1, msg);
            }
        } else {
            this.createResource(resources, properties);
        }
lbl24:
        // 3 sources

        msg = ConnectorResourceManager.localStrings.getLocalString("create.connector.resource.success", "Connector resource {0} created successfully", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg);
    }

    private ConnectorResource createResource(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        ConnectorResource newResource = this.createConfigBean(param, props);
        param.getResources().add(newResource);
        return newResource;
    }

    private ConnectorResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ConnectorResource newResource = (ConnectorResource)param.createChild(ConnectorResource.class);
        newResource.setJndiName(this.jndiName);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        newResource.setPoolName(this.poolName);
        newResource.setEnabled(this.enabled);
        newResource.setObjectType(this.objectType);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    private void setAttributes(HashMap attributes) {
        this.poolName = (String)attributes.get("pool-name");
        this.enabled = (String)attributes.get("enabled");
        this.jndiName = (String)attributes.get("jndi-name");
        this.description = (String)attributes.get(DESCRIPTION);
        this.objectType = (String)attributes.get("object-type");
    }

    private boolean isConnPoolExists(Resources resources, String poolName) {
        for (Resource resource : resources.getResources()) {
            if (!(resource instanceof ConnectorConnectionPool) || !((ConnectorConnectionPool)resource).getName().equals(poolName)) continue;
            return true;
        }
        return false;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties) throws Exception {
        this.setAttributes(attributes);
        return this.createConfigBean(resources, properties);
    }
}

