/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.MailResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.admin.cli.resources.ResourceUtil;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="mail-resource")
@I18n(value="add.resources")
public class JavaMailResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(JavaMailResourceManager.class);
    private static final String DESCRIPTION = "description";
    private String mailHost = null;
    private String mailUser = null;
    private String fromAddress = null;
    private String jndiName = null;
    private String storeProtocol = null;
    private String storeProtocolClass = null;
    private String transportProtocol = null;
    private String transportProtocolClass = null;
    private String enabled = null;
    private String enabledValueForTarget = null;
    private String debug = null;
    private String description = null;
    @Inject
    private ResourceUtil resourceUtil;

    public String getResourceType() {
        return "mail-resource";
    }

    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, String target, boolean requiresNewTransaction, boolean createResourceRef) throws Exception {
        this.setAttributes(attributes, target);
        if (this.mailHost == null) {
            String msg = localStrings.getLocalString("create.mail.resource.noHostName", "No host name defined for Mail Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.mailUser == null) {
            String msg = localStrings.getLocalString("create.mail.resource.noUserName", "No user name defined for Mail Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.fromAddress == null) {
            String msg = localStrings.getLocalString("create.mail.resource.noFrom", "From not defined for Mail Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (resources.getResourceByName(BindableResource.class, this.jndiName) != null) {
            String msg = localStrings.getLocalString("create.mail.resource.duplicate.1", "A Mail Resource named {0} already exists.", new Object[]{this.jndiName});
            return new ResourceStatus(1, msg, true);
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                    MailResource newResource = JavaMailResourceManager.this.createConfigBean(param, properties);
                    param.getResources().add(newResource);
                    return newResource;
                }
            }, (ConfigBeanProxy)resources);
            if (createResourceRef) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
            String msg = localStrings.getLocalString("create.mail.resource.success", "Mail Resource {0} created.", new Object[]{this.jndiName});
            return new ResourceStatus(0, msg, true);
        }
        catch (TransactionFailure tfe) {
            String msg = localStrings.getLocalString("create.mail.resource.fail", "Unable to create Mail Resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
            return new ResourceStatus(1, msg, true);
        }
    }

    private MailResource createConfigBean(Resources param, Properties props) throws PropertyVetoException, TransactionFailure {
        MailResource newResource = (MailResource)param.createChild(MailResource.class);
        newResource.setJndiName(this.jndiName);
        newResource.setFrom(this.fromAddress);
        newResource.setUser(this.mailUser);
        newResource.setHost(this.mailHost);
        newResource.setEnabled(this.enabled);
        newResource.setStoreProtocol(this.storeProtocol);
        newResource.setStoreProtocolClass(this.storeProtocolClass);
        newResource.setTransportProtocol(this.transportProtocol);
        newResource.setTransportProtocolClass(this.transportProtocolClass);
        newResource.setDebug(this.debug);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        if (props != null) {
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    private void setAttributes(HashMap attributes, String target) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.mailHost = (String)attributes.get("host");
        this.mailUser = (String)attributes.get("user");
        this.fromAddress = (String)attributes.get("from");
        this.storeProtocol = (String)attributes.get("store-protocol");
        this.storeProtocolClass = (String)attributes.get("store-protocol-class");
        this.transportProtocol = (String)attributes.get("transport-protocol");
        this.transportProtocolClass = (String)attributes.get("transport-protocol-class");
        this.debug = (String)attributes.get("debug");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
        this.description = (String)attributes.get(DESCRIPTION);
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties) throws Exception {
        this.setAttributes(attributes, null);
        return this.createConfigBean(resources, properties);
    }
}

