/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.CustomResource;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.cli.resources.ResourceManager;
import org.glassfish.admin.cli.resources.ResourceUtil;
import org.glassfish.api.I18n;
import org.glassfish.resource.common.ResourceStatus;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="custom-resource")
@Scoped(value=PerLookup.class)
@I18n(value="create.custom.resource")
public class CustomResourceManager
implements ResourceManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CustomResourceManager.class);
    private static final String DESCRIPTION = "description";
    @Inject
    private ResourceUtil resourceUtil;
    private String resType = null;
    private String factoryClass = null;
    private String enabled = null;
    private String enabledValueForTarget = null;
    private String description = null;
    private String jndiName = null;

    public String getResourceType() {
        return "custom-resource";
    }

    /*
     * Unable to fully structure code
     */
    public ResourceStatus create(Resources resources, HashMap attributes, final Properties properties, String target, boolean requiresNewTransaction, boolean createResourceRef, boolean requiresValidation) throws Exception {
        this.setAttributes(attributes, target);
        if (this.resType == null) {
            msg = CustomResourceManager.localStrings.getLocalString("create.custom.resource.noResType", "No type defined for Custom Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (this.factoryClass == null) {
            msg = CustomResourceManager.localStrings.getLocalString("create.custom.resource.noFactoryClassName", "No Factory class name defined for Custom Resource.");
            return new ResourceStatus(1, msg, true);
        }
        if (resources.getResourceByName(BindableResource.class, this.jndiName) != null) {
            msg = CustomResourceManager.localStrings.getLocalString("create.custom.resource.duplicate", "A Custom Resource named {0} already exists.", new Object[]{this.jndiName});
            return new ResourceStatus(1, msg, true);
        }
        if (requiresNewTransaction) {
            try {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Resources>(){

                    public Object run(Resources param) throws PropertyVetoException, TransactionFailure {
                        return CustomResourceManager.this.createResource(param, properties);
                    }
                }, (ConfigBeanProxy)resources);
                if (!createResourceRef) ** GOTO lbl23
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
            catch (TransactionFailure tfe) {
                msg = CustomResourceManager.localStrings.getLocalString("create.custom.resource.fail", "Unable to create custom resource {0}.", new Object[]{this.jndiName}) + " " + tfe.getLocalizedMessage();
                return new ResourceStatus(1, msg, true);
            }
        } else {
            this.createResource(resources, properties);
        }
lbl23:
        // 3 sources

        msg = CustomResourceManager.localStrings.getLocalString("create.custom.resource.success", "Custom Resource {0} created.", new Object[]{this.jndiName});
        return new ResourceStatus(0, msg, true);
    }

    private void setAttributes(HashMap attributes, String target) {
        this.jndiName = (String)attributes.get("jndi-name");
        this.resType = (String)attributes.get("res-type");
        this.factoryClass = (String)attributes.get("factory-class");
        this.enabled = target != null ? this.resourceUtil.computeEnabledValueForResourceBasedOnTarget((String)attributes.get("enabled"), target) : (String)attributes.get("enabled");
        this.enabledValueForTarget = (String)attributes.get("enabled");
        this.description = (String)attributes.get(DESCRIPTION);
    }

    private Object createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        CustomResource newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    private CustomResource createConfigBean(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        CustomResource newResource = (CustomResource)param.createChild(CustomResource.class);
        newResource.setJndiName(this.jndiName);
        newResource.setFactoryClass(this.factoryClass);
        newResource.setResType(this.resType);
        newResource.setEnabled(this.enabled);
        if (this.description != null) {
            newResource.setDescription(this.description);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = (Property)newResource.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                newResource.getProperty().add(prop);
            }
        }
        return newResource;
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties) throws Exception {
        this.setAttributes(attributes, null);
        return this.createConfigBean(resources, properties);
    }
}

