/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.connectors.admin.cli;

import com.sun.enterprise.config.serverbeans.ConnectorResource;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.admin.cli.resources.BindableResourcesHelper;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.Cluster;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@Cluster(value={RuntimeType.DAS})
@Service(name="list-connector-resources")
@Scoped(value=PerLookup.class)
@I18n(value="list.connector.resources")
public class ListConnectorResources
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListConnectorResources.class);
    @Inject
    private ConnectorResource[] connectorResources;
    @Param(primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    private BindableResourcesHelper bindableResourcesHelper;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            for (ConnectorResource resource : this.connectorResources) {
                if (!this.bindableResourcesHelper.resourceExists(resource.getJndiName(), this.target)) continue;
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(resource.getJndiName());
            }
            if (report.getTopMessagePart().getChildren().size() == 0) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(localStrings.getLocalString("list.connector.resources.empty", "Nothing to list."));
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.connector.resources.fail", "List connector resources failed") + " " + e.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

