/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.inbound;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.connectors.ActiveResourceAdapter;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.inbound.ActiveInboundResourceAdapter;
import com.sun.enterprise.connectors.inbound.BasicResourceAllocator;
import com.sun.enterprise.connectors.inbound.MessageEndpointFactoryInfo;
import com.sun.enterprise.connectors.inbound.MessageEndpointInvocationHandler;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.MessageListener;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.glassfish.ejb.api.MessageBeanListener;
import org.glassfish.ejb.api.MessageBeanProtocolManager;
import org.glassfish.ejb.spi.MessageBeanClient;

public final class ConnectorMessageBeanClient
implements MessageBeanClient,
MessageEndpointFactory {
    private static final String MESSAGE_ENDPOINT = "javax.resource.spi.endpoint.MessageEndpoint";
    private ConnectorRegistry registry_;
    private MessageBeanProtocolManager messageBeanPM_;
    private final EjbMessageBeanDescriptor descriptor_;
    private final BasicResourceAllocator allocator_;
    private boolean started_ = false;
    private final int CREATED = 0;
    private final int BLOCKED = 1;
    private final int UNBLOCKED = 2;
    private int myState = 0;
    private final long WAIT_TIME = 60000L;
    private static final String RA_MID = "com.sun.enterprise.connectors.inbound.ramid";
    private String beanID_;
    private static final Logger logger = LogDomains.getLogger(ConnectorMessageBeanClient.class, (String)"javax.enterprise.resource.resourceadapter");

    public ConnectorMessageBeanClient(EjbMessageBeanDescriptor descriptor) {
        this.descriptor_ = descriptor;
        this.allocator_ = new BasicResourceAllocator();
        String appName = descriptor.getApplication().getName();
        String moduleID = descriptor.getEjbBundleDescriptor().getModuleID();
        String beanName = descriptor.getName();
        this.beanID_ = appName + ":" + moduleID + ":" + beanName;
        this.registry_ = ConnectorRegistry.getInstance();
    }

    public void setup(MessageBeanProtocolManager messageBeanPM) throws Exception {
        this.messageBeanPM_ = messageBeanPM;
        String resourceAdapterMid = this.descriptor_.getResourceAdapterMid();
        if (resourceAdapterMid == null) {
            resourceAdapterMid = System.getProperty(RA_MID);
        }
        if (resourceAdapterMid == null) {
            resourceAdapterMid = "jmsra";
            logger.fine("No ra-mid is specified, using default JMS Resource Adapter");
        }
        ActiveInboundResourceAdapter aira = this.getActiveResourceAdapter(resourceAdapterMid);
        aira.updateMDBRuntimeInfo(this.descriptor_, this.messageBeanPM_.getPoolDescriptor());
        ResourceAdapter ra = aira.getResourceAdapter();
        ConnectorDescriptor desc = aira.getDescriptor();
        MessageListener msgListener = this.getMessageListener(desc);
        String activationSpecClassName = null;
        if (msgListener != null) {
            activationSpecClassName = msgListener.getActivationSpecClass();
        }
        if (activationSpecClassName != null) {
            if (logger.isLoggable(Level.FINEST)) {
                String msg = "ActivationSpecClassName = " + activationSpecClassName;
                logger.log(Level.FINEST, msg);
            }
            try {
                ActivationSpec activationSpec = this.getActivationSpec(aira, activationSpecClassName);
                activationSpec.setResourceAdapter(ra);
                ConnectorRuntime runtime = ConnectorRuntime.getRuntime();
                runtime.getConnectorBeanValidator().validateJavaBean((Object)activationSpec, resourceAdapterMid);
                aira.validateActivationSpec(activationSpec);
                this.myState = 1;
                ra.endpointActivation((MessageEndpointFactory)this, activationSpec);
                aira.addEndpointFactoryInfo(this.beanID_, new MessageEndpointFactoryInfo(this, activationSpec));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw (Exception)new Exception().initCause(ex);
            }
        } else {
            throw new Exception("Unsupported message listener type");
        }
    }

    private ActivationSpec getActivationSpec(ActiveInboundResourceAdapter aira, String activationSpecClassName) throws Exception {
        ClassLoader cl = aira.getClassLoader();
        Class<?> aClass = cl.loadClass(activationSpecClassName);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "classloader = " + aClass.getClassLoader());
            logger.log(Level.FINEST, "classloader parent = " + aClass.getClassLoader().getParent());
        }
        ActivationSpec activationSpec = (ActivationSpec)aClass.newInstance();
        Set props = ConnectorsUtil.getMergedActivationConfigProperties((EjbMessageBeanDescriptor)this.getDescriptor());
        AccessController.doPrivileged(new SetMethodAction((Object)activationSpec, props));
        return activationSpec;
    }

    private MessageListener getMessageListener(ConnectorDescriptor desc) {
        String msgListenerType = this.getDescriptor().getMessageListenerType();
        if (msgListenerType == null || "".equals(msgListenerType)) {
            msgListenerType = "javax.jms.MessageListener";
        }
        Iterator i = desc.getInboundResourceAdapter().getMessageListeners().iterator();
        MessageListener msgListener = null;
        while (i.hasNext() && !msgListenerType.equals((msgListener = (MessageListener)i.next()).getMessageListenerType())) {
        }
        return msgListener;
    }

    private ActiveInboundResourceAdapter getActiveResourceAdapter(String resourceAdapterMid) throws Exception {
        ActiveResourceAdapter activeRar = this.registry_.getActiveResourceAdapter(resourceAdapterMid);
        if (activeRar == null) {
            ConnectorRuntime crt = ConnectorRuntime.getRuntime();
            crt.loadDeferredResourceAdapter(resourceAdapterMid);
            activeRar = this.registry_.getActiveResourceAdapter(resourceAdapterMid);
        }
        if (activeRar == null) {
            String msg = "Resource adapter " + resourceAdapterMid + " is not deployed";
            throw new ConnectorRuntimeException(msg);
        }
        if (!(activeRar instanceof ActiveInboundResourceAdapter)) {
            throw new Exception("Resource Adapter selected doesn't support Inbound");
        }
        return (ActiveInboundResourceAdapter)activeRar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        logger.logp(Level.FINEST, "ConnectorMessageBeanClient", "start", "called...");
        this.started_ = true;
        this.myState = 2;
        ConnectorMessageBeanClient connectorMessageBeanClient = this;
        synchronized (connectorMessageBeanClient) {
            this.notifyAll();
        }
    }

    public void close() {
        logger.logp(Level.FINEST, "ConnectorMessageBeanClient", "close", "called...");
        this.started_ = false;
        String resourceAdapterMid = this.getDescriptor().getResourceAdapterMid();
        ActiveResourceAdapter activeRar = this.registry_.getActiveResourceAdapter(resourceAdapterMid);
        if (activeRar instanceof ActiveInboundResourceAdapter) {
            ActiveInboundResourceAdapter rar = (ActiveInboundResourceAdapter)activeRar;
            MessageEndpointFactoryInfo info = rar.getEndpointFactoryInfo(this.beanID_);
            if (info != null) {
                rar.getResourceAdapter().endpointDeactivation(info.getEndpointFactory(), info.getActivationSpec());
                rar.removeEndpointFactoryInfo(this.beanID_);
            } else {
                logger.log(Level.FINE, "Not de-activating the end point, since it is not activated");
            }
        }
    }

    private EjbMessageBeanDescriptor getDescriptor() {
        return this.descriptor_;
    }

    public MessageEndpoint createEndpoint(XAResource xa) throws UnavailableException {
        return this.createEndpoint(xa, 60000L);
    }

    public boolean isDeliveryTransacted(Method method) {
        return this.messageBeanPM_.isDeliveryTransacted(method);
    }

    public String toString() {
        return this.beanID_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEndpoint createEndpoint(XAResource xaResource, long timeout) throws UnavailableException {
        ConnectorMessageBeanClient connectorMessageBeanClient = this;
        synchronized (connectorMessageBeanClient) {
            if (this.myState == 1) {
                try {
                    this.wait(timeout);
                }
                catch (Exception e) {
                }
                finally {
                    this.myState = 2;
                }
            }
        }
        if (!this.started_) {
            logger.log(Level.WARNING, "endpointfactory.unavailable");
            throw new UnavailableException("EndpointFactory is currently not available");
        }
        MessageEndpoint endpoint = null;
        try {
            ResourceHandle resourceHandle = this.allocator_.createResource(xaResource);
            MessageBeanListener listener = this.messageBeanPM_.createMessageBeanListener((com.sun.appserv.connectors.internal.api.ResourceHandle)resourceHandle);
            String moduleID = this.getDescriptor().getApplication().getModuleID();
            Class<?> endpointClass = null;
            ClassLoader loader = null;
            try {
                EjbBundleDescriptor moduleDesc = this.getDescriptor().getEjbBundleDescriptor();
                loader = moduleDesc.getClassLoader();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "endpointfactory.loader_not_found", e);
            }
            if (loader == null) {
                loader = Thread.currentThread().getContextClassLoader();
            }
            endpointClass = loader.loadClass(MESSAGE_ENDPOINT);
            String msgListenerType = this.getDescriptor().getMessageListenerType();
            if (msgListenerType == null || "".equals(msgListenerType)) {
                msgListenerType = "javax.jms.MessageListener";
            }
            Class<?> listenerClass = loader.loadClass(msgListenerType);
            MessageEndpointInvocationHandler handler = new MessageEndpointInvocationHandler(listener, this.messageBeanPM_);
            endpoint = (MessageEndpoint)Proxy.newProxyInstance(loader, new Class[]{endpointClass, listenerClass}, (InvocationHandler)handler);
        }
        catch (Exception ex) {
            throw (UnavailableException)new UnavailableException().initCause((Throwable)ex);
        }
        return endpoint;
    }
}

